import { Component } from '@angular/core';
import { Router } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';

import { FormsModule } from '@angular/forms';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { CommonModule } from '@angular/common';


@Component({
  selector: 'app-add-license-code',
  templateUrl: './add-license-code.component.html',
  styleUrls: ['./add-license-code.component.scss'],
  standalone: true,
  imports: [CommonModule, FormsModule, TranslatePipes],
  providers : [TranslatePipes]
})
export class AddLicenseCodeComponent extends Unsub {

  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    private adminService: AdminService,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    private router: Router, loaderService: LoaderService) {
    super(loaderService);


  }
  appInfoSubmit(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = {
        "envato_id": ngForm.value.envato_id,
      };
      this.adminService
        .licenseinfoenter(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              if (res.status == 'success') {
                this.router.navigate(['/admin/login']);
              }
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
}
