import { Component } from '@angular/core';
import { FormsModule, NgForm } from '@angular/forms';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { ActivatedRoute, Router, RouterLink } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { CookieService } from 'ngx-cookie-service';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { CustomersService } from '../../../../shared/services/customers/customers.service';
import { LoaderService } from '../../../../shared/services/loader.service';

import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { NgbAlertModule } from '@ng-bootstrap/ng-bootstrap';
import { CommonModule } from '@angular/common';
import { AnnouncementHolidayBannerComponent } from '../../../../shared/common/includes/announcement-holiday-banner/announcement-holiday-banner.component';


@Component({
  selector: 'app-admintwofactor',
  templateUrl: './admintwofactor.component.html',
  styleUrls: ['./admintwofactor.component.scss'],
  standalone: true,
  imports: [CommonModule, FormsModule, TranslatePipes, RouterLink, NgbAlertModule, AnnouncementHolidayBannerComponent],
  providers : [TranslatePipes]
})
export class AdmintwofactorComponent extends Unsub {
  email;
  data;
  redireurl;
  hideAlertsUntil: { [key: string]: number } = {};
  public sendingResponse: { [key: string]: boolean } = {};
  // otpverify

  constructor(private adminService: AdminService, loaderService: LoaderService,
    private sanitizer: DomSanitizer,
    private customerService: CustomersService,
    private cookieService: CookieService, private router: Router, private toastr: ToastrService, private translate: TranslatePipe, private activeRouter: ActivatedRoute) {
    super(loaderService);
    this.redireurl = this.activeRouter.snapshot.queryParams['returnUrl'];
    this.activeRouter.paramMap
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (params) => {
          this.email = params.get('id');
          this.adminService.adminemailtwofact(this.email).subscribe(res => {
            this.data = res;
            if (res.success) {
              let url = this.redireurl ? this.redireurl : '/admin/dashboard'
              this.router.navigate([url]);
            }
            if (res) {
              res.announcement?.forEach(alert => {
                const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
                if (hideAlertsUntil) {
                  this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
                }
              })
              res.announcements?.forEach(alert => {
                const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
                if (hideAlertsUntil) {
                  this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
                }
              })
              res.holidays?.forEach(alert => {
                const hideAlertsUntil = this.cookieService.get('holiday' + alert.id);
                if (hideAlertsUntil) {
                  this.hideAlertsUntil['holiday' + alert.id] = parseInt(hideAlertsUntil, 10);
                }
              })
            }
          });
        }
      })
  }  
  admintwofactorFn(ngform: NgForm, buttonId) {
    if(!ngform.value.otp){
      this.toastr.error(this.translate.transform("OTP is required"));
      return;
    }
    let data = {
      email: this.email,
      otp: ngform.value.otp
    };
    this.sendingResponse[buttonId] = true;
    this.customerService.otpverify(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res?.success) {
            this.toastr.success(this.translate.transform(res.success));
            let url = this.redireurl ? this.redireurl : '/admin/dashboard'
            this.router.navigate([url]);
          }
          if (res?.error) {
            this.toastr.error(this.translate.transform(res.error));
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }
  resendotp(buttonId) {
    this.sendingResponse[buttonId] = true;
    this.adminService.adminemailtwofactresendotp(this.email).subscribe({
      next: (res) => {
        this.sendingResponse[buttonId] = false;
        if (res?.success) {
          this.toastr.success(this.translate.transform(res.success));
        }
      },
      error: (err) => {
        this.sendingResponse[buttonId] = false;
      }
    })
  }

}
