import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router, RouterLink } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { CookieService } from 'ngx-cookie-service';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';

import { FormsModule } from '@angular/forms';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { NgbAlertModule } from '@ng-bootstrap/ng-bootstrap';
import { SharedModule } from '../../../../shared/shared.module';
import { CommonModule } from '@angular/common';
import { AnnouncementHolidayBannerComponent } from '../../../../shared/common/includes/announcement-holiday-banner/announcement-holiday-banner.component';

@Component({
  selector: 'app-resetpassword',
  templateUrl: './resetpassword.component.html',
  styleUrls: ['./resetpassword.component.scss'],
  standalone: true,
  imports: [CommonModule, FormsModule, NgbAlertModule, RouterLink, TranslatePipes, AnnouncementHolidayBannerComponent],
  providers : [TranslatePipes]
})
export class ResetpasswordComponent extends Unsub implements OnInit {
  data;
  hideAlertsUntil: { [key: string]: number } = {};
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    private adminService: AdminService,
    private router: Router,
    private toastr: ToastrService,
    private activedRoute: ActivatedRoute,
    private translate: TranslatePipe,
    private cookieService: CookieService,
    loaderService: LoaderService,
    private sanitizer: DomSanitizer
  ) {
     /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
super(loaderService);
    activedRoute.params.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.loaderService.showLoader();
        this.adminService
          .getResetData(params['id'])
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.data = res;
              if (res) {
                res.announcement?.forEach(alert => {
                  const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
                  if (hideAlertsUntil) {
                    this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
                  }
                })
                res.announcements?.forEach(alert => {
                  const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
                  if (hideAlertsUntil) {
                    this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
                  }
                })
                res.holidays?.forEach(alert => {
                  const hideAlertsUntil = this.cookieService.get('holiday' + alert.id);
                  if (hideAlertsUntil) {
                    this.hideAlertsUntil['holiday' + alert.id] = parseInt(hideAlertsUntil, 10);
                  }
                })
              }
              this.loaderService.hideLoader();
            },
            error : ()=> this.loaderService.hideLoader()
          });
      },
    });
  }

  ngOnInit(): void {}

  resetForm(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = {
        "token": this.data?.users?.token,
        "email": this.data?.users?.email,
        "password": ngForm.value.password,
        "password_confirmation": ngForm.value.password_confirmation,
      };

      this.adminService
        .resetPsw(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate(['/admin/login']);
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
}
