import { Component } from '@angular/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { FormsModule } from '@angular/forms';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';

@Component({
  selector: 'app-ai-setup',
  standalone: true,
  imports: [AdminPageHeaderComponent, TranslatePipes, FormsModule],
  templateUrl: './ai-setup.component.html',
  styleUrl: './ai-setup.component.scss'
})
export class AiSetupComponent extends Unsub {
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    private adminService: AdminService,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  ngOnInit(): void {
    this.getgoogleanalytics();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => this.getgoogleanalytics()
    });
  }

  public responce: any;
  getgoogleanalytics() {
    this.loaderService.showLoader();
    this.adminService.aisetup().subscribe({
      next: (ele) => {
        this.responce = ele; this.loaderService.hideLoader()
      },
      error: () => this.loaderService.hideLoader()
    });
  }

  GoogleAnalytics(ngForm: any, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      this.adminService
        .geminiApiStore(ngForm.value)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
            if (res.geminiKey) {
              this.toastr.error(this.translate.transform(res.geminiKey));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }else{
      this.toastr.error(this.translate.transform("Invalid values"));
    }
  }
}
