import { Component, OnInit, ViewChild } from '@angular/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { FormsModule, NgForm } from '@angular/forms';
import Swal from 'sweetalert2';
import { SelectionModel } from '@angular/cdk/collections';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { NgbAlertModule, NgbModal, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslationService } from '../../../../shared/services/translation.service';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { CommonModule } from '@angular/common';
import { NgSelectModule } from '@ng-select/ng-select';
import { MaterialeModules } from '../../../../material.module';
import { GeneralSettingsService } from '../../../../shared/services/admin/general-settings.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';

interface emailSettingType {
  name: string;
  value: string;
}

@Component({
  selector: 'app-email-setting',
  templateUrl: './email-setting.component.html',
  styleUrls: ['./email-setting.component.scss'],
  standalone: true,
  imports: [CommonModule, AdminPageHeaderComponent, TranslatePipes, NgSelectModule, MaterialeModules, NgbTooltipModule, NgbAlertModule, FormsModule]
})
export class EmailSettingComponent extends Unsub implements OnInit {
  imapCount = 0;
  public MailDriver = 'SMTP';
  public MailHost: any;
  public MailPort: any;
  public MailUsername: any;
  public MailPassword: any;
  public MailEncryption: any;
  public MailFromName: any;
  public MailFromAddress: any;
  public sendingResponse: { [key: string]: boolean } = {};
  setting;

  displayedColumns: string[] = [
    'sno',
    'select',
    'email',
    'host',
    'category',
    'status',
    'actions',
  ];
  dataSource!: MatTableDataSource<any>;
  selection = new SelectionModel<any>(true, []);
  isloader = true;
  emailSettingOptions: emailSettingType[] = [
    { name: 'SMTP', value: 'smtp' },
    { name: 'Send Mail', value: 'sendmail' },
  ];

  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) sort!: MatSort;

  constructor(
    public generalSettingsService: GeneralSettingsService,
    private AdminService: AdminService,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    private translationService: TranslationService,
    private modalService: NgbModal,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.emailSettingsList();
    this.AdminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.emailSettingsList();
      },
    });
    this.translationService.TranslationStatus.subscribe(() => {
      setTimeout(() => {
        this.paginator._intl.itemsPerPageLabel = this.translate.transform('items per page:');
        this.paginator._intl.nextPageLabel = this.translate.transform('next');
        this.paginator._intl.previousPageLabel = this.translate.transform('previous');
        this.paginator._intl.firstPageLabel = this.translate.transform('first page');
        this.paginator._intl.lastPageLabel = this.translate.transform('last page');
        const of = this.translate.transform('of');
        this.paginator._intl.getRangeLabel = (page: number, pageSize: number, length: number) => {
          if (length == 0 || pageSize == 0) return `0 ${of} ${length}`;
          length = Math.max(length, 0);
          const startIndex = page * pageSize;
          const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;

          return `${startIndex + 1} - ${endIndex} ${of} ${length}`;
        };
      }, 100);
    });
    this.translationService.setTranslationaStatus(true);
  }

  ngOnInit(): void { }

  filterValue = "";
  applyFilter(event: Event) {
    this.filterValue = (event.target as HTMLInputElement).value;
    // this.searchTerms.next(this.filterValue);
  }

  onPaginateTable() {
    this.selection.clear();
    // this.loadData().subscribe();
  }
  /** Whether the number of selected elements matches the total number of rows. */
  isAllSelected() {
    const numSelected = this.selection.selected.length;
    let numRows;
    if (this.dataSource) {
      numRows = this.dataSource.data.length;
    }
    return numSelected === numRows;
  }
  /** Selects all rows if they are not all selected; otherwise clear selection. */
  toggleAllRows() {
    if (this.isAllSelected()) {
      this.selection.clear();
      return;
    }
    this.selection.select(...this.dataSource.data);
  }

  /** The label for the checkbox on the passed row */
  checkboxLabel(row?: any): string {
    if (!row) {
      return `${this.isAllSelected() ? 'deselect' : 'select'} all`;
    }
    return `${this.selection.isSelected(row) ? 'deselect' : 'select'} row ${row?.id + 1
      }`;
  }
  emailSettingsList() {
    this.loaderService.showLoader();
    this.AdminService.gettingSendMailData()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (ele) => {
          this.setting = ele.setting.original;
          this.MailDriver = ele.mail_driver;
          this.MailHost = ele.mail_host;
          this.MailPort = ele.mail_port;
          this.MailUsername = ele.mail_username;
          this.MailPassword = ele.mail_password;
          this.MailEncryption = ele.mail_encryption;
          this.MailFromName = ele.mail_from_name;
          this.MailFromAddress = ele.mail_from_address;
          this.imapCount = ele.imap_count;

          this.category = ele.allCategories;

          // Assign the data to the data source for the table to render
          this.isloader = false;
          this.dataSource = new MatTableDataSource(ele.queryList.data);

          if (this.dataSource) {
            this.paginator.pageSize = ele.queryList.per_page;
            setTimeout(() => {
              this.paginator.pageIndex = ele.queryList.current_page - 1;
              this.paginator.length = ele.queryList.total;
            });
            this.dataSource.paginator = this.paginator;

            // this.sort.disableClear = true; // Used to disbale the original soting of data if enabled (Only ASC, DES).
            this.dataSource.sort = this.sort;
            this.dataSource.sortingDataAccessor = (data, sortHeaderId) => {
              switch (sortHeaderId) {
                case 'user':
                case 'ticketdetails':
                case 'status':
                  return this.nestedProperty(data, sortHeaderId);
                default:
                  return this.nestedCaseInsensitive(data, sortHeaderId);
              }
            }
          }
          this.loaderService.hideLoader()
        },
        error: () => this.loaderService.hideLoader()
      });
  }

  testmail(data: any, buttonId) {
    const PostData = {
      email: data.email,
      _method: 'post',
    };

    this.sendingResponse[buttonId] = true;
    this.AdminService.sendTestMail(PostData)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res?.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
          if (res?.error) {
            this.toastr.error(this.translate.transform(res.error));
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }

  active: any = 1;

  emailSetting(data: NgForm, buttonId) {
    if (data.valid) {
      const PostData = data.value;

      this.sendingResponse[buttonId] = true;

      this.AdminService.emailstore(PostData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  imapStatusChange(event, row, buttonId) {
    const val = event.checked ? '1' : '0';
    this.sendingResponse[buttonId] = true;
    const data = {

      id: row?.id,
      status: val,
    };
    this.AdminService
      .imapStatusChange(row?.id, data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res?.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }

  deleteImap(id: any, buttonId) {
    const data = {

    };

    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.AdminService
          .imapSingleDelete(id, data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              if (res?.success) {
                this.toastr.success(this.translate.transform(res.success));
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }
  massDeleteImap(buttonId) {
    if (!this.selection.selected?.length) {
      this.toastr.error(this.translate.transform('Please select atleast one Imap Setting'));
      return;
    }
    const id: any = [];
    this.selection.selected.map(function (ele) {
      id.push(ele.id);
    });
    const data = {

      id: id,
    };

    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.AdminService
          .imapMassDelete(data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              this.selection.clear();
              if (res.success) {
                this.toastr.success(this.translate.transform(res.success));
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }

  // this is needed to allow sorting on nested properties
  nestedProperty = (data: any, sortHeaderId: string): string | number => {
    return sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
  };
  // this is needed to have caseInsensitive sorting
  caseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = data[sortHeaderId];
    return typeof value === 'string' ? value.toUpperCase() :
      value;
  };
  nestedCaseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
    return typeof value === 'string' ? value.toUpperCase() : value;
  };
  smtpCheck = false;
  category = [];
  createNewImap(content) {
    if (this.setting.IMAP_STATUS !== 'off') {
      const modalRef = this.modalService.open(content, {
        size: 'lg',
        backdrop: 'static', keyboard: false
      });
      modalRef.result.then(
        () => {

        },
        () => {

        }
      );

      this.AdminService.checkSmtp().subscribe({
        next: (res) => {
          if (res?.error) {
            this.smtpCheck = false;
            this.toastr.error(this.translate.transform(res.error));
            this.modalService.dismissAll();
          }
          if (res?.success) {
            this.smtpCheck = true;
          }
        },
        error: (err) => {
          this.smtpCheck = false;
        }
      })
    } else {
      this.toastr.error(this.translate.transform('Please Enable the Email to Ticket To Add Imap.'))
    }
  }
  imapData;
  editImapModel(content, row, buttonId) {

    this.imapData = row;
    const modalRef = this.modalService.open(content, {
      size: 'lg',
      backdrop: 'static', keyboard: false
    });
    modalRef.result.then(
      () => {
        this.imapData = {};
      },
      () => {
        this.imapData = {};
      }
    );
  }

  addNewImap(ngForm, buttonId) {
    this.sendingResponse[buttonId] = true;
    let data = ngForm.value;
    this.AdminService.imapstore(data).subscribe({
      next: (res) => {
        this.sendingResponse[buttonId] = false;
        if (res.success) {
          this.toastr.success(this.translate.transform(res.success));
          this.modalService.dismissAll();
        }
        if (res.error) {
          this.toastr.error(this.translate.transform(res.error));
        }
      },
      error: (err) => {
        this.sendingResponse[buttonId] = false;
      }
    })
  }
  editImap(ngForm, buttonId) {
    this.sendingResponse[buttonId] = true;
    let data = ngForm.value;
    data.imap_id = this.imapData.id;
    this.AdminService.imapstore(data).subscribe({
      next: (res) => {
        this.sendingResponse[buttonId] = false;
        if (res.success) {
          this.toastr.success(this.translate.transform(res.success));
          this.modalService.dismissAll();
        }
        if (res.error) {
          this.toastr.error(this.translate.transform(res.error));
        }
      },
      error: (err) => {
        this.sendingResponse[buttonId] = false;
      }
    })
  }


  // EmailToTicket(ngform: NgForm) {
  //   const data = ngform.value;

  //   this.generalSettingsService.EmailToTicket(data).subscribe({
  //     next: (res) => {
  //       if (res?.success) {
  //         this.toastr.success(this.translate.transform(res.success));
  //       }
  //       if (res?.error) {
  //         this.toastr.error(this.translate.transform(res.error));
  //       }
  //     }
  //   });
  // }
  EmailToTicket(ngform: NgForm) {
    const data = ngform.value;

    this.generalSettingsService.EmailToTicketDeleteCloneTicket(data).subscribe({
      next: (res) => {
        if (res?.success) {
          this.toastr.success(this.translate.transform(res.success));
        }
        if (res?.error) {
          this.toastr.error(this.translate.transform(res.error));
        }
      }
    });
  }
}
