import { SelectionModel } from '@angular/cdk/collections';
import { Component, OnInit, ViewChild } from '@angular/core';
import { MatTableDataSource } from '@angular/material/table';
import { NgbModal, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { ToastrService } from 'ngx-toastr';
import { Observable, Subject, debounceTime, distinctUntilChanged, switchMap, takeUntil, tap } from 'rxjs';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';

import Swal from 'sweetalert2';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { IpListService } from '../../../../shared/services/admin/ip-list.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslationService } from '../../../../shared/services/translation.service';
import { MaterialeModules } from '../../../../material.module';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-ip-list',
  templateUrl: './ip-list.component.html',
  styleUrls: ['./ip-list.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, MaterialeModules, NgbTooltipModule, FormsModule]
})
export class IpListComponent extends Unsub implements OnInit {
  public sendingResponse: { [key: string]: boolean } = {};
  permission: any;

  private searchTerms = new Subject<string>();
  isloader = true;
  dataSource!: MatTableDataSource<any>;
  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) sort!: MatSort;
  selection = new SelectionModel<any>(true, []);
  displayedColumns: string[] = [
    'sno',
    'select',
    'ip',
    'country',
    'entry',
    'types',
    'actions',
  ];
  iplists: any;
  constructor(
    private modalService: NgbModal,
    public ipListService: IpListService,
    private toastr: ToastrService,
    private adminService: AdminService,
    private translate: TranslatePipe,
    private translationService: TranslationService,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.translationService.TranslationStatus.subscribe(() => {
      setTimeout(() => {
        this.paginator._intl.itemsPerPageLabel = this.translate.transform('items per page:');
        this.paginator._intl.nextPageLabel = this.translate.transform('next');
        this.paginator._intl.previousPageLabel = this.translate.transform('previous');
        this.paginator._intl.firstPageLabel = this.translate.transform('first page');
        this.paginator._intl.lastPageLabel = this.translate.transform('last page');
        const of = this.translate.transform('of');
        this.paginator._intl.getRangeLabel = (page: number, pageSize: number, length: number) => {
          if (length == 0 || pageSize == 0) return `0 ${of} ${length}`;
          length = Math.max(length, 0);
          const startIndex = page * pageSize;
          const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;

          return `${startIndex + 1} - ${endIndex} ${of} ${length}`;
        };
      }, 100);
    });
    this.translationService.setTranslationaStatus(true);
  }

  ngOnInit(): void {
    this.ipList();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.ipList();

      },
    });

    this.searchTerms.pipe(
      debounceTime(300),
      distinctUntilChanged(),
      switchMap((): any => this.loadData())
    ).subscribe();
  }

  ipList = () => {
    this.loaderService.showLoader();
    this.isloader = true;
    this.ipListService
      .index(1, 10, this.filterValue)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.permission = res.permissions;
          this.isloader = false; this.iplists = res.queryList;
          this.dataSource = new MatTableDataSource(this.iplists.data);
          if (this.dataSource) {
            this.paginator.pageSize = this.iplists.per_page;
            setTimeout(() => {
              this.paginator.pageIndex = this.iplists.current_page - 1;
              this.paginator.length = this.iplists.total;
            });
            this.dataSource.paginator = this.paginator;

            // this.sort.disableClear = true; // Used to disbale the original soting of data if enabled (Only ASC, DES).
            this.dataSource.sort = this.sort;
            this.dataSource.sortingDataAccessor = (data, sortHeaderId) => {
              switch (sortHeaderId) {
                case 'user' || 'ticketdetails' || 'status':
                  return this.nestedProperty(data, sortHeaderId);
                default:
                  return this.nestedCaseInsensitive(data, sortHeaderId);
              }
            }
          }
          if (!this.permission?.includes('IpBlock Delete')) {
            this.displayedColumns = [
              'sno',
              'ip',
              'country',
              'entry',
              'types',
              'actions',
            ];
          }
          this.loaderService.hideLoader();
        },
        error: () => { this.isloader = true; this.loaderService.hideLoader(); }
      }); this.isloader = true;
  };

  closeResult = '';

  addip(content: any) {
    const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false });
    modalRef.result.then(
      () => {
      },
      () => {
      }
    );
  }


  filterValue = "";
  applyFilter(event: Event) {
    this.filterValue = (event.target as HTMLInputElement).value;
    this.searchTerms.next(this.filterValue);
  }

  /** Whether the number of selected elements matches the total number of rows. */
  isAllSelected() {
    const numSelected = this.selection.selected.length;
    let numRows;
    if (this.dataSource) {
      numRows = this.dataSource.data.length;
    }
    return numSelected === numRows;
  }
  /** Selects all rows if they are not all selected; otherwise clear selection. */
  toggleAllRows() {
    if (this.isAllSelected()) {
      this.selection.clear();
      return;
    }
    this.selection.select(...this.dataSource.data);
  }

  checkboxLabel(row?: any): string {
    if (!row) {
      return `${this.isAllSelected() ? 'deselect' : 'select'} all`;
    }
    return `${this.selection.isSelected(row) ? 'deselect' : 'select'} row ${row?.id + 1
      }`;
  }

  Ipdestroy(id: any, buttonId) {
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.ipListService
          .ipblocklistDestroy(id)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              Swal.fire({
                title: this.translate.transform('Deleted!'),
                text: res.success,
                icon: 'success',
                confirmButtonColor: '#6259ca',
              });
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }

  IpMassdestroy(buttonId) {
    if (!this.selection.selected.length) {
      this.toastr.error(this.translate.transform('Please select atleast one Ticket'));
      return;
    }
    const id: any = [];
    this.selection.selected.map(function (ele) {
      id.push(ele.id);
    });

    const data = {
      id: id,
    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.ipListService
          .massipblocklistDestroy(data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (response) => {
              this.sendingResponse[buttonId] = false;
              this.selection.clear();
              if (response && response?.success) {
                this.toastr.success(this.translate.transform(response?.success));
                this.modalService.dismissAll();
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }

  addIp(data: any, buttonId) {
    if (data.valid) {
      const PostData = {
        ip: data.value.ip,
        types: data.value.types,
      };
      this.sendingResponse[buttonId] = true;

      this.ipListService
        .ipblockliststore(PostData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            this.toastr.success(this.translate.transform(res.success));
            this.modalService.dismissAll();
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  public EditIp: any;
  private Editid: any;
  IpEdit(content, row: any) {
    this.EditIp = row;
    this.Editid = row.id;
    const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false });

    modalRef.result.then(
      () => {
        this.EditIp = '';
        this.Editid = '';
      },
      () => {
        this.EditIp = '';
        this.Editid = '';
      }
    );
  }

  editIp(data: any, buttonId) {
    if (data.valid) {
      this.sendingResponse[buttonId] = true;
      const PostData = {
        "ip": data.value.ip,
        "types": data.value.types,
        "IP_id": this.Editid,
      };

      this.ipListService
        .ipblockliststore(PostData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            this.toastr.success(this.translate.transform(res.success));
            this.modalService.dismissAll();
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  resetipblock(id: any, buttonId) {
    this.sendingResponse[buttonId] = true;
    this.ipListService
      .ipblocklistReset(id)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          this.toastr.success(this.translate.transform(res.success));
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }


  loadData(): Observable<any> {
    this.isloader = true;
    return this.ipListService.index(this.paginator.pageIndex + 1, this.paginator.pageSize, this.filterValue).pipe(
      tap((data: any) => {
        this.isloader = false;
        this.dataSource.data = data.queryList.data;
        setTimeout(() => {
          this.paginator.pageIndex = data.queryList.current_page - 1;
          this.paginator.length = data.queryList.total;
          this.paginator.pageSize = data.queryList.per_page;
        });
      }));
  }

  onPaginateTable() {
    this.selection.clear();
    this.loadData().subscribe();
  }
  // this is needed to allow sorting on nested properties
  nestedProperty = (data: any, sortHeaderId: string): string | number => {
    return sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
  };
  // this is needed to have caseInsensitive sorting
  caseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = data[sortHeaderId];
    return typeof value === 'string' ? value.toUpperCase() :
      value;
  };
  nestedCaseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
    return typeof value === 'string' ? value.toUpperCase() : value;
  };
}
