import { ToastrService } from 'ngx-toastr';
import { Component, OnInit } from '@angular/core';
import { takeUntil } from 'rxjs';
import { FormsModule, NgForm } from '@angular/forms';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { CommonModule } from '@angular/common';
import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';

@Component({
  selector: 'app-ticket-setting',
  templateUrl: './ticket-setting.component.html',
  styleUrls: ['./ticket-setting.component.scss'],
  standalone : true,
  imports : [CommonModule, AdminPageHeaderComponent, TranslatePipes, NgSelectModule, FormsModule]
})
export class TicketSettingComponent extends Unsub implements OnInit {

  public sendingResponse: { [key: string]: boolean } = {};

  public fileTypes: any;
  public userfileTypes: any;

  responce: any;

  constructor(
    public adminService: AdminService,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  ngOnInit(): void {
    this.loaderService.showLoader();
    this.adminService
      .ticketsettingget()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (data) => {
          this.responce = data;
          this.fileTypes = data.setting?.FILE_UPLOAD_TYPES?.split(',');
          this.userfileTypes = data.setting?.USER_FILE_UPLOAD_TYPES?.split(',');
          this.loaderService.hideLoader();
        },
        error: () => this.loaderService.hideLoader()
      });
  }

  TicketSetting(ngForm: NgForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = ngForm.value;
      this.adminService
        .ticketsetting(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  FileSetting(data: any, buttonId) {
    const PostData = {
      usermaxfileupload: data.usermaxfileupload,
      userfileuploadmaxsize: data.userfileuploadmaxsize,
      userfileuploadtypes : data.userfileuploadtypes?.join(','),
      fileuploadmax: data.fileuploadmax,
      maxfileupload: data.maxfileupload,
      fileuploadtypes: data.fileuploadtypes?.join(',')
    };
    this.sendingResponse[buttonId] = true;

    this.adminService
      .filesettingstore(PostData)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if(res.success){
            this.toastr.success(this.translate.transform(res.success));
          }
          if(res.error){
            this.toastr.error(this.translate.transform(res.error));
          }
        },
        error: (err) => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }
}
