import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslatePipe } from '@ngx-translate/core';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { Unsub } from '../../../../shared/class/unsub.class';
import { adminToolbar } from '../../../../shared/data/editortoolbar';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';
import { MaxLengthValidatorDirective } from '../../../../shared/directives/max-length-validator.directive';
interface ResponeLIstType {
  id: number;
  name: string;
  description: string;
}
@Component({
  selector: 'app-canned-response-edit',
  templateUrl: './canned-response-edit.component.html',
  styleUrls: ['./canned-response-edit.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, AngularEditorModule, NgSelectModule, FormsModule, MaxLengthValidatorDirective]
})
export class CannedResponseEditComponent extends Unsub implements OnInit {
  selectedType = "ticket";
  selectType = [
    { id: 1, name: 'Ticket Response', value: 'ticket' },
    { id: 2, name: 'Livechat Response', value: 'livechat' },
  ]
  cannedmessageid: any;
  toolbar: AngularEditorConfig = adminToolbar;
  cannedmessagetitle: any;
  cannedmessageMessage: any;
  cannedmessagestatus: any;
  setting: any;
  public sendingResponse: { [key: string]: boolean } = {};
  id: any;
  public resposeList: ResponeLIstType[] = [
    { id: 1, name: '{{app_name}}', description: 'The Application Name' },
    { id: 2, name: '{{site_url}}', description: 'The Site URL' },
    { id: 3, name: '{{ticket_id}}', description: 'The Ticket ID' },
    {
      id: 4,
      name: '{{ticket_user}}',
      description: 'The Customer <b>name</b> who has opened ticket',
    },
    { id: 5, name: '{{ticket_title}}', description: 'The Ticket Title' },
    { id: 6, name: '{{ticket_priority}}', description: 'The Ticket Priority' },
    {
      id: 7,
      name: '{{user_reply}}',
      description: "The Employee's <b>name</b> who reply to the ticket",
    },
    { id: 8, name: '{{user_role}}', description: "The Employee's Role" },
  ];
  constructor(
    private adminService: AdminService,
    private toastr: ToastrService,
    private activeRoute: ActivatedRoute,
    private router: Router,
    private translate: TranslatePipe,
    loaderService: LoaderService,
    private sanitizer: DomSanitizer
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.activeRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.id = params.get('id');
        this.loaderService.showLoader();
        this.adminService
          .showeditCannedmessages(this.id)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.cannedmessageid = res.cannedmessage.id;
              this.selectedType = res.cannedmessage.responsetype != "livechat" ? "ticket" : "livechat" ;
              this.cannedmessagetitle = res.cannedmessage.title;
              this.cannedmessageMessage = res.cannedmessage.messages;
              this.cannedmessagestatus = res.cannedmessage.status;
              this.setting = res.setting?.original;
              this.loaderService.hideLoader();
            },
            error: () => this.loaderService.hideLoader(),
          });
      },
    });
    this.toolbar.placeholder = this.translate.transform('Enter Your Text...');
  }

  ngOnInit(): void {
  }
  editCannedResponse(ngForm, buttonId) {
    const data = {

      id: ngForm.value.id,
      title: ngForm.value.title,
      message: ngForm.value.message,
      statuscanned: ngForm.value.statuscanned,
      responsetype: ngForm.value.responsetype,
    };

    this.sendingResponse[buttonId] = true;
    this.adminService
      .editCannedmessages(this.id, data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res.error) {
            res.error.errors.forEach((erroMsg) => {
              this.toastr.error(this.translate.transform(erroMsg[0]));
            });
          }
          if (res.success) {
            this.toastr.success(this.translate.transform(res.success));
            this.router.navigate(['/admin/canned-response']);
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }
  handleDataFromChild(value: string) {
    this.cannedmessageMessage = value;
  }
  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }
}
