import { Component, OnInit } from '@angular/core';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { Unsub } from '../../../../shared/class/unsub.class';
import { adminToolbar } from '../../../../shared/data/editortoolbar';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';
import { MaxLengthValidatorDirective } from '../../../../shared/directives/max-length-validator.directive';

@Component({
  selector: 'app-error404-page',
  templateUrl: './error404-page.component.html',
  styleUrls: ['./error404-page.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, AngularEditorModule, FormsModule, MaxLengthValidatorDirective]
})
export class Error404PageComponent extends Unsub implements OnInit {
  erroRes: any;
  public sendingResponse: { [key: string]: boolean } = {};
  toolbar: AngularEditorConfig = adminToolbar;
  constructor(
    private adminService: AdminService,
    private Toastr: ToastrService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.loaderService.showLoader();
    this.adminService
      .error404()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.erroRes = res;
          this.loaderService.hideLoader();
        },
        error: () => this.loaderService.hideLoader()
      });
      this.toolbar.placeholder = this.translate.transform('Enter Your Text...');
  }

  ngOnInit(): void {
  }

  editError404(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = {
        '404subtitle': ngForm.value['404subtitle'],
        '404title': ngForm.value['404title'],
      };
      this.adminService
        .error404Edit(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.Toastr.success(this.translate.transform(res.success));
            }
            if (res.error) {
              this.Toastr.error(this.translate.transform(res.error.error.message));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
}
