import { Component, OnInit } from '@angular/core';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-envatosettings',
  templateUrl: './envatosettings.component.html',
  styleUrls: ['./envatosettings.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, FormsModule]
})
export class EnvatosettingsComponent extends Unsub implements OnInit {
  setting;
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    private adminService: AdminService,
    private tostr: ToastrService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    super(loaderService);
    this.loaderService.showLoader();
    this.adminService.getEnvatoSettings().subscribe({
      next: (res) => {
        this.setting = res.setting?.original;
        this.loaderService.hideLoader();
      },
      error: () => this.loaderService.hideLoader()
    });
  }

  ngOnInit(): void { }

  updateEnvatoSetting(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = ngForm.value;

      this.adminService.expiredsupport(data).subscribe({
        next:
          (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.tostr.success(this.translate.transform(res.success));
            }
            if (res.error) {
              this.tostr.error(this.translate.transform(res.error.errors.message));
            }
          }, 
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
      }
      );
    }
  }
}
