import { SelectionModel } from '@angular/cdk/collections';
import { Component, OnInit, ViewChild } from '@angular/core';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { NgbDate, NgbDateParserFormatter, NgbDatepickerModule, NgbModal, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { ToastrService } from 'ngx-toastr';
import { Observable, Subject, debounceTime, distinctUntilChanged, switchMap, takeUntil, tap } from 'rxjs';
import { FormsModule, NgForm } from '@angular/forms';
import Swal from 'sweetalert2';
import { Router, RouterLink } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslationService } from '../../../../shared/services/translation.service';
import { CommonModule } from '@angular/common';
import { ColorPickerModule } from 'ngx-color-picker';
import { MaterialeModules } from '../../../../material.module';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';

@Component({
  selector: 'app-holidays',
  templateUrl: './holidays.component.html',
  styleUrls: ['./holidays.component.scss'],
  standalone: true,
  imports: [CommonModule, AdminPageHeaderComponent, TranslatePipes, ColorPickerModule, NgbDatepickerModule, MaterialeModules, NgbTooltipModule, RouterLink, FormsModule]
})
export class HolidaysComponent extends Unsub {
  setting;
  public primaryColorToggle: boolean = false;
  public secondaryColorToggle: boolean = false;
  public sendingResponse: { [key: string]: boolean } = {};
  public holidays: any;
  public completeholidays: any[] = [];
  private searchTerms = new Subject<string>();
  displayedColumns: string[] = ['sno', 'select', 'ocassion', 'day', 'date', 'status', 'type', 'actions'];
  dataSource!: MatTableDataSource<any>;
  selection = new SelectionModel<any>(true, []);
  refreshToken$: any;
  currrentDate = { year: 0, month: 0, day: 0 };
  today!: Date;
  permission: any;
  isloader = true;
  public selCat: any = [];
  public assignholidays: any = [];
  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) sort!: MatSort;

  constructor(
    private adminService: AdminService,
    public formatter: NgbDateParserFormatter,
    private toastr: ToastrService,
    private router: Router,
    private modalService: NgbModal,
    private translate: TranslatePipe,
    private translationService: TranslationService,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.translationService.TranslationStatus.subscribe(() => {
      setTimeout(() => {
        this.paginator._intl.itemsPerPageLabel = this.translate.transform('items per page:');
        this.paginator._intl.nextPageLabel = this.translate.transform('next');
        this.paginator._intl.previousPageLabel = this.translate.transform('previous');
        this.paginator._intl.firstPageLabel = this.translate.transform('first page');
        this.paginator._intl.lastPageLabel = this.translate.transform('last page');
        const of = this.translate.transform('of');
        this.paginator._intl.getRangeLabel = (page: number, pageSize: number, length: number) => {
          if (length == 0 || pageSize == 0) return `0 ${of} ${length}`;
          length = Math.max(length, 0);
          const startIndex = page * pageSize;
          const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;

          return `${startIndex + 1} - ${endIndex} ${of} ${length}`;
        };
      }, 100);
    });
    this.translationService.setTranslationaStatus(true);
  }

  ngOnInit(): void {
    this.today = new Date();
    this.currrentDate = { year: this.today.getFullYear(), month: this.today.getMonth() + 1, day: this.today.getDate() };
    this.allHolidays();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.allHolidays();

      }
    });

    this.searchTerms.pipe(
      debounceTime(300),
      distinctUntilChanged(),
      switchMap((): any => this.loadData())
    ).subscribe();
  }
  allHolidays() {
    this.isloader = true;
    this.loaderService.showLoader();
    this.adminService
      .holidays(1, 10, this.filterValue)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next:
          (res) => {
            this.permission = res.permissions;
            this.holidays = res.queryList;
            this.setting = res.setting.original;

            // Assign the data to the data source for the table to render
            this.isloader = false;
            this.dataSource = new MatTableDataSource(this.holidays.data);
            if (this.dataSource) {
              this.paginator.pageSize = this.holidays.per_page;
              setTimeout(() => {
                this.paginator.pageIndex = this.holidays.current_page - 1;
                this.paginator.length = this.holidays.total;
              });
              this.dataSource.paginator = this.paginator;

              // this.sort.disableClear = true; // Used to disbale the original soting of data if enabled (Only ASC, DES).
              this.dataSource.sort = this.sort;
              this.dataSource.sortingDataAccessor = (data, sortHeaderId) => {
                switch (sortHeaderId) {
                  case 'user':
                  case 'ticketdetails':
                  case 'status':
                    return this.nestedProperty(data, sortHeaderId);
                  default:
                    return this.nestedCaseInsensitive(data, sortHeaderId);
                }
              }
            }
            if (!this.permission?.includes('Holidays Delete')) {
              this.displayedColumns = ['sno', 'ocassion', 'day', 'date', 'status', 'type', 'actions'];
            }
            this.loaderService.hideLoader();
          },
        error: () => {
          this.isloader = true;
          this.loaderService.hideLoader()
        },
      }
      );
  }

  filterValue = "";
  applyFilter(event: Event) {
    this.filterValue = (event.target as HTMLInputElement).value;
    this.searchTerms.next(this.filterValue);
  }

  /** Whether the number of selected elements matches the total number of rows. */
  isAllSelected() {
    const numSelected = this.selection.selected.length;
    let numRows;
    if (this.dataSource) {
      numRows = this.dataSource.data.length;
    }
    return numSelected === numRows;
  }
  /** Selects all rows if they are not all selected; otherwise clear selection. */
  toggleAllRows() {
    if (this.isAllSelected()) {
      this.selection.clear();
      return;
    }

    this.selection.select(...this.dataSource.data);
  }

  /** The label for the checkbox on the passed row */
  checkboxLabel(row?: any): string {
    if (!row) {
      return `${this.isAllSelected() ? 'deselect' : 'select'} all`;
    }
    return `${this.selection.isSelected(row) ? 'deselect' : 'select'} row ${row?.id + 1
      }`;
  }

  public primaryColor(data: any): void {
    this.holidayObj['primary_color'] = data.color;
  }
  public secondaryColor(data: any): void {
    this.holidayObj['secondary_color'] = data.color;
  }
  fromDate!: NgbDate | any;
  toDate!: NgbDate | any;
  minFromDate!: { year: number; month: number; day: number; };
  updateFromDatepickerMinDate() {
    const selectedDate = new Date(this.fromDate.year, this.fromDate.month - 1, this.fromDate.day);
    this.minFromDate = { year: selectedDate.getFullYear(), month: selectedDate.getMonth() + 1, day: selectedDate.getDate() };
  }
  holidayObj: any = {
    "holidayid": '',
    "occasion": '',
    "holidaydescription": '',
    'startdate': '',
    "enddate": '',
    "status": '',
    "is_fixed" : '',
    "primary_color": '',
    "secondary_color": ''
  };
  addModelPopup(content: any) {
    const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false });
    modalRef.result.then(
      () => {
        this.holidayObj = {
          "holidayid": '',
          "occasion": '',
          "holidaydescription": '',
          'startdate': '',
          "enddate": '',
          "status": '',
          "is_fixed" : '',
          "primary_color": '',
          "secondary_color": ''
        };
        this.fromDate = null;
        this.toDate = null;
      },
      () => {
        this.holidayObj = {
          "holidayid": '',
          "occasion": '',
          "holidaydescription": '',
          'startdate': '',
          "enddate": '',
          "status": '',
          "is_fixed" : '',
          "primary_color": '',
          "secondary_color": ''
        };
        this.fromDate = null;
        this.toDate = null;
      }
    );
  }
  editModelPopup(content: any, row: any) {

    this.fromDate = this.formatter.parse(row?.startdate);
    this.toDate = this.formatter.parse(row?.enddate);
    this.holidayObj.holidayid = row.id;
    this.holidayObj.occasion = row.occasion;
    this.holidayObj.holidaydescription = row.holidaydescription;
    this.holidayObj.primaray_color = row.primaray_color;
    this.holidayObj.secondary_color = row.secondary_color;
    this.holidayObj.status = row.status;
    this.holidayObj.is_fixed = row.is_fixed;

    const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false });
    modalRef.result.then(
      () => {
        this.holidayObj = {
          "holidayid": '',
          "occasion": '',
          "holidaydescription": '',
          'startdate': '',
          "enddate": '',
          "status": '',
          "is_fixed" : '',
          "primary_color": '',
          "secondary_color": ''
        };
        this.fromDate = null;
        this.toDate = null;
      },
      () => {
        this.holidayObj = {
          "holidayid": '',
          "occasion": '',
          "holidaydescription": '',
          'startdate': '',
          "enddate": '',
          "status": '',
          "is_fixed" : '',
          "primary_color": '',
          "secondary_color": ''
        };
        this.fromDate = null;
        this.toDate = null;
      }
    );
  }

  addholiday(ngForm: NgForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = ngForm.value;
      if (ngForm.value.startdate) {
        data['startdate'] = this.formatter.format(ngForm.value.startdate);
      }
      if (ngForm.value.enddate) {
        data['enddate'] = this.formatter.format(ngForm.value.enddate);
      }
      this.adminService
        .createHolidays(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next:
            (res) => {
              this.sendingResponse[buttonId] = false;
              if (res.errors) {
                this.toastr.error(this.translate.transform(res.errors));
              }
              if (res.success) {
                this.modalService.dismissAll();
                this.toastr.success(this.translate.transform(res.success));
              }
            },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        }
        );
    }
  }
  editholiday(ngForm: NgForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = ngForm.value;
      if (ngForm.value.startdate) {
        data['startdate'] = this.formatter.format(ngForm.value.startdate);
      }
      if (ngForm.value.enddate) {
        data['enddate'] = this.formatter.format(ngForm.value.enddate);
      }
      this.adminService
        .createHolidays(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next:
            (res) => {
              this.sendingResponse[buttonId] = false;
              if (res.errors) {
                this.toastr.error(this.translate.transform(res.errors));
              }
              if (res.success) {
                this.modalService.dismissAll();
                this.toastr.success(this.translate.transform(res.success));
              }
            },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        }
        );
    }
  }
  deleteholiday(row: any, buttonId) {
    const data = {
      id: row?.id,
    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .deleteHolidays(row?.id, data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next:
              (res) => {
                this.sendingResponse[buttonId] = false;
                if (res.success) {
                  this.toastr.success(this.translate.transform(res.success));
                  this.router.navigate(['/admin/holidays']);
                }
              },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          }
          );
      }
    });
  }
  massDeleteholiday(buttonId) {
    if (!this.selection.selected.length) {
      this.toastr.error(this.translate.transform('Please select atleast one holidays'));
      return;
    }
    const id: any = [];
    this.selection.selected.map(function (ele) {
      id.push(ele.id);
    });
    const data = {

      id: id,
    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .massDeleteHolidays(data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              this.selection.clear();
              if (res.success) {
                this.toastr.success(this.translate.transform(res.success));
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          }
          );
      }
    });
  }

  statusUpdate(row) {
    const val = row?.status != '1' ? '1' : '0';
    const data = {
      status: val,
    };
    this.adminService
      .holidaysStatus(row?.id, data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          if (res.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
        },
      });
  }

  loadData(): Observable<any> {
    this.isloader = true;
    return this.adminService.holidays(this.paginator.pageIndex + 1, this.paginator.pageSize, this.filterValue).pipe(
      tap((data: any) => {
        this.isloader = false;
        this.dataSource.data = data.queryList.data;
        setTimeout(() => {
          this.paginator.pageIndex = data.queryList.current_page - 1;
          this.paginator.length = data.queryList.total;
          this.paginator.pageSize = data.queryList.per_page;
        });
      }));
  }

  onPaginateTable() {
    this.selection.clear();
    this.loadData().subscribe();
  }
  override ngOnDestroy() {
    this.modalService?.dismissAll();
  }
  // this is needed to allow sorting on nested properties
  nestedProperty = (data: any, sortHeaderId: string): string | number => {
    return sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
  };
  // this is needed to have caseInsensitive sorting
  caseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = data[sortHeaderId];
    return typeof value === 'string' ? value.toUpperCase() :
      value;
  };
  nestedCaseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
    return typeof value === 'string' ? value.toUpperCase() : value;
  };
}
