import { Routes } from "@angular/router";

export const language: Routes = [
  {
    path: '', loadComponent: ()=>import('./languages/languages.component').then(e => e.LanguagesComponent), data: {
      permission: 'Languages Access'
    }
  },
  {
    path: 'create', loadComponent: ()=>import('./create-language/create-language.component').then(e => e.CreateLanguageComponent), data: {
      permission: 'Languages Create'
    }
  },
  {
    path: 'translate/:id', loadComponent: ()=>import('./translate-language/translate-language.component').then(e => e.TranslateLanguageComponent), data: {
      permission: 'Languages Translate'
    }
  },
  {
    path: 'edit/:id', loadComponent: ()=>import('./edit-language/edit-language.component').then(e => e.EditLanguageComponent), data: {
      permission: 'Languages Edit'
    }
  },
  {
    path: 'insert/:id', loadComponent: ()=>import('./insert-language-value/insert-language.component').then(e => e.InsertLanguageComponent), data: {
      permission: 'Languages Translate'
    }
  }];