import { Component, Input } from '@angular/core';
import { LivechatSocketService } from '../../../../../shared/services/livechat-socket.service';

@Component({
  selector: 'app-comment-message',
  standalone: true,
  imports: [],
  template: `
  <li class="chat-join-notify">
  <span>{{data?.message?.replace(this.autoUserInfo?.name,'You')}} 
  {{this.formatTime(data?.created_at)}}</span>
</li>`
})
export class CommentMessageComponent {
  @Input('data') data:any;
  @Input('autoUserInfo') autoUserInfo:any;
  formatTime;
  constructor(private LivechatSocketService: LivechatSocketService){
      this.formatTime = this.LivechatSocketService.formatTime;
  }
}
