import { CommonModule } from '@angular/common';
import { Component, Input } from '@angular/core';
import { LivechatSocketService } from '../../../../../shared/services/livechat-socket.service';
import { TranslatePipes } from '../../../../../shared/pipes/translate/translate.pipe';

@Component({
  selector: 'app-customer-message-typing',
  standalone: true,
  imports: [CommonModule, TranslatePipes],
  template: `
  <li class="chat-item-start" id="typingIndication">
   <div class="chat-list-inner">
    <div class="chat-user-profile">
      <span class="avatar avatar-md brround" >
        <span class="new-chat-user-letter">{{customerData.userName?.slice(0,1)}}</span>
      </span>
    </div>
    <div class="ms-3">
      <span class="chatting-user-info">
        <span class="chatnameperson">{{customerData?.userName}}</span>
        <!-- <span class="msg-sent-time" >{{formatTime(customerData?.updated_at)}}</span> -->
      </span>
      <div class="main-chat-msg">
        <div class="d-flex">
          <p class="mb-0">{{data.typingMessage}}</p>
          <b class="ms-3">{{'Typing...'}}</b>
        </div>
      </div>
    </div>
  </div>
</li>
`
})

// <!-- <span class="avatar avatar-md brround" style="background-image: url(uploads/profile/${JSON.parse(socket.agentInfo).image ? JSON.parse(socket.agentInfo).image : 'user-profile.png'})"></span> -->
export class CustomerMessageTypingComponent {
  customerData;
  @Input()
  get data(): any {
    return this.customerData;
  }
  set data(value: any) {
    if (value) {
      this.customerData = value;
    }
  }
  formatTime;
  constructor(private LivechatSocketService: LivechatSocketService){
      this.formatTime = this.LivechatSocketService.formatTime;
  }
}
