import { CommonModule } from '@angular/common';
import { Component, Input } from '@angular/core';
import { LivechatSocketService } from '../../../../../shared/services/livechat-socket.service';

@Component({
  selector: 'app-customer-message',
  standalone: true,
  imports: [CommonModule],
  template: `
  <li class="chat-item-start">
     <div class="chat-list-inner">
         <div class="chat-user-profile">
          @if(customerData?.sender_image){
            <span class="avatar avatar-md brround" style="background-image: url(customerData?.livechatdata?.sender_image)">
             </span>
            }@else {
              <span class="avatar avatar-md brround" style="background-image: url(uploads/profile/user-profile.png)">
               </span>
          }
         </div>
         <div class="ms-3">
             <span class="chatting-user-info">
                 <span class="chatnameperson">{{customerData?.livechat_username}}</span>
                 <span class="msg-sent-time">{{formatTime(customerData?.updated_at || customerData?.created_at)}}</span>
             </span>
             <div class="main-chat-msg">
                 @if(customerData?.message_type == "image"){
                  @if(['jpg', 'png', 'jpeg', 'svg'].includes(getFileType(getEncodedMessage(customerData.message)))){
                    <div (click)="AllFileViewer(customerData.message)"
                        [attr.imageSrc]="getEncodedMessage(customerData.message)"
                        class="imageMessageLiveChat"  style=" aspect-ratio: 1; background-repeat: no-repeat; background-color: transparent;background-position: center;background-size: contain;height:15rem"
                        [style.background-image]="'url(' + getEncodedMessage(customerData.message) + ')'">
                    </div>
                  }
                  @else{
                    <a  [href]="customerData.message"  target="_blank"
                        class="uhelp-attach-acion p-2 rounded border lh-1 d-flex align-items-center justify-content-center"
                        download 
                        style="
                        width: 100%;
                        max-height: 55px;
                        border-radius: 5px;
                        height: 65px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        padding: 0.5rem;border:var(--border)">.{{getFileType(customerData.message)}}
                        <i class="fa fa-download"></i>
                    </a>
                  }
                 }
                 @else {
                    <div style="white-space: pre-line;">
                      <p class="mb-0" >{{customerData?.message}}</p>
                    </div>
                 }
             </div>
         </div>
     </div>
  </li>
    @if(imageUrl){
      <div class="liveChatImageViewer">
            <span class="liveChatImageClose" (click)="closePreview()">×</span>
            <img class="liveChatImageTag" [src]="imageUrl">
        </div>
    }
    `
})
export class CustomerMessageComponent {
  customerData;
  @Input()
  get data(): any {
    return this.customerData;
  }
  set data(value: any) {
    if (value) {
      this.customerData = value;
    }
  }
  formatTime;
  constructor(private LivechatSocketService: LivechatSocketService){
      this.formatTime = this.LivechatSocketService.formatTime;
  }
  imageUrl = null;
  AllFileViewer = (res)=>{
    this.imageUrl = res;
  }
  closePreview(){
      this.imageUrl = null;
  }
    
  getEncodedMessage(val): string {
    // Split the URL into base URL and filename
    const baseUrl = val.substring(0, val.lastIndexOf('/') + 1);
    const filename = val.substring(val.lastIndexOf('/') + 1);

    // Encode only the filename part
    const encodedFilename = encodeURIComponent(filename);
    // Combine the base URL with the encoded filename
    let url = baseUrl + encodedFilename;
    return "'" + url + "'";
  }
  getFileType(value): string {
    
    let valueStrip = value.slice(1, value.length -1).split('.');
    let ext = valueStrip[valueStrip.length - 1];    
    return ext?.toLowerCase();
  }
}
