import { Component, ViewChild } from '@angular/core';
import { ActivatedRoute, RouterLink } from '@angular/router';
import { NgbTooltipModule, NgbRatingModule } from '@ng-bootstrap/ng-bootstrap';
import { MaterialeModules } from '../../../../material.module';
import { SelectionModel } from '@angular/cdk/collections';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { TranslatePipe } from '@ngx-translate/core';
import { Subject, takeUntil, debounceTime, distinctUntilChanged, switchMap, Observable, tap, Subscription } from 'rxjs';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslationService } from '../../../../shared/services/translation.service';
import { Unsub } from '../../../../shared/class/unsub.class';
import { LiveChatService } from '../../../../shared/services/admin/livechat.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { AdminTicketTableComponent } from '../../../../shared/common/includes/admin-ticket-table/admin-ticket-table.component';

@Component({
  selector: 'app-livechat-tickets',
  standalone: true,
  imports: [AdminPageHeaderComponent, TranslatePipes, AdminTicketTableComponent],
  templateUrl: './livechat-tickets.component.html',
  styleUrl: './livechat-tickets.component.scss'
})
export class LivechatTicketsComponent extends Unsub {
  public activeTickets: any;
  public alltickets$!: Subscription;
  empid;
  setting;
  timezone;
  displayedColumns: string[] = [
    'id',
    'select',
    'ticketdetails',
    'user',
    'status',
    'assignto',
    'actions',
  ];
  permission: any;
  isloader = true;

  constructor(
    private adminService: AdminService,
    private livechatService: LiveChatService,
    private translate: TranslatePipe,
    private activeRoute: ActivatedRoute,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  ngOnInit(): void {

    this.activeRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.empid = params.get('id');
        this.closedticket(this.empid);
      }
    });
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => this.closedticket(this.empid)
    });
  }
  closedticket(id) {
    this.loaderService.showLoader();
    this.isloader = true;
    this.alltickets$ = this.livechatService
      .livechatticket(id, 1, 10, '')
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.permission = res.permissions;
          this.activeTickets = res.queryList;
          this.timezone = res?.timezonedata;

          // Assign the data to the data source for the table to render
          this.isloader = false;

          this.setting = res.setting?.original;
          if (!this.permission?.includes('Ticket Delete')) {
            this.displayedColumns = [
              'id',
              'ticketdetails',
              'user',
              'status',
              'assignto',
              'actions',
            ];
          }
          this.loaderService.hideLoader();
        },
        error: () => { this.isloader = true; this.loaderService.hideLoader() }
      });
  }

  loadData(params) {
    this.isloader = true;
    this.livechatService.livechatticket(this.empid, params.page, params.size, params.filter).subscribe(
      {
        next: (data: any) => {
          this.isloader = false;
          this.activeTickets = data.queryList;
        },
        error: err => this.isloader = false
      });
  }
}
