import { CommonModule } from '@angular/common';
import { Component, ViewChild } from '@angular/core';
import { RouterLink } from '@angular/router';
import { NgbTooltipModule, NgbRatingModule } from '@ng-bootstrap/ng-bootstrap';
import { MaterialeModules } from '../../../../material.module';
import { SelectionModel } from '@angular/cdk/collections';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { TranslatePipe } from '@ngx-translate/core';
import { Subject, takeUntil, debounceTime, distinctUntilChanged, switchMap, Observable, tap } from 'rxjs';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslationService } from '../../../../shared/services/translation.service';
import { Unsub } from '../../../../shared/class/unsub.class';
import { LiveChatService } from '../../../../shared/services/admin/livechat.service';
import Swal from 'sweetalert2';
import { ToastrService } from 'ngx-toastr';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
@Component({
  selector: 'app-notification-sounds',
  standalone: true,
  imports: [CommonModule, AdminPageHeaderComponent, TranslatePipes, MaterialeModules, NgbTooltipModule, RouterLink, NgbRatingModule],
  templateUrl: './notification-sounds.component.html',
  styleUrl: './notification-sounds.component.scss'
})
export class NotificationSoundsComponent extends Unsub {
  public sendingResponse: { [key: string]: boolean } = {};
  public livechatNotificationSoundsData: any;
  private searchTerms = new Subject<string>();

  displayedColumns: string[] = [
    'sno',
    'select',
    'title',
    'actions',
  ];
  dataSource!: MatTableDataSource<any>;
  selection = new SelectionModel<any>(true, []);
  isloader = true;
  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) sort!: MatSort;

  constructor(private adminService: AdminService, private toastr : ToastrService,private livechatService: LiveChatService,
    private translationService: TranslationService,
    private translate: TranslatePipe,
    loaderService: LoaderService) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.translationService.TranslationStatus.subscribe(() => {
      setTimeout(() => {
        this.paginator._intl.itemsPerPageLabel = this.translate.transform('items per page:');
        this.paginator._intl.nextPageLabel = this.translate.transform('next');
        this.paginator._intl.previousPageLabel = this.translate.transform('previous');
        this.paginator._intl.firstPageLabel = this.translate.transform('first page');
        this.paginator._intl.lastPageLabel = this.translate.transform('last page');
        const of = this.translate.transform('of');
        this.paginator._intl.getRangeLabel = (page: number, pageSize: number, length: number) => {
          if (length == 0 || pageSize == 0) return `0 ${of} ${length}`;
          length = Math.max(length, 0);
          const startIndex = page * pageSize;
          const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;

          return `${startIndex + 1} - ${endIndex} ${of} ${length}`;
        };
      }, 100);
    });
    this.translationService.setTranslationaStatus(true);
  }

  ngOnInit(): void {
    this.livechatnotificationSounds();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.livechatnotificationSounds();
      },
    });
    this.searchTerms.pipe(
      debounceTime(300),
      distinctUntilChanged(),
      switchMap((): any => this.loadData())
    ).subscribe();
  }
  livechatnotificationSounds() {
    this.loaderService.showLoader();
    this.isloader = true;
    this.livechatService.livechatNotificationsSounds(1, 10, this.filterValue)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.livechatNotificationSoundsData = res.queryList;          
          // Assign the data to the data source for the table to render
          this.isloader = false;
          this.dataSource = new MatTableDataSource(this.livechatNotificationSoundsData.data);
          if (this.dataSource) {
            this.paginator.pageSize = this.livechatNotificationSoundsData.per_page;
            setTimeout(() => {
              this.paginator.pageIndex = this.livechatNotificationSoundsData.current_page - 1;
              this.paginator.length = this.livechatNotificationSoundsData.total;
            });
            this.dataSource.paginator = this.paginator;
            
              // this.sort.disableClear = true; // Used to disbale the original soting of data if enabled (Only ASC, DES).
              this.dataSource.sort = this.sort;
              this.dataSource.sortingDataAccessor = (data, sortHeaderId) => {
                switch (sortHeaderId) {
                  case 'user':
                  case 'ticketdetails':
                  case 'status':
                    return this.nestedProperty(data, sortHeaderId);
                  default:
                    return this.nestedCaseInsensitive(data, sortHeaderId);
                }
              }
          }
          this.loaderService.hideLoader();
        },
        error: () => { this.isloader = true; this.loaderService.hideLoader() }
      });
  }
  
  deleteSound(row: any, buttonId) {
    if(row.name == this.currentPlaying && this.currentPlayingSong){
      this.currentPlayingSong.pause();
      this.currentPlayingSong.currentTime = 0;
    }
    const data = {
      sound: row?.name,
    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.livechatService
          .livechatNotificationsSoundsDelete(data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next:
              (res) => {
                this.sendingResponse[buttonId] = false;
                if (res.success) {
                  this.toastr.success(this.translate.transform(res.success));
                }
              },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          }
          );
      }
    });
  }
  massDeleteSound(buttonId) {
    if (!this.selection.selected.length) {
      this.toastr.error(this.translate.transform('Please select atleast one Projects'));
      return;
    }
    const id: any = [];
    this.selection.selected.map((ele) => {
      if(ele.name == this.currentPlaying && this.currentPlayingSong){
        this.currentPlayingSong.pause();
        this.currentPlayingSong.currentTime = 0;
      }
      id.push(ele.name);
    });
    const data = {
      id: id,
    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.livechatService
          .livechatNotificationsMasssoundsDelete(data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              this.selection.clear();
              if (res.success) {
                this.toastr.success(this.translate.transform(res.message));
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          }
          );
      }
    });
  }
  currentPlaying;
  currentPlayingSong : HTMLAudioElement | null = null;

  soundPlayFunction(row){

    if(this.currentPlaying == row.name && !this.currentPlayingSong?.paused){
      this.currentPlayingSong?.pause();
      return;
    }
    if(this.currentPlayingSong?.paused){
      this.currentPlayingSong?.play();
      return;
    }
    if(this.currentPlaying != row.name && this.currentPlayingSong){
      // Used to reset the old song
      this.currentPlayingSong.pause();
      this.currentPlayingSong.currentTime = 0;
    }
    // audioElement.play();
    let href = location.origin;
    let base = document.querySelector('base')?.getAttribute('href');
    
      // Play the clicked audio
    this.currentPlayingSong = new Audio('uploads/livechatsounds/' + row?.name);
    this.currentPlayingSong.play();      
    this.currentPlaying = row.name;

    this.currentPlayingSong.addEventListener('ended', () => {
      this.currentPlaying = null;
      this.currentPlayingSong = null;
    });
  
  }
  filterValue = "";
  applyFilter(event: Event) {
    this.filterValue = (event.target as HTMLInputElement).value;
    this.searchTerms.next(this.filterValue);
  }

  /** Whether the number of selected elements matches the total number of rows. */
  isAllSelected() {
    const numSelected = this.selection.selected.length;
    let numRows;
    if (this.dataSource) {
        numRows = this.dataSource.data.length;
    }
    return numSelected === numRows;
  }
  /** Selects all rows if they are not all selected; otherwise clear selection. */
  toggleAllRows() {
    if (this.isAllSelected()) {
      this.selection.clear();
      return;
    }

    this.selection.select(...this.dataSource.data);
  }

  /** The label for the checkbox on the passed row */
  checkboxLabel(row?: any): string {
    if (!row) {
      return `${this.isAllSelected() ? 'deselect' : 'select'} all`;
    }
    return `${this.selection.isSelected(row) ? 'deselect' : 'select'} row ${row?.id + 1
      }`;
  }
  
  loadData(): Observable<any> {
    this.isloader = true;
    return this.livechatService.livechatNotificationsSounds(this.paginator.pageIndex + 1, this.paginator.pageSize, this.filterValue).pipe(
      tap((data: any) => {
        this.isloader = false;
        this.dataSource.data = data.queryList.data;
        setTimeout(() => {
          this.paginator.pageIndex = data.queryList.current_page - 1;
          this.paginator.length = data.queryList.total;
          this.paginator.pageSize = data.queryList.per_page;
        });
      }));
  }

  onPaginateTable() {
    this.selection.clear();
    this.loadData().subscribe();
  }
  // this is needed to allow sorting on nested properties
  nestedProperty = (data: any, sortHeaderId: string): string | number => {
    return sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
  };
  // this is needed to have caseInsensitive sorting
  caseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = data[sortHeaderId];
    return typeof value === 'string' ? value.toUpperCase() :
      value;
  };
  nestedCaseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
    return typeof value === 'string' ? value.toUpperCase() : value;
  };

  override ngOnDestroy(): void {
    if(this.currentPlayingSong){
      this.currentPlayingSong.pause();
      this.currentPlayingSong.currentTime = 0
    }
  }
}
