import { Component, ElementRef, OnInit, QueryList, ViewChildren } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { takeUntil } from 'rxjs';
import { ToastrService } from 'ngx-toastr';
import { FormBuilder, FormGroup, FormsModule } from '@angular/forms';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { CommonModule } from '@angular/common';
import { NgSelectModule } from '@ng-select/ng-select';
import moment from 'moment-timezone';
import { NgxMatIntlTelInputComponent } from 'ngx-mat-intl-tel-input';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
@Component({
  selector: 'app-edit-employee',
  templateUrl: './edit-employee.component.html',
  styleUrls: ['./edit-employee.component.scss'],
  standalone : true,
  imports : [CommonModule, AdminPageHeaderComponent, TranslatePipes, NgSelectModule, NgxMatIntlTelInputComponent, FormsModule ]
})
export class EditEmployeeComponent extends Unsub implements OnInit {
  timezone;
  userId;
  employeeDetails: any;
  public sendingResponse: { [key: string]: boolean } = {};
  modalService: any;
  Auth: any;
  rolesList: any;
  countries: any;
  timezones: any;
  departmentList: any;
  form: FormGroup;
  skillslist: any[] = [];
  languageslist: any[] = [];
  profileRemoved!: number;

  constructor(private activedRoute: ActivatedRoute, private adminService: AdminService, private toastr: ToastrService, private router: Router, private translate: TranslatePipe, loaderService: LoaderService, public fb: FormBuilder) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);

    this.form = this.fb.group({
      image: null,
    });
    activedRoute.params.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.userId = params['id'];
        this.editEmployee();
      }
    });
    this.timezones = moment.tz.names();
  }

  ngOnInit(): void {
  }

  editEmployee() {
    this.loaderService.showLoader();
    this.adminService.employeeDetailsShow(this.userId).pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: res => {
        if (res) {
          this.Auth = res.authId;
          this.rolesList = res.roles;
          
          this.countries = res.countries;
          // this.timezones = res.timezones;
          this.departmentList = res.departments;
          this.employeeDetails = res.user;
          this.timezone = this.employeeDetails?.timezone;
          this.languageslist = this.employeeDetails?.languagues ? Array.isArray(this.employeeDetails?.languagues) ? this.employeeDetails?.languagues :
            this.employeeDetails?.languagues?.split(',') : [];

          this.skillslist = this.employeeDetails?.skills ? Array.isArray(this.employeeDetails?.skills) ? this.employeeDetails?.skills :
            this.employeeDetails?.skills?.split(',') : [];
        }
        this.loaderService.hideLoader();
      },
      error: () => this.loaderService.hideLoader()
    });

  }

  employeeUpdate(ngForm: any, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const formData: any = new FormData();
      formData.append('image', this.form.controls['image'].value);
      formData.append('firstname', ngForm.value.firstname);
      formData.append('lastname', ngForm.value.lastname);
      formData.append('username', ngForm.value.username);
      formData.append('role', ngForm.value.role);
      formData.append('department', ngForm.value.department);
      formData.append('empid', ngForm.value.empid);
      if(ngForm.value.phone != 'null' && ngForm.value.phone != undefined){
        formData.append('phone', ngForm.value.phone);
      }
      formData.append('email', ngForm.value.email);
      formData.append('country', ngForm.value.country);
      formData.append('timezone', ngForm.value.timezone);
      formData.append('status', ngForm.value.status);
      formData.append('profileRemoved', this.profileRemoved);
      formData.append('dashboard', ngForm.value.dashboard);
      if (ngForm.value?.languagues?.length) {
        formData.append('languages', ngForm.value?.languagues?.length ? ngForm.value.languagues.join(',') : ngForm.value.languagues);
      }
      if (ngForm.value?.skills?.length) {
        formData.append('skills', ngForm.value?.skills?.length ? ngForm.value.skills.join(',') : ngForm.value.skills);
      }

      this.adminService
        .updateEmployee(formData, this.userId)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {             this.sendingResponse[buttonId] = false;              if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate(['/admin/manage-roles/employees-list']);
            }
          },
          error: (err) => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  public timeZoneChanged(timeZone: string): void {
    this.timezone = timeZone;
  }

  changeimage(event: any) {
    const file = (event.target as HTMLInputElement)?.files?.[0];

    this.form.patchValue({
      image: file,
    });
  }
  removeImg(id: number, remove, imgHolder) {
    this.profileRemoved = id
    remove.remove();
    imgHolder.value = "";
  }

  @ViewChildren('filterInput') filterInput!: QueryList<ElementRef>;
  dropdownSearch() {
    this.filterInput.changes.subscribe(res => {
      if (this.filterInput?.first) {
        this.filterInput.first.nativeElement.focus()
      }
    })
  }

  addTagFn(name: any) {
    return name;
  }
  override ngOnDestroy() {
    this.modalService?.dismissAll();
  }
}
