import { Routes } from '@angular/router';

export const manageRoles: Routes = [
      {
        path: "roles-permissions",loadComponent:()=>import('./roles-and-permissions/roles-and-permissions.component').then(e=>e.RolesAndPermissionsComponent), data: {
          permission: 'Roles & Permission Access'
        }
      },
      {
        path: "create-roles",loadComponent:()=>import('./create-roles/create-roles.component').then(e=>e.CreateRolesComponent), data: {
          permission: 'Roles & Permission Create'
        }
      },
      {
        path: "edit-roles/:id",loadComponent:()=>import('./edit-roles/edit-roles.component').then(e=>e.EditRolesComponent), data: {
          permission: 'Roles & Permission Edit'
        }
      },
      {
        path: "employees-list",loadComponent:()=>import('./employees-list/employees-list.component').then(e=>e.EmployeesListComponent), data: {
          permission: 'Employee Access'
        }
      },
      {
        path: "create-employee",loadComponent:()=>import('./create-employee/create-employee.component').then(e=>e.CreateEmployeeComponent), data: {
          permission: 'Employee Create'
        }
      },
      {
        path: "edit-employee/:id",loadComponent:()=>import('./edit-employee/edit-employee.component').then(e=>e.EditEmployeeComponent), data: {
          permission: 'Employee Access'
        }
      },
      {
        path: "employee-upload-list",loadComponent:()=>import('./employee-upload-list/employee-upload-list.component').then(e=>e.EmployeeUploadListComponent), data: {
          permission: 'Employee Importlist'
        }
      },
];