import { Component, ElementRef, ViewChild, viewChild } from '@angular/core';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { Unsub } from '../../../../shared/class/unsub.class';
import { LoaderService } from '../../../../shared/services/loader.service';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormBuilder, FormGroup, FormsModule, NgForm } from '@angular/forms';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { takeUntil } from 'rxjs';
import { ToastrService } from 'ngx-toastr';
import { TranslatePipe } from '@ngx-translate/core';
import { TranslationService } from '../../../../shared/services/translation.service';
import { NgSelectModule } from '@ng-select/ng-select';
import { FlatpickrDirective, provideFlatpickrDefaults } from 'angularx-flatpickr';
import { Router } from '@angular/router';

@Component({
  selector: 'app-create-invoice',
  standalone: true,
  imports: [TranslatePipes, AdminPageHeaderComponent, FormsModule, NgSelectModule, FlatpickrDirective],
  providers: [provideFlatpickrDefaults()],
  templateUrl: './create-invoice.component.html',
  styleUrl: './create-invoice.component.scss'
})
export class CreateInvoiceComponent extends Unsub {
  @ViewChild('ticketSection', { static: false }) ticketSection!: ElementRef;
  @ViewChild('datediv', { static: false }) datediv!: ElementRef;
  taxPercent;
  today = new Date();
  isloader = true;
  subtotal;
  finalPrice;
  setting;
    form: FormGroup;
  customers;
  ticketData = [];
  statusOptions = [
    { name: 'Paid', value: 'paid' },
    { name: 'Pending', value: 'pending' },
  ];
  symbol;
  constructor(
    public router: Router,
    loaderService: LoaderService, private adminService: AdminService, private toastr: ToastrService,
    private translate: TranslatePipe, private translationService: TranslationService, public fb: FormBuilder) {
    super(loaderService);
    this.form = this.fb.group({
      image: null,
    });
  }
  public sendingResponse: { [key: string]: boolean } = {};


  ngOnInit(): void {
    this.allProjects();
  }
  allProjects() {
    this.isloader = true;
    this.loaderService.showLoader();
    this.adminService
      .createInvoice()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next:
          (res) => {
            this.setting = res.setting;
            this.symbol = res.symbol;
            this.customers = res.customers;
          },
        error: () => {
          this.isloader = true;
          this.loaderService.hideLoader()
        },
      }
      );
  }
  clcompanyName;
  clemail;
  clmobile;
  cltaxName;
  cltaxId;
  claddress;
  clcountry;
  updateUser(selectedValue: any) {
    if (selectedValue.id) {
      this.clcompanyName = selectedValue.companyName;
      this.clemail = selectedValue.email;
      this.clmobile = selectedValue.phone;
      this.cltaxName = selectedValue.taxName;
      this.cltaxId = selectedValue.taxId;
      this.claddress = selectedValue.Address;
      this.clcountry = selectedValue.country;
      if (selectedValue.tickets && selectedValue.tickets.length > 0) {
        this.ticketSection.nativeElement.style.display = 'block';
        this.ticketData = selectedValue.tickets;
      } else {
        this.ticketData = [];
        this.ticketSection.nativeElement.style.display = 'none';
      }
    }
  }
  updateStatus(selectedValue: any) {
    if (selectedValue.value == 'paid') {
      this.datediv.nativeElement.style.display = 'block';
    } else {
      this.datediv.nativeElement.style.display = 'none';

    }
  }

  createInvoice(ngForm: NgForm, buttonId) {
    console.log(ngForm.value);
    
      let formData = new FormData();
  
                formData.append('image', this.form.controls['image'].value);
                for (const key in ngForm.value) {
                  if (ngForm.value.hasOwnProperty(key)) {
                      formData.append(key, ngForm.value[key]);
                  }
              }
      this.sendingResponse[buttonId] = true;
      this.adminService
        .customInvoicesStore(formData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next:
            (res) => {
              this.sendingResponse[buttonId] = false;
              if (res.errors) {
                this.toastr.error(this.translate.transform(res.errors));
              }
              if (res.success) {
                this.toastr.success(this.translate.transform(res.success));
                this.router.navigate(['/admin/payments/custom-invoices']);
              }
            },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        }
        );
  }

  rows: any[] = [];

  getRandomUniqueId(): number {
    return Math.floor(Math.random() * 1000) + 1; // Simple random unique ID generator
  }

  // Function to add a new row
  addRow(): void {
    const newRowId = this.getRandomUniqueId();
    this.rows.push({
      id: newRowId,
      title: '',
      price: '',
      quantity: 1,
      amount: ''
    });
  }

  // Function to remove a row by its ID
  removeRow(rowId: number): void {
    this.rows = this.rows.filter(row => row.id !== rowId);
  }

  // Handle price or quantity change and update amount
  handlePriceQuantityChange(event, type, counter?): void {
    const price = parseFloat((document.getElementById(`updateyo${counter ? counter : ''}`) as HTMLInputElement)?.value);
    const quantity = parseInt((document.getElementById(`quantity${counter ? counter : ''}`) as HTMLInputElement)?.value);
    if (!isNaN(price) && !isNaN(quantity)) {
      const amount = price * quantity;
      let amountEle = document.getElementById(`amount${counter ? counter : ''}`) as HTMLInputElement;
      amountEle.value = amount.toFixed(2); // Update amount field
      this.updateFinalAmount();
    } else {

      let amountEle = document.getElementById(`amount${counter ? counter : ''}`) as HTMLInputElement;
      amountEle.value = '';
    }
  }

  // Update the final amount
  updateFinalAmount() {
    // return this.rows.reduce((total, row) => total + (row.amount || 0), 0);
    let totalPrice = 0;

    const price = parseFloat((document.getElementById(`updateyo`) as HTMLInputElement)?.value) || 0;
    const quantity = parseInt((document.getElementById(`quantity`) as HTMLInputElement)?.value) || 0;
    const amount = price * quantity;
    totalPrice += amount;

    // Loop through rows and calculate amounts
    this.rows.forEach((row) => {
      const price = parseFloat(row.price.toString()) || 0;
      const quantity = parseInt(row.quantity.toString()) || 0;
      const amount = price * quantity;
      row.amount = amount;
      totalPrice += amount;
    });

    this.subtotal = totalPrice.toFixed(2);
    // Add tax if applicable
    if (this.taxPercent) {
      totalPrice += (totalPrice * this.taxPercent) / 100;
    }
    this.finalPrice = totalPrice.toFixed(2);
  }
  handleTaxPercentChange = (e) => {
    this.taxPercent = e.target.value;
    this.updateFinalAmount();
  };

  invoiceLogoFn(event) {
      const preview = document.getElementById('logoPreview') as any;
      const placeholder = document.getElementById('uploadPlaceholder');
      const deleteButton = document.getElementById('deleteImage');

      const file = (event.target as HTMLInputElement)?.files?.[0];
      this.form.patchValue({
        image: file,
      });

      if (file && file.type.startsWith('image/')) {
        const reader = new FileReader();
        reader.onload = (e) => {
          preview.src = e.target.result;
          preview.classList.remove('d-none');
          deleteButton.classList.remove('d-none');
          placeholder.classList.add('d-none');
        };

        reader.readAsDataURL(file);
      } else {
        this.resetImage();
      }
  }
  resetImage(){
    const preview = document.getElementById('logoPreview') as any;
    const placeholder = document.getElementById('uploadPlaceholder');
    const deleteButton = document.getElementById('deleteImage');
    const fileInput = document.getElementById('invoiceLogo') as any;

    // Reset file input and preview
    fileInput.value = '';
    preview.src = '';
    this.form.reset({});
    preview.classList.add('d-none');
    placeholder.classList.remove('d-none');
    deleteButton.classList.add('d-none');
  }
}
