import { Component, OnInit, Input, QueryList, ViewChildren } from '@angular/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { NgbDropdownModule, NgbModal, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import Swal from 'sweetalert2';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { adminToolbar } from '../../../../shared/data/editortoolbar';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { GuestService } from '../../../../shared/services/guest.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { CommonModule } from '@angular/common';
import { RouterLink } from '@angular/router';
import { DateAgoPipe } from '../../../../shared/pipes/date-ago/date-ago.pipe';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { ImageUploadComponent } from '../../../../shared/common/includes/image-upload/image-upload.component';
import { MinLengthValidatorDirective } from '../../../../shared/directives/min-length-validator.directive';
import { MaxLengthValidatorDirective } from '../../../../shared/directives/max-length-validator.directive';
import { SharedModule } from '../../../../shared/shared.module';
import { NgSelectModule } from '@ng-select/ng-select';

@Component({
  selector: 'app-conversations',
  templateUrl: './conversations.component.html',
  styleUrls: ['./conversations.component.scss'],
  standalone: true,
  imports: [CommonModule, DateAgoPipe, TranslatePipes, RouterLink, AngularEditorModule, NgbTooltipModule, ImageUploadComponent, MinLengthValidatorDirective, NgbDropdownModule, MaxLengthValidatorDirective, SharedModule, NgSelectModule]
})
export class ConversationsComponent extends Unsub implements OnInit {
  @Input() user: any; // decorate the property with @Input()
  @Input() permissions: any; // decorate the property with @Input()
  @Input() ticketDataParent: any; // decorate the property with @Input()
  @Input() comments: any; // decorate the property with @Input()
  @Input() setting: any; // decorate the property with @Input()
  // @Input() languages: any; // decorate the property with @Input()
  language;
  @Input()
  get languages(): any {
    return this.language;
  }
  set languages(value: any) {
    if (value) {
      this.language = value;
    }
  }
  @ViewChildren('tickettoarticle') tickettoarticle!: QueryList<any>;
  toolbar: AngularEditorConfig = adminToolbar;
  now = new Date();
  timezone;
  url = "";
  ticketName: any[] = [];
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    private adminService: AdminService,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    private guestService: GuestService,
    private modalService: NgbModal, loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.toolbar.placeholder = this.translate.transform('Enter Your Text...');

    this.url = location.origin + document.querySelector('base')?.getAttribute('href');
  }

  ngOnInit(): void {
    this.timezone = this.ticketDataParent?.timezonedata;
  }

  comment;
  reopenTkt = false;
  ratingonoff = false;
  currentStatus = 'Inprogress';
  ratingStatus(event) {
    switch (event) {
      case 'Inprogress':
        this.ratingonoff = false;
        this.reopenTkt = false;
        break;
      case 'Solved':
        this.ratingonoff = true;
        this.reopenTkt = true;
        break;
      case 'On-Hold':
        this.ratingonoff = false;
        this.reopenTkt = false;
        break;
    }
  }

  editRpl(content, comment, status) {
    this.comment = comment;
    this.currentStatus = status;
    this.ratingStatus(status);
    const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false, size: 'lg' });
    modalRef.result.then(
      () => {
        this.comment = '';
        this.mediaRemoved = [];
      },
      () => {
        this.comment = '';
        this.mediaRemoved = [];
      }
    );
  }
  mediaRemoved: number[] = [];
  onImageUploaded(value) {
    this.ticketName = value.ticketName;
    if (value.mediaremoveIds) {
      value.mediaremoveIds.forEach(e => this.mediaRemoved.push(e.id))
    }
  }
  commentData(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;

      const formData: any = new FormData();
      formData.append('editcomment', ngForm.value.editcomment);
      formData.append('status', ngForm.value.status);
      formData.append('reopen_on_off', ngForm.value.reopen_on_off);
      formData.append('rating_on_off', ngForm.value.rating_on_off);
      for (let i = 0; i < this.ticketName?.length; i++) {
        formData.append('comments[]', this.ticketName[i]);
      }
      formData.append('mediaRemoved', this.mediaRemoved)
      this.adminService.updatereplay(this.comment?.id, formData).pipe(takeUntil(this.unSubscribe$)).subscribe({
        next:
          (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.modalService.dismissAll();
              ngForm.reset();
            }
            if (res?.error?.errors) {
              for (const el in res.error.errors) {
                this.toastr.error(this.translate.transform(res.error.errors[el]));
              }
            }
          },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      }
      );
    }
  }
  deleteCommnet(id, buttonId) {
    const data = {};
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure you want to Delete?'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .deletecomment(id, data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (response) => {
              this.sendingResponse[buttonId] = false;
              if (response && response?.success) {
                this.toastr.success(this.translate.transform(response?.success));
              }
            }, error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }
  latestcommentimgdelete(id) {
    this.adminService.latestcommentimgdelete(id).subscribe({
      next: (res) => {
        this.toastr.success(this.translate.transform(res.success));
      }
    })
  }

  downloadFile(id, image) {
    this.guestService.image(id, image).subscribe({
      next: (res: Blob) => {
        const blobUrl = window.URL.createObjectURL(res);
        const link = document.createElement('a');
        link.href = blobUrl;
        link.setAttribute('download', image); // Set a default filename, customize as needed
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
        window.URL.revokeObjectURL(blobUrl);
      }
    })
  }
  emailtoticketdownload(id, image) {
    this.guestService.emailtoticketdownload(id, image).subscribe({
      next: (res: Blob) => {
        const blobUrl = window.URL.createObjectURL(res);
        const link = document.createElement('a');
        link.href = blobUrl;
        link.setAttribute('download', image); // Set a default filename, customize as needed
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
        window.URL.revokeObjectURL(blobUrl);
      }
    })
  }
  textToTranslate;
  translateModel(content, row) {
    this.textToTranslate = row;
    this.modalService.open(content, { backdrop: 'static', keyboard: false, size: 'lg' });
  }

  translateFn(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      let data = {
        text: this.textToTranslate.comment,
        target_lang: ngForm.value.languages,
        user: 'employee',
      }
      this.adminService.translate(data).pipe(takeUntil(this.unSubscribe$)).subscribe({
        next:
          (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.modalService.dismissAll();

              const comment = this.comments.find(comment => comment.id === this.textToTranslate.id);
              if (comment) {
                comment.comment = res.translated_text;
              }
            }
            if (res.message) {
              this.toastr.error(this.translate.transform('Translation failed: ' + res.message));
            }
            if (res?.error?.errors) {
              for (const el in res.error.errors) {
                this.toastr.error(this.translate.transform(res.error.errors[el]));
              }
            }
            else if (res.errors) {
              // Iterate through each error key (e.g., subcategoryname)
              Object.keys(res.errors).forEach(key => {
                // If there are errors for that key, display them
                res.errors[key].forEach((error: string) => {
                  this.toastr.error(this.translate.transform(error));
                });
              });
            }
          },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      }
      );
    }
  }
  override ngOnDestroy() {
    this.modalService?.dismissAll();
  }
}
