import { SelectionModel } from '@angular/cdk/collections';
import { Component, OnInit, ViewChild } from '@angular/core';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { Router, RouterLink } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { Observable, Subject, Subscription, debounceTime, distinctUntilChanged, switchMap, tap } from 'rxjs';
import Swal from 'sweetalert2';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslationService } from '../../../../shared/services/translation.service';
import { CommonModule, DatePipe } from '@angular/common';
import { NgbPopoverModule, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { FormsModule } from '@angular/forms';
import { MaterialeModules } from '../../../../material.module';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { DateAgoPipe } from '../../../../shared/pipes/date-ago/date-ago.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { TimezonePipe } from '../../../../shared/pipes/timzone.pipe';

@Component({
  selector: 'app-trashed-tickets',
  templateUrl: './trashed-tickets.component.html',
  styleUrls: ['./trashed-tickets.component.scss'],
  standalone : true,
  imports : [CommonModule, TranslatePipes, DateAgoPipe, RouterLink, NgbTooltipModule, NgbPopoverModule, FormsModule, MaterialeModules, AdminPageHeaderComponent, TimezonePipe ],
  providers: [DatePipe]
})
export class TrashedTicketsComponent extends Unsub implements OnInit {
  public alltrashedTickets: any;
  public sendingResponse: { [key: string]: boolean } = {};
  private searchTerms = new Subject<string>();
  public alltrashedTickets$!: Subscription;
  public assignedMem: any = [];
  setting;
  isloader = true;
  public ticketDetails: any;
  public userDetails: any;
  timezone;
  displayedColumns: string[] = [
    'id',
    'select',
    'ticketdetails',
    'user',
    'status',
    'actions',
  ];
  dataSource!: MatTableDataSource<any>;
  selection = new SelectionModel<any>(true, []);
  permission: any;
  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) sort!: MatSort;

  constructor(
    private adminService: AdminService,
    private router: Router,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    private translationService: TranslationService,
    loaderService: LoaderService
  ) {
    super(loaderService);
    this.translationService.TranslationStatus.subscribe(() => {
      setTimeout(() => {
        this.paginator._intl.itemsPerPageLabel = this.translate.transform('items per page:');
        this.paginator._intl.nextPageLabel = this.translate.transform('next');
        this.paginator._intl.previousPageLabel = this.translate.transform('previous');
        this.paginator._intl.firstPageLabel = this.translate.transform('first page');
        this.paginator._intl.lastPageLabel = this.translate.transform('last page');
        const of = this.translate.transform('of');
        this.paginator._intl.getRangeLabel = (page: number, pageSize: number, length: number) => {
          if (length == 0 || pageSize == 0) return `0 ${of} ${length}`;
          length = Math.max(length, 0);
          const startIndex = page * pageSize;
          const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;

          return `${startIndex + 1} - ${endIndex} ${of} ${length}`;
        };
      }, 100);
    });
    this.translationService.setTranslationaStatus(true);
  }

  ngOnInit(): void {
    this.mytrashedtickets();
    this.adminService.RefreshRquestAdmin$.subscribe({
      next: () => {
        this.mytrashedtickets();
      },
    });

    this.searchTerms.pipe(
      debounceTime(300),
      distinctUntilChanged(),
      switchMap((): any => this.loadData())
    ).subscribe();
  }
  mytrashedtickets() {
    this.loaderService.showLoader();
    this.alltrashedTickets$ = this.adminService.myTrashedTickets(1, 10, this.filterValue).subscribe({
      next: (res) => {
        this.permission = res.permissions;
        this.alltrashedTickets = res.queryList.data;
        // Assign the data to the data source for the table to render
        this.isloader = false;
        this.dataSource = new MatTableDataSource(this.alltrashedTickets);
        this.setting = res.setting?.original;
        this.timezone = res?.timezonedata;

        if (this.dataSource) {
          this.paginator.pageSize = res.queryList.per_page;
          setTimeout(() => {
            this.paginator.pageIndex = res.queryList.current_page - 1;
            this.paginator.length = res.queryList.total;
          });
          this.dataSource.paginator = this.paginator;
          
              this.dataSource.sort = this.sort;
        }
        this.loaderService.hideLoader();
      },
      error: () => {
        this.isloader = true;
        this.loaderService.hideLoader();
      },
    });
  }

  filterValue = "";
  applyFilter(event: Event) {
    this.filterValue = (event.target as HTMLInputElement).value;
    this.searchTerms.next(this.filterValue);
  }

  /** Whether the number of selected elements matches the total number of rows. */
  isAllSelected() {
    const numSelected = this.selection.selected.length;
    let numRows;
    if (this.dataSource) {
        numRows = this.dataSource.data.length;
    }
    return numSelected === numRows;
  }
  /** Selects all rows if they are not all selected; otherwise clear selection. */
  toggleAllRows() {
    if (this.isAllSelected()) {
      this.selection.clear();
      return;
    }

    this.selection.select(...this.dataSource.data);
  }

  /** The label for the checkbox on the passed row */
  checkboxLabel(row?: any): string {
    if (!row) {
      return `${this.isAllSelected() ? 'deselect' : 'select'} all`;
    }
    return `${this.selection.isSelected(row) ? 'deselect' : 'select'} row ${row?.id + 1
      }`;
  }

  deleteTicketPermanent(row: any, buttonId) {
    const data = {

    };

    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService.myTrashedTicketsDelete(data, row?.id).subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
      }
    });
  }
  restoreDelete(row: any, buttonId) {
    const data = {

    };

    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your ticket will be restored!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Restore it!'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService.myTrashedTicketsRestore(data, row?.id).subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
      }
    });
  }
  massDeleteTicketPermanent(buttonId) {
    if (!this.selection.selected.length) {
      this.toastr.error(this.translate.transform('Please select atleast one Ticket'));
      return;
    }
    const id: any = [];
    this.selection.selected.map(function (ele) {
      id.push(ele.id);
    });
    const data = {

      id: id,
    };

    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService.myTrashedTicketsMassDelete(data).subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            this.selection.clear();
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
      }
    });
  }
  massRestoreDelete(buttonId) {
    if (!this.selection.selected.length) {
      this.toastr.error(this.translate.transform('Please select atleast one Ticket'));
      return;
    }
    const id: any = [];
    this.selection.selected.map(function (ele) {
      id.push(ele.id);
    });
    const data = {

      id: id,
    };

    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your ticket will be restored!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('restore it!'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService.myTrashedTicketsMassRestore(data).subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            this.selection.clear();
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
      }
    });
  }


  loadData(): Observable<any> {
    this.isloader = true;
    return this.adminService.myTrashedTickets(this.paginator.pageIndex + 1, this.paginator.pageSize, this.filterValue).pipe(
      tap((data: any) => {
        this.isloader = false;
        this.dataSource.data = data.queryList.data;
        setTimeout(() => {
          this.paginator.pageIndex = data.queryList.current_page - 1;
          this.paginator.length = data.queryList.total;
          this.paginator.pageSize = data.queryList.per_page;
        });
      }));
  }

  onPaginateTable() {
    this.selection.clear();
    this.loadData().subscribe();
  }
  // this is needed to allow sorting on nested properties
  nestedProperty = (data: any, sortHeaderId: string): string | number => {
    return sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
  };
  // this is needed to have caseInsensitive sorting
  caseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = data[sortHeaderId];
    return typeof value === 'string' ? value.toUpperCase() :
      value;
  };
  nestedCaseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
    return typeof value === 'string' ? value.toUpperCase() : value;
  };
}
