import { Component, OnInit } from '@angular/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Router, RouterLink } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { CustomersService } from '../../../../shared/services/customers/customers.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { CommonModule } from '@angular/common';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { FormsModule } from '@angular/forms';


@Component({
  selector: 'app-forgot-password',
  templateUrl: './forgot-password.component.html',
  styleUrls: ['./forgot-password.component.scss'],
  standalone : true,
  imports: [CommonModule, TranslatePipes, RouterLink, FormsModule]
})
export class ForgotPasswordComponent extends Unsub implements OnInit {
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    private customerService: CustomersService,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    private router: Router, loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  ngOnInit(): void { }

  forgotPassword(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = {
        email: ngForm.value.email,

      };

      this.customerService
        .forgotPassword(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
              if (res?.['redirect']) {
                this.router.navigate(['/']);
              }
              this.router.navigate(['/customer/login']);
            }
            if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
}
