import { Component, OnInit, ViewChild } from '@angular/core';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../shared/class/unsub.class';
import { CaptchaService } from '../../../shared/services/admin/captcha.service';
import { GuestService } from '../../../shared/services/guest.service';
import { LoaderService } from '../../../shared/services/loader.service';

import { RouterLink } from '@angular/router';
import { RecaptchaModule, RecaptchaV3Module } from 'ng-recaptcha';
import { FormsModule } from '@angular/forms';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { ManualcaptchaComponent } from '../../../shared/common/includes/manualcaptcha/manualcaptcha.component';
import { SharedModule } from '../../../shared/shared.module';


@Component({
  selector: 'app-contact-us',
  templateUrl: './contact-us.component.html',
  styleUrls: ['./contact-us.component.scss'],
  standalone : true,
  imports: [TranslatePipes, RouterLink, RecaptchaModule, RecaptchaV3Module, FormsModule, SharedModule]
})
export class ContactUsComponent extends Unsub implements OnInit {
  @ViewChild('googlerecaptcha') googlerecaptcha!: any;
  contact: any;
  public sendingResponse: { [key: string]: boolean } = {};
  captchaStatus: boolean = false;
  captcha: any;
  constructor(
    private guestService: GuestService,
    private toastr: ToastrService,
    private captchaService: CaptchaService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.loaderService.showLoader();
    this.guestService
      .getcontactus()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.contact = res;
          this.loaderService.hideLoader();
        },
        error: () => this.loaderService.hideLoader()
      });
  }

  ngOnInit(): void {
  }

  submitContactUs(ngForm, buttonId) {
    const data = ngForm.value;
    
    if (this.contact?.setting?.original?.CAPTCHATYPE=='manual' && this.contact?.setting?.original?.RECAPTCH_ENABLE_CONTACT == 'yes') {
      if (!this.captchaStatus) {
        this.toastr.error(this.translate.transform('Captcha Invalid'));
        this.sendingResponse[buttonId] = false;
        return;
      }
    }
    if (this.captchaStatus) {
      data['captcha'] = 'valid';
    }
    this.sendingResponse[buttonId] = true;

    this.guestService
      .contactus(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res.success) {
            this.toastr.success(this.translate.transform(res.success));
            ngForm.reset();
            this.captcha = null;
            if (this.googlerecaptcha) {
              this.googlerecaptcha.reset();
            }
          }
          if (res.error) {
            this.toastr.error(this.translate.transform(res.error.errors.message));
          }
          this.captchaService.setCaptchaStatus(false);
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
          this.captchaService.setCaptchaStatus(false);
        },
      });
  }
  public resolved(captchaResponse: string | any): void {
    this.captcha = captchaResponse;
  }
  captchaMessage = '';
  manualCaptchEvent(value: any) {
    if(!value?.optional){
      if (value.generated == value.input) {
        this.captchaStatus = true;
        this.captchaMessage = '';
      } else if(value.input == '') {
        this.captchaMessage = 'Enter valid captcha';
        this.captchaStatus = false;
      }else{
        this.captchaStatus = false;
      }
    }
  }
}
