import { Routes } from "@angular/router";

export const guest: Routes = [
  {
    path: '',
    loadComponent: () => import('./home/home.component').then(e => e.HomeComponent), data: {
      permission: true
    }
  },
  {
    path: 'knowledge',
    loadComponent: () => import('./knowledge/knowledge.component').then(e => e.KnowledgeComponent), data: {
      permission: true
    }
  },
  {
    path: 'faqs',
    loadComponent: () => import('./faqs/faqs.component').then(e => e.FaqsComponent), data: {
      permission: true
    }
  },
  {
    path: 'faq-category/:id',
    loadComponent: () => import('./faq-category/faq-category.component').then(e => e.FaqCategoryComponent), data: {
      permission: true
    }
  },
  {
    path: 'contact-us',
    loadComponent: () => import('./contact-us/contact-us.component').then(e => e.ContactUsComponent), data: {
      permission: true
    }
  },
  {
    path: 'article/:id',
    loadComponent: () => import('./articalview/articalview.component').then(e => e.ArticalviewComponent), data: {
      permission: true
    }
  },
  {
    path: 'category/:id',
    loadComponent: () => import('./caterogy/caterogy.component').then(e => e.CaterogyComponent), data: {
      permission: true
    }
  },
  {
    path: 'page/:id',
    loadComponent: () => import('./pages/pages.component').then(e => e.PagesComponent), data: {
      permission: true
    }
  },
  {
    path: 'guest/open-ticket',
    loadComponent: () => import('./submit-ticket/submit-ticket.component').then(e => e.SubmitTicketComponent), data: {
      permission: true
    }
  },
  {
    path: 'guest/guest-ticket-restrict',
    loadComponent: () => import('./gust-ticket-restrict/gust-ticket-restrict.component').then(e => e.GustTicketRestrictComponent), data: {
      permission: true
    }
  },
  {
    path: 'guest/ticketdetails/:id',
    loadComponent: () => import('./ticketdetails/ticketdetails.component').then(e => e.TicketdetailsComponent), data: {
      permission: true
    }
  },
  {
    path: 'guest/ticket/:id',
    loadComponent: () => import('./ticketview/ticketview.component').then(e => e.TicketviewComponent), data: {
      permission: true
    }
  },
  {
    path: 'guest/ticket-view/details/:id',
    loadComponent: () => import('./ticket-verify-otp/ticket-verify-otp.component').then(e => e.TicketVerifyOtpComponent), data: {
      permission: true
    }
  },
  {
    path: 'customer/refund-view/:id',
    loadComponent: () => import('../customer/refund-view/refund-view.component').then(e => e.RefundViewComponent), data: {
      permission: true
    }
  },
];