import { Component, OnInit } from '@angular/core';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../shared/class/unsub.class';
import { GuestService } from '../../../shared/services/guest.service';
import { LoaderService } from '../../../shared/services/loader.service';

import { RouterLink } from '@angular/router';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';

@Component({
  selector: 'app-knowledge',
  templateUrl: './knowledge.component.html',
  styleUrls: ['./knowledge.component.scss'],
  standalone : true,
  imports: [TranslatePipes, RouterLink]
})
export class KnowledgeComponent extends Unsub implements OnInit {
  knowledge: any;
  apiLoading = true;
  constructor(private guestService: GuestService,
    loaderService: LoaderService) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  ngOnInit(): void {
    this.loaderService.showLoader();
    this.guestService
      .knowledge()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.knowledge = res;
          this.loaderService.hideLoader();
          this.apiLoading = false;
        },
        error: () => { this.loaderService.hideLoader(); this.apiLoading = false; }
      });
  }
}
