import { Component, OnInit, ViewChild, ElementRef } from '@angular/core';
import { ActivatedRoute, Router, RouterLink } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { FormBuilder, FormGroup, FormsModule, NgForm } from '@angular/forms';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import Swal from 'sweetalert2';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { Unsub } from '../../../shared/class/unsub.class';
import { customerToolbar } from '../../../shared/data/editortoolbar';
import { AdminService } from '../../../shared/services/admin/admin.service';
import { GuestService } from '../../../shared/services/guest.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { CommonModule } from '@angular/common';
import { NgbAccordionModule, NgbAlertModule, NgbModal, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { NgxPrintElementComponent, NgxPrintElementDirective, NgxPrintElementService } from 'ngx-print-element';
import { TranslatePipe } from '@ngx-translate/core';
import { CookieService } from 'ngx-cookie-service';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { DateAgoPipe } from '../../../shared/pipes/date-ago/date-ago.pipe';
import { ImageUploadComponent } from '../../../shared/common/includes/image-upload/image-upload.component';
import { MaxLengthValidatorDirective } from '../../../shared/directives/max-length-validator.directive';
import { MinLengthValidatorDirective } from '../../../shared/directives/min-length-validator.directive';
import { SharedModule } from '../../../shared/shared.module';
import { TimeconvertionPipe } from '../../../shared/pipes/timeconvertion/timeconvertion.pipe';
import { NgSelectModule } from '@ng-select/ng-select';
import { BusinessHourCardListComponent } from '../../../shared/common/business-hour-card-list/business-hour-card-list.component';

@Component({
  selector: 'app-ticketview',
  templateUrl: './ticketview.component.html',
  styleUrls: ['./ticketview.component.scss'],
  standalone : true,
  imports : [CommonModule, TranslatePipes, DateAgoPipe, AngularEditorModule, RouterLink, NgbTooltipModule, NgbAccordionModule, NgbAlertModule, BusinessHourCardListComponent, NgxPrintElementDirective, ImageUploadComponent, MaxLengthValidatorDirective, MinLengthValidatorDirective, FormsModule, SharedModule, TimeconvertionPipe, NgSelectModule]
})
export class TicketviewComponent extends Unsub implements OnInit {
  @ViewChild('acc') 'acc'!: any;
  @ViewChild('commentsClose') commentsClose!: ElementRef;
  @ViewChild('tableRef') tableElement!: ElementRef<HTMLTableElement>;

  url;
  toggleStatus = false;
  form: FormGroup;
  featureimage: any[] = [];
  ticketName: any[] = [];
  ticketData: any;
  editTimeLimit: any;
  addspace;
  setting: any;
  createdcount: any;
  difference: any;
  businesshours: any;
  nouser;
  currentStatus = 'Inprogress';
  public sendingResponse: { [key: string]: boolean } = {};
  category: any;
  ticketId: any;
  id!: number | string | null;
  guestId!: number | string | null;
  today: Date = new Date();
  timezone: any;
  holiday: any;
  user
  hideAlertsUntils: { [key: string]: number } = {};
  toolbar: AngularEditorConfig = customerToolbar;
  datacomments: any;

  private intersectionObserver!: IntersectionObserver;
  public isLoadingComments: boolean = false;
  totalcomments: number = 0;
  pageCount: any;
  isonline: any;
  supporticonimageprev: string | null = null;

  constructor(
    public print: NgxPrintElementService,
    private guestService: GuestService,
    private toastr: ToastrService,
    private activatedRoute: ActivatedRoute,
    private router: Router,
    public fb: FormBuilder,
    public adminService: AdminService,
    private cookieService : CookieService,
    private modalService: NgbModal,
    private translate: TranslatePipe,
    loaderService: LoaderService,  private sanitizer: DomSanitizer
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.url = location.origin + document.querySelector('base')?.getAttribute('href');
    this.toolbar.placeholder = this.translate.transform('Enter Your Text...');
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.pageCount = 1;
        this.guestTicket();
      },
    });
    this.activatedRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.id = params.get('id');
        this.guestTicket();
      },
    });

    this.form = this.fb.group({
      image: null,
    });
  }

  languages: any;
  guestTicket() {
    this.loaderService.showLoader();
    this.guestService
      .ticketDetailsView(this.id, this.pageCount)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          if (res.error) {
            this.toastr.error(this.translate.transform(res.error));
            this.router.navigate(['/guest/ticket-view/details/' + this.id]);
            return;
          }
          if (res?.noticket) {
            this.toastr.error(this.translate.transform(res.noticket));
            this.router.navigate(['/']);
            return;
          }
          this.languages = Object.keys(res.languages).map(key => ({ id: key, name: res.languages[key] }));
          this.addspace = res?.addspace;
          this.nouser = res?.nouser;
          this.ticketData = res.ticket;
          this.editTimeLimit = res.editTimeLimit;
          this.holiday = res.holidays;
          this.user = res.user;
          this.createdcount = res.createdcount;
          this.difference = res.difference;
          if(res?.ticket?.status == 'New'){
            this.currentStatus = 'New';
          }
          else if(res?.ticket?.status == 'Re-Open' || res?.ticket?.status == 'Inprogress' || res?.ticket?.status == 'New' || res?.ticket?.status == 'Leave as current'){
            this.currentStatus = 'Inprogress'
          }else{
            this.currentStatus = res?.ticket?.status;
          }
          
          res.holidays.forEach(alert => {
            const hideAlertsUntil = this.cookieService.get(alert.id);
            if (hideAlertsUntil) {
              this.hideAlertsUntils[alert.id] = parseInt(hideAlertsUntil, 10);
            }
          })
          this.datacomments = res.comments.data;
          this.totalcomments = res.comments.total;
          this.pageCount = res.comments.current_page + 1;
          this.ticketId = res.ticket.enc_ticket_id;
          this.guestId = res.ticket.id;
          this.supporticonimageprev = res.supporticonimageprev;
          this.setting = res.setting?.original;
          this.businesshours = res.businesshours;
          this.isonline = res.isOnline;
          this.category = res.category;
          this.timezone = this.setting?.default_timezone;
          this.toggleStatus = this.businesshours?.some(e => e.weeks);
          this.loaderService.hideLoader();
        },
        error : ()=> this.loaderService.hideLoader()
      });
  }

  selectComment;
  translateModel(content, comment) {
    this.selectComment = comment;
    this.modalService.open(content, { backdrop: 'static', keyboard: false, size: 'lg' });
  }

  openModel(content){
    this.modalService.open(content, { backdrop: 'static', keyboard: false, size: 'md' });
  }
  translateFn(ngForm, buttonId) {
    if (ngForm.valid) {
      let data = {
        text: this.selectComment ? this.selectComment.comment : this.ticketData?.message,
        target_lang: ngForm.value.languages,
        user: 'customer',
      }
      
      this.adminService.translate(data).pipe(takeUntil(this.unSubscribe$)).subscribe({
        next:
          (res) => {
            // this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.modalService.dismissAll();
              if(this.selectComment){
                
              const comment = this.datacomments.find(comment => comment.id === this.selectComment.id);
              if (comment) {
                comment.comment = res.translated_text;
              }
              }else{
                this.ticketData.message = res.translated_text;
              }
            }
            if (res.message) {
              this.toastr.error(this.translate.transform('Translation failed: ' + res.message));
            }
            if (res?.error?.errors) {
              for (const el in res.error.errors) {
                this.toastr.error(this.translate.transform(res.error.errors[el]));
              }
            }
            else if (res.errors) {
              // Iterate through each error key (e.g., subcategoryname)
              Object.keys(res.errors).forEach(key => {
                // If there are errors for that key, display them
                res.errors[key].forEach((error: string) => {
                  this.toastr.error(this.translate.transform(error));
                });
              });
            }
          },
        error: () => {
          // this.sendingResponse[buttonId] = false;
        },
      }
      );
    }
  }

  onImageUploaded(value) {
    this.ticketName = value.ticketName;
  }

  ngOnInit(): void {
  }

  commentData(ngForm: NgForm, buttonId) {
    this.sendingResponse[buttonId] = true;
    const data = ngForm.value;

    if (ngForm.valid) {
      this.guestService
        .updatereplay(ngForm.value.comment_id, data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              ngForm.reset();
              this.form.reset({});
            }
            if (res?.error?.errors) {
              for (const el in res.error.errors) {
                this.toastr.error(this.translate.transform(res.error.errors[el]));
              }
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  editRpl(ele) {
    ele.classList.toggle('d-block');
  }
  GuestReply(ngForm: NgForm, buttonId) {

    const formData: any = new FormData();
    for (const key of Object.keys(ngForm.value)) {
      formData.append(key, ngForm.value[key]);
    }
    for (let i = 0; i < this.ticketName.length; i++) {
      formData.append('comments[]', this.ticketName[i]);
    }
    if (ngForm.valid) {
    this.sendingResponse[buttonId] = true;
      this.guestService
        .guestreplay(this.ticketId, formData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              ngForm.reset()
              this.form.reset({});
              this.acc?.collapseAll();
            }
            if (res?.error?.errors) {
              for (const el in res.error.errors) {
                this.toastr.error(this.translate.transform(res.error.errors[el]));
              }
            }
            if (res?.error) {
                this.toastr.error(this.translate.transform(res.error));
            }
            if (res?.appreciate) {
              Swal.fire({
                icon: 'success',
                title: this.translate.transform(res.appreciate),
                confirmButtonColor: '#6259ca',
                confirmButtonText: this.translate.transform('Okay!'),
                reverseButtons: true,
              }).then((result: any) => { });
            }
            if (res?.rating) {
              this.router.navigate(['/rating-page/' + res.rating]);
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  reopenTicket(ngForm, buttonId) {
    this.sendingResponse[buttonId] = true;
    const data = ngForm.value;

    this.guestService
      .reopenTicket(this.ticketId, data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
          if (res?.error?.errors) {
            for (const el in res.error.errors) {
              this.toastr.error(this.translate.transform(res.error.errors[el]));
            }
          }
        },
        error: () => {
           this.sendingResponse[buttonId] = false;
        },
      });
  }
  printDetails() {
    const printContents: any = document.getElementById('printDiv')?.innerHTML;
    const originalContents = document.body.innerHTML;

    document.body.innerHTML = printContents;

    window.print();

    document.body.innerHTML = originalContents;
  }
  isOpen = false;
  toggleBusiness() {
    this.isOpen = !this.isOpen;
  }
  addDays(dateval, daysval) {
    const date = new Date(dateval);
    date.setDate(date.getDate() + Number(daysval));

    return date;
  }

  ngAfterViewInit() {

    this.intersectionObserver = new IntersectionObserver((entries) => {
      if (entries[0].isIntersecting && !this.isLoadingComments && this.datacomments.length < this.totalcomments) {
        this.loadComments();
        this.isLoadingComments = true;
      }
    }, { threshold: 0 });
    const myElement = this.commentsClose.nativeElement;

    this.intersectionObserver.observe(myElement);
  }
  loadComments() {
    // this.isloader = true;
    this.guestService.ticketDetailsView(this.id, this.pageCount)
      .subscribe((data: any) => {
        this.isLoadingComments = false;
        this.pageCount = data.comments.current_page + 1;
        this.datacomments = [...this.datacomments, ...data.comments.data];
      });
  }

  override ngOnDestroy() {
    if (this.intersectionObserver) {
      this.intersectionObserver.disconnect();
    }
  }
  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }

  downloadFile(id, image){
    this.guestService.image(id, image).subscribe({
      next: (res: Blob)=>{ 
        const blobUrl = window.URL.createObjectURL(res);
          const link = document.createElement('a');
          link.href = blobUrl;
          link.setAttribute('download', image); // Set a default filename, customize as needed
          document.body.appendChild(link);
          link.click();
          document.body.removeChild(link);
          window.URL.revokeObjectURL(blobUrl);
      }
    })
  }
  emailtoticketdownload(id, image){
    this.guestService.emailtoticketdownload(id, image).subscribe({
      next: (res: Blob)=>{ 
        const blobUrl = window.URL.createObjectURL(res);
          const link = document.createElement('a');
          link.href = blobUrl;
          link.setAttribute('download', image); // Set a default filename, customize as needed
          document.body.appendChild(link);
          link.click();
          document.body.removeChild(link);
          window.URL.revokeObjectURL(blobUrl);
      }
    })
  }  
  
  printGuestTicketView(el: ElementRef<HTMLTableElement | HTMLElement>) {
    this.print.print(el).subscribe({
      next : ()=>{
      }
    })
    
  }
}
