import { CommonModule } from '@angular/common';
import { Component, inject, Input, SimpleChanges } from '@angular/core';
import { ControlContainer, FormControl, FormGroup, ReactiveFormsModule, Validators } from '@angular/forms';
import { SharedModule } from '../../../../shared/shared.module';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { adminToolbar } from '../../../../shared/data/editortoolbar';
import { MaxLengthValidatorDirective } from '../../../../shared/directives/max-length-validator.directive';

@Component({
  selector: 'app-editor-input',
  standalone: true,
  imports: [ReactiveFormsModule, CommonModule, MaxLengthValidatorDirective, AngularEditorModule],
  viewProviders:[
    {
      provide: ControlContainer,
      useFactory : ()=>inject(ControlContainer, { skipSelf : true })
    }
  ],
  template : `
  <angular-editor [config]="toolbar" [formControlName]="nameField"
                          [class.is-invalid]="formControl.invalid && formControl.touched" class="form-control"
                        [placeholder]="placeholder"></angular-editor>
      <div *ngIf="formControl.invalid && formControl.touched" class="error-invalid">
     <span class="text-danger" *ngIf="formControl.hasError('required')">{{'This field is required' | translate}}</span>
   </div>
    `
})
export class EditorInputComponent {
  @Input() nameField!: string;
  @Input() value!: string;
  @Input() idField!: string;
  @Input() classText!: string;
  @Input() placeholder!: string;
  @Input() isRequired!: boolean;
  parentContainer = inject(ControlContainer);

  toolbar: AngularEditorConfig = adminToolbar;
  get parentFormGroup(){
    return this.parentContainer.control as FormGroup;
  }
  get formControl(): FormControl {
    return this.parentFormGroup.get(this.nameField) as FormControl;
  }


  ngOnInit() {
    this.parentFormGroup.addControl(this.nameField, new FormControl(this.value ?? '', this.isRequired ? Validators.required : null))
  }
  
  ngOnChanges(changes: SimpleChanges): void {
    // Check if the initialSelect input has changed
    if (changes['value']) {
      // Update the form control value
      this.updateFormControl();
    }
  }

  private updateFormControl(): void {
    if (this.parentFormGroup) {
      // Update the value of the form control
      const control = this.parentFormGroup.get(this.nameField);
      if (control) {
        control.setValue(this.value ?? '');
        control.setValidators(this.isRequired ? Validators.required : null);
        control.updateValueAndValidity();
      } 
    }
  }

  ngOnDestroy() {
    this.parentFormGroup.removeControl(this.nameField);
  }
}
