import { CommonModule } from '@angular/common';
import { Component, EventEmitter, inject, Input, Output, SimpleChanges } from '@angular/core';
import { ControlContainer, FormControl, FormGroup, ReactiveFormsModule, Validators } from '@angular/forms';
import { SharedModule } from '../../../../shared/shared.module';

@Component({
  selector: 'app-file-input',
  standalone: true,
  imports: [ReactiveFormsModule, CommonModule, SharedModule],
  viewProviders:[
    {
      provide: ControlContainer,
      useFactory : ()=>inject(ControlContainer, { skipSelf : true })
    }
  ],
  template: `<input type="file" (change)="onFileChange($event)" [ngClass]="classText" [id]="idField ? idField : nameField" [formControlName]="nameField" [value]="value" [placeholder]="placeholder" [accept]="accept" autocomplete="off">
  <div *ngIf="formControl.invalid && formControl.touched" class="error-invalid">
    <span class="text-danger" *ngIf="formControl.hasError('required')">{{'This field is required' | translate}}</span>
  </div>`
})
export class FileInputComponent {
  @Input() nameField!: string;
  @Input() value!: string;
  @Input() idField!: string;
  @Input() classText!: string;
  @Input() accept!: string;
  @Input() placeholder!: string;
  @Input() isRequired!: boolean;
  @Output() valueChanged = new EventEmitter<any>();
  parentContainer = inject(ControlContainer);

  get parentFormGroup(){
    return this.parentContainer.control as FormGroup;
  }
  get formControl(): FormControl {
    return this.parentFormGroup.get(this.nameField) as FormControl;
  }


  ngOnInit() {
    this.parentFormGroup.addControl(this.nameField, new FormControl('', this.isRequired ? Validators.required : null))
  }
  

  onFileChange(event: any) {
    const file = (event.target as HTMLInputElement)?.files?.[0];
    this.parentFormGroup.patchValue({
      file: file
    });
    this.valueChanged.emit(file)
  }

  // private updateFormControl(): void {
  //   if (this.parentFormGroup) {
  //     // Update the value of the form control
  //     const control = this.parentFormGroup.get(this.nameField);
  //     if (control) {
  //       control.setValue(this.value ?? '');
  //       control.setValidators(this.isRequired ? Validators.required : null);
  //       control.updateValueAndValidity();
  //     }
  //   }
  // }

  ngOnDestroy() {
    this.parentFormGroup.removeControl(this.nameField);
  }
}
