import { Injectable, Optional, OnDestroy } from "@angular/core";
import { Subject } from 'rxjs';
import { LoaderService } from "../services/loader.service";

@Injectable()
export abstract class Unsub implements OnDestroy {
    protected unSubscribe$ = new Subject<void>();
    
    constructor(@Optional() protected loaderService: LoaderService) {}

    // Example of a utility method
    public getRandomNumber(): number {
        return Math.floor(Math.random() * 100);
    }

    ngOnDestroy(): void {
        // Perform cleanup actions
        if (this.loaderService) {
            this.loaderService.clearLoader();
        }
        if (this.unSubscribe$) {
            this.unSubscribe$.next();
            this.unSubscribe$.complete();
        }
    }
}
