import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../class/unsub.class';
import { AdminService } from '../../../services/admin/admin.service';
import { CustomersService } from '../../../services/customers/customers.service';
import { LoaderService } from '../../../services/loader.service';
import { NavigationEnd, NavigationStart, Router } from '@angular/router';
import { NavService } from '../../../services/nav.service';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';

@Component({
  selector: 'app-customer-menu',
  templateUrl: './customer-menu.component.html',
  styleUrls: ['./customer-menu.component.scss'],
})
export class CustomerMenuComponent extends Unsub implements OnInit {
  @ViewChild('swiperContainer') swiperContainer!: ElementRef;
  setting;
  unviewedQuotations;
  data: any;
  url = "";
  addspace;
  constructor(
    private customersService: CustomersService,
    private navServices: NavService,
    private adminService: AdminService,
    private router: Router,
    public sanitizer: DomSanitizer,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);

    this.url = location.origin + document.querySelector('base')?.getAttribute('href');
    this.checkNavActiveOnLoad();
  }

  ngOnInit(): void {
    this.settingInprogress();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.settingInprogress();
      },
    });
  }
  settingInprogress = () => {
    this.customersService
      .profile()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (ele) => {
          this.setting = ele.setting?.original;
          this.data = ele.users;
          this.unviewedQuotations = ele.unviewedQuotations;
          this.addspace = ele.addspace;
        },
      });
  };


  public menuItems;
  // To set Active on Load
  checkNavActiveOnLoad() {
    this.navServices.CustomerItems.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (menuItems: any) => {
        this.menuItems = menuItems;
        this.router.events.pipe(takeUntil(this.unSubscribe$)).subscribe({
          next: (event: any) => {
            if (event instanceof NavigationStart) {
              const path = location.pathname?.split('/');
              const eventUrl = new URL(event.url, window.location.origin).pathname.split('/');
              if (path[path.length - 2] !== eventUrl[eventUrl.length - 2]) {
                this.closeNavActive();
                const sidelink = document.querySelectorAll('.nav-link.active');
                const sidemenuUl = document.querySelector('.nav-item.active');
                const sidemenuul = document.querySelectorAll('.nav-sub-link.sub-with-sub');
                const subSidemenuUl = document.querySelector('.nav-item.active');
                const subSidemenu = document.querySelectorAll('.nav-sub-link.sub-with-sub');
                sidemenuUl?.classList.remove('active');
                subSidemenuUl?.classList.remove('active');
                sidelink?.forEach((e) => e.classList.remove('active'));
                sidemenuul?.forEach((e) => e.classList.remove('active'));
                subSidemenu?.forEach((e) => e.classList.remove('active'));
              }
            }

            if (event instanceof NavigationEnd) {
              const eventUrl = new URL(event.url, window.location.origin).pathname;

              menuItems?.filter((items: any) => {
                if (items.path === eventUrl) {
                  this.setNavActive(items);
                }
                items?.children?.filter((subItems: any) => {
                  if (subItems.path === eventUrl) {
                    this.setNavActive(subItems);
                  }
                  subItems?.children?.filter((subSubItems: any) => {
                    if (subSubItems.path === eventUrl) {
                      this.setNavActive(subSubItems);
                    }
                    subSubItems?.children?.filter((subSubItems1: any) => {
                      if (subSubItems1.path === eventUrl) {
                        this.setNavActive(subSubItems1);
                      }
                    });

                  });

                });

              });
            }
          },
        });
      },
    });
  }
  //Active Nav State
  setNavActive(item: any) {
    this.menuItems?.filter((menuItem) => {
      if (menuItem != item) {
        menuItem.active = false;
        this.navServices.collapseSidebar = false;
      }
      if (menuItem == item) {
        menuItem.active = true;
      }
      if (menuItem.children && menuItem.children.includes(item)) {
        menuItem.active = true;
      }
      if (menuItem.children) {
        menuItem.children?.filter((submenuItems) => {
          if (submenuItems == item) {
            menuItem.active = true;
            submenuItems.active = true;
          }
          if (submenuItems.children && submenuItems.children.includes(item)) {
            menuItem.active = true;
            submenuItems.active = true;
          }
          if (submenuItems.children) {
            submenuItems.children?.forEach((subsubmenuItems) => {
              if (
                subsubmenuItems.children &&
                subsubmenuItems.children.includes(item)
              ) {
                menuItem.active = true;
                submenuItems.active = true;
                subsubmenuItems.active = true;
              }
            });
          }
        });
      }
    });
  }

  // Toggle menu
  toggleNavActive(item: any) {
    if (!item.active) {
      this.menuItems?.forEach((a: any) => {
        if (this.menuItems.includes(item)) {
          a.active = false;
        }
        a?.children?.forEach((b: any) => {
          if (a.children.includes(item)) {
            b.active = false;
          }
          b?.children?.forEach((c: any) => {
            if (b.children.includes(item)) {
              c.active = false;
            }
          });
        });
      });
    }
    item.active = !item.active;
  }

  // Close Nav menu
  closeNavActive() {
    this.menuItems?.forEach((a: any) => {
      if (this.menuItems) {
        a.active = false;
      }
      a?.children?.forEach((b: any) => {
        if (a.children) {
          b.active = false;
        }
      });

    });
  }
  
    getSanitizedSVG(svgContent: string): SafeHtml {
      return this.sanitizer.bypassSecurityTrustHtml(svgContent);
    }
}
