import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders, HttpParams } from '@angular/common/http';
import moment from 'moment-timezone';
import { Observable, Subject, tap } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class AdminService {
  public language: any;
  public i: any;
  public value = null;
  prefix = '';
  headers = new HttpHeaders({ 'Content-Type': 'application/json; charset=utf-8' });

  constructor(private http: HttpClient) {

  }
  httpOptions = {
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json',
      'Access-Control-Allow-Origin': '*'
    },
  };
  private _refreshrequestAdmin = new Subject<void>();

  get RefreshRquestAdmin$() {
    this.refreshCsrfToken().subscribe({
      next: (res) => {
        const csrfMetaTag = document.head.querySelector('meta[name="csrf-token"]');
        csrfMetaTag && csrfMetaTag.setAttribute('content', res?.csrftoken)
      }
    })
    return this._refreshrequestAdmin;
  }

  public basic(): Observable<any> {
    return this.http.get(`detail/basic`, { observe: 'response' });
  }
  refreshCsrfToken(): Observable<any> {
    return this.http.get('detail/csrftoken');
  }
  public time(): Observable<any> {
    return this.http.get(`detail/admin/time`);
  }
  public getlogin(): Observable<any> {
    return this.http.get(`detail/admin/login`);
  }
  public adminemailtwofactresendotp(email: string): Observable<any> {
    return this.http.get(`detail/admin/adminemailtwofactresendotp/${email}`);
  }
  public adminemailtwofact(email: string): Observable<any> {
    return this.http.get(`detail/admin/adminemailtwofact/${email}`);
  }
  public adminindexlogin(email: string): Observable<any> {
    return this.http.get(`detail/admin/adminindexlogin/${email}`);
  }
  public admingoogle2faotpverify(data: any): Observable<any> {
    return this.http.post(`detail/admin/admingoogle2faotpverify`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public checkLoginAdmin(): Observable<any> {
    return this.http.get(`detail/admin/checkLoginAdmin`, { observe: 'response' });
  }

  public AdminLogin(data: any): Observable<any> {
    return this.http.post(`detail/admin/login`, data, this.httpOptions);
  }
  public generateTextFn(data: any): Observable<any> {
    return this.http.post(`detail/admin/generate-text`, data, this.httpOptions);
  }
  public tokenGenerate(): Observable<any> {
    return this.http.get(`detail/admin/tokenGenerate`);
  }
  public requesttoken(): Observable<any> {
    return this.http.get(`detail/admin/requesttoken`);
  }
  public getforgotpassword(): Observable<any> {
    return this.http.get(`detail/admin/forgot`);
  }
  public forgotpassword(data: any): Observable<any> {
    return this.http.post(`detail/admin/forgot`, data);
  }
  public getResetData(token: any): Observable<any> {
    return this.http.get(`detail/admin/${token}/reset-password`);
  }
  public resetPsw(data: any): Observable<any> {
    return this.http.post(`detail/admin/reset-password`, data);
  }
  public AdminLogout(data: any): Observable<any> {
    return this.http.post(`detail/admin/logout`, data);
  }

  public otpverify(data): Observable<any> {
    return this.http.post(`detail/admin/verifytwofactor`, data);
  }
  public empemail2faotp(data: any): Observable<any> {
    return this.http.post(`detail/admin/empemail2faotp`, data, this.httpOptions).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public emptwofactqr(data: any): Observable<any> {
    return this.http.post(`detail/admin/emptwofactqr`, data, this.httpOptions).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public empgoogle2faotp(data: any): Observable<any> {
    return this.http.post(`detail/admin/empgoogle2faotp`, data, this.httpOptions).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public clearCache(data: any): Observable<any> {
    return this.http.post(`detail/admin/clearcache`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public adminDashboard(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm);
    return this.http.get(`detail/admin/dashboardtabledata`, { params: params });
  }
  public adminDashboardCount(): Observable<any> {
    return this.http.get(`detail/admin/dashboardcount`);
  }
  public adminSelfAssign(id: any, data: any): Observable<any> {
    return this.http.post(`detail/admin/selfassign/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public userListOtherAssign(id: any): Observable<any> {
    return this.http.get(`detail/admin/assigned/${id}`);
  }
  public unAssignlist(id: any): Observable<any> {
    return this.http.get(`detail/admin/assigned/update/${id}`).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public ticketHistory(id: any): Observable<any> {
    return this.http.get(`detail/admin/tickethistory/${id}`);
  }
  public otherAssignTicket(id: any): Observable<any> {
    return this.http.post(`detail/admin/otherassign/create`, id).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public getCreateTicket(): Observable<any> {
    return this.http.get(`detail/admin/createticket`);
  }
  public ticketarticle(ticketId, comments): Observable<any> {
    return this.http.get(`detail/admin/ticketarticle/${ticketId}/${comments}`);
  }
  public wrongcustomer(data: any): Observable<any> {
    return this.http.post(`detail/admin/wrongcustomer`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public purchasedetailsverify(data: any): Observable<any> {
    return this.http.post(`detail/admin/purchasedetailsverify`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public createTicket(data: any): Observable<any> {
    return this.http.post(`detail/admin/createticket`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deleteTicket(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/delete-ticket/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public forceClose(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/adminticketclosing/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public massTicketdeleteAll(data: any): Observable<any> {
    return this.http.post(`detail/admin/ticket/delete/tickets`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public showTicket(id: any, page: number = 1, pageSize: number = 6): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
    return this.http.get(`detail/admin/ticket-view/${id}`, { params: params });
  }
  public replyTicket(id, data: any): Observable<any> {
    return this.http.post(`detail/admin/ticket/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public latestcommentimgdelete(id: any): Observable<any> {
    return this.http.get(`detail/admin/latestcommentimgdelete/${id}`).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public draftdelete(id: any): Observable<any> {
    return this.http.get(`detail/admin/draftdelete/${id}`).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public ticketdraftimage(id: any): Observable<any> {
    return this.http.get(`detail/admin/ticketdraftimage/${id}`).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public ticketdraft(data: any): Observable<any> {
    return this.http.post(`detail/admin/ticketdraft`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public getCatagoryData(data: any): Observable<any> {
    return this.http.post(`detail/subcategorylist`, data, this.httpOptions);
  }
  public priorityChange(data: any): Observable<any> {
    return this.http.post(`detail/admin/priority/change`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public updatereplay(id, data: any): Observable<any> {
    return this.http.post(`detail/admin/ticket/editcomment/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deletecomment(id, data: any): Observable<any> {
    return this.http.post(`detail/admin/ticket/deletecomment/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public updateCategory(data: any): Observable<any> {
    return this.http.post(`detail/admin/category/change`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public envatoverify(data: any): Observable<any> {
    return this.http.post(`detail/envatoverify`, data);
  }
  public reopenTicket(id, data: any): Observable<any> {
    return this.http.post(`detail/admin/ticket/reopen/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public createNote(data: any): Observable<any> {
    return this.http.post(`detail/admin/note/create`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deleteNote(id, data: any): Observable<any> {
    return this.http.post(`detail/admin/ticketnote/delete/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deleteViolation(id, data: any): Observable<any> {
    return this.http.post(`detail/admin/deleteViolation/delete/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public alltickets(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/alltickets`, { params: params });
  }
  public recenttickets(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/recenttickets`, { params: params });
  }

  public activeticket(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/activeticket`, { params: params });
  }
  public activeticketInprogress(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/activeticket/inprogress`, { params: params });
  }
  public activeticketReopen(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/activeticket/reopen`, { params: params });
  }
  public activeticketOnhold(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/activeticket/onhold`, { params: params });
  }
  public activeticketAssigned(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/activeticket/assigned`, { params: params });
  }
  public closedticket(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/closedticket`, { params: params });
  }
  public onholdtickets(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/onholdtickets`, { params: params });
  }
  public overduetickets(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/overduetickets`, { params: params });
  }
  public allassignedtickets(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/allassignedtickets`, { params: params });
  }

  public voilation(id): Observable<any> {
    return this.http.get(`detail/admin/ticket-view/violationdetails/${id}`);
  }
  public voilating(data): Observable<any> {
    return this.http.post(`detail/admin/voilating`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public myselfassigned(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/myselfassigned`, { params: params });
  }
  public myassignedtickets(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/myassignedtickets`, { params: params });
  }
  public myclosedtickets(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/myclosedtickets`, { params: params });
  }
  public mysuspendtickets(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/mysuspendtickets`, { params: params });
  }

  // create customer
  public customerAdminLogin(id: number | string): Observable<any> {
    return this.http.get(`detail/admin/customer/adminlogin/${id}`);
  }
  public resendEmailCustomer(email: string): Observable<any> {
    return this.http.get(`detail/admin/customer/resendverification/${email}`);
  }
  public index(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/customer`, { params: params });
  }
  public customerprevioustickets(id: number, page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/customerprevioustickets/${id}`, { params: params });
  }
  public CreateCustomer(data: any): Observable<any> {
    return this.http.post(`detail/admin/customer/create`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public getCreateCustomer(): Observable<any> {
    return this.http.get(`detail/admin/customer/create`);
  }
  public editCustomerData(id: number): Observable<any> {
    return this.http.get(`detail/admin/customer/${id}`);
  }
  public editCustomer(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/customer/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deletecustomer(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/customer/delete/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public massDeleteCustomer(data: any): Observable<any> {
    return this.http.post(`detail/admin/masscustomer/delete`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  // Roles start
  public RolesList(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/role`, { params: params });
  }
  public getcreateRoles(): Observable<any> {
    return this.http.get(`detail/admin/role/create`);
  }
  public createRoles(data: any): Observable<any> {
    return this.http.post(`detail/admin/role/create`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public geteditRoles(id: number): Observable<any> {
    return this.http.get(`detail/admin/role/edit/${id}`);
  }
  public editRoles(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/role/edit/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  // Roles end
  // employee start
  public createEmployeeGetAssets(): Observable<any> {
    return this.http.get(`detail/admin/employee/create`);
  }
  public createEmployee(data: any): Observable<any> {
    return this.http.post(`detail/admin/agent`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public employeeDetailsShow(id: number): Observable<any> {
    return this.http.get(`detail/admin/agentprofile/${id}`);
  }
  public updateEmployee(data: any, id: number): Observable<any> {
    return this.http.post(`detail/admin/agentprofile/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public adminemailchange(data: any): Observable<any> {
    return this.http.post(`detail/admin/adminemailchange`, data);
  }
  public adminnewemailstore(data: any): Observable<any> {
    return this.http.post(`detail/admin/adminnewemailstore`, data);
  }
  public emailchangeotpverify(email: string, data: any): Observable<any> {
    return this.http.post(`detail/admin/adminemailupdateotpverify/${email}`, data);
  }
  public adminemailupdate(email: string): Observable<any> {
    return this.http.get(`detail/admin/adminemailupdate/${email}`);
  }
  public employeeList(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/employee`, { params: params });
  }
  public userimport(data: any, http: any): Observable<any> {
    return this.http.post(`detail/admin/userimport`, data, http).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public employeepasswordreset(data: any): Observable<any> {
    return this.http.post(`detail/admin/employeepasswordreset`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public employeestatus(data: any, id: number): Observable<any> {
    return this.http.post(`detail/admin/agent/status/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public employeedelete(data: any, id: number): Observable<any> {
    return this.http.post(`detail/admin/agentdelte/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public employeedeleteAll(data: any): Observable<any> {
    return this.http.post(`detail/admin/massuser/deleteall`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  // employee end
  //trashed tickets start
  public myTrashedTickets(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/tickettrashed`, { params: params });
  }
  public myTrashedTicketView(id: number): Observable<any> {
    return this.http.get(`detail/admin/tickettrashedview/${id}`);
  }
  public myTrashedTicketsDelete(data: any, id: number): Observable<any> {
    return this.http.post(`detail/admin/tickettrasheddestroy/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public myTrashedTicketsMassDelete(data: any): Observable<any> {
    return this.http.post(`detail/admin/tickettrashed/delete`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public myTrashedTicketsRestore(data: any, id: number): Observable<any> {
    return this.http.post(`detail/admin/tickettrashedrestore/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public myTrashedTicketsMassRestore(data: any): Observable<any> {
    return this.http.post(`detail/admin/tickettrashed/restore`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  //trashed tickets start

  // addspace start
  public addspace(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/addspace`, { params: params });
  }
  public addspaceStore(data: any): Observable<any> {
    return this.http.post(`detail/admin/addspace/store`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public statusaddspace(id, data: any): Observable<any> {
    return this.http.post(`detail/admin/addspace/status/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deleteaddspace(data: any, id: number): Observable<any> {
    return this.http.delete(`detail/admin/addspace/delete/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public MassDeleteaddspace(data: any): Observable<any> {
    return this.http.post(`detail/admin/deleteall`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public fileuploadpermission(data: any): Observable<any> {
    return this.http.post(`detail/admin/fileuploadpermission/${data.id}`, data);
  }
  // addspace end

  // currencies start
  public currencies(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/currencies`, { params: params });
  }
  public currencyStore(data: any): Observable<any> {
    return this.http.post(`detail/admin/currency/store`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public currencyStatus(id, data: any): Observable<any> {
    return this.http.post(`detail/admin/currency/status/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deletecurrency(data: any, id: number): Observable<any> {
    return this.http.get(`detail/admin/currency/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public MassDeletecurrency(data: any): Observable<any> {
    return this.http.post(`detail/admin/currency/deleteall`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  // addspace end

  // addons start 

  public addons(): Observable<any> {
    return this.http.get(`detail/admin/addons`);
  }
  public addonsEdit(id): Observable<any> {
    return this.http.get(`detail/admin/addons/${id}`);
  }
  public storeAddons(data: any): Observable<any> {
    return this.http.post(`detail/admin/addons`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public addonsCredentials(data: any): Observable<any> {
    return this.http.post(`detail/admin/addons/credentials`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public addonsStatuschange(id, data: any): Observable<any> {
    return this.http.post(`detail/admin/addons/statuschange/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public addonsApplicationEnavatoVerify(data: any): Observable<any> {
    return this.http.post(`detail/admin/addons/applicationEnavatoVerify`, data);
  }
  // addons end
  public translate(data: any): Observable<any> {
    return this.http.post(`detail/translate`, data);
  }
  public autoTranslate(data: any): Observable<any> {
    return this.http.post(`detail/admin/autoTranslate`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  // holidays start

  public holidays(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/holidays`, { params: params });
  }
  public holidaysStatus(id: number, data): Observable<any> {
    return this.http.post(`detail/admin/holidays/statuschange/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public createHolidays(data: any): Observable<any> {
    return this.http.post(`detail/admin/holidays/saveholidays`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deleteHolidays(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/holidays/delete/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public massDeleteHolidays(data: any): Observable<any> {
    return this.http.post(`detail/admin/holidays/massdelete`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public getholidaysimport(): Observable<any> {
    return this.http.get(`detail/admin/holidaysimport`);
  }
  public holidaysimport(data: any, http: any): Observable<any> {
    return this.http.post(`detail/admin/holidays/holidaysimport`, data, http).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  // holidays end
  // languages start
  public languages(): Observable<any> {
    return this.http.get(`detail/admin/languages`);
  }
  public allLanguage(lanCode: any): Observable<any> {
    return this.http.get(`detail/admin/languages/translates/${lanCode}`);
  }
  // languages end

  // categories start
  public categories(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/categories`, { params: params });
  }
  public totalcategorylist(): Observable<any> {
    return this.http.get(`detail/admin/totalcategorylist`);
  }
  public categorylist(): Observable<any> {
    return this.http.get(`detail/admin/categorylist`);
  }
  // Both update / create categories
  public createCategories(data: any): Observable<any> {
    return this.http.post(`detail/admin/categories/create`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  // categoriesStatus change toogle btn
  public categoriesStatus(id: number, data): Observable<any> {
    return this.http.post(`detail/admin/categories/status${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public categoriesdeleteId(data: any, id: number): Observable<any> {
    return this.http.post(`detail/admin/categories/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public categoriesdeleteall(data: any): Observable<any> {
    return this.http.post(`detail/admin/category/deleteall`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public categoryassigned(id: number): Observable<any> {
    return this.http.get(`detail/admin/categoryassigned/${id}`);
  }
  public categoryListID(ticketId: string): Observable<any> {
    return this.http.get(`detail/admin/category/list/${ticketId}`);
  }
  public categoryList(): Observable<any> {
    return this.http.get(`detail/admin/categorylist`);
  }
  public categoryenvatoassign(data: any): Observable<any> {
    return this.http.post(`detail/admin/categoryenvatoassign`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public categoryall(data: any): Observable<any> {
    return this.http.post(`detail/admin/category/all/`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public subcategories(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/subcategories`, { params: params });
  }
  public subcategoriesPost(data: any): Observable<any> {
    return this.http.post(`detail/admin/subcategories`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public subcategoryStatus(data: any): Observable<any> {
    return this.http.post(`detail/admin/subcategory/status`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public subcategoryDelete(data: any): Observable<any> {
    return this.http.post(`detail/admin/subcategory/delete`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public subcategoryDeleteAll(data: any): Observable<any> {
    return this.http.post(`detail/admin/subcategory/deleteall`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  // artical

  public articalData(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/article`, { params: params });
  }
  public getcreateArtical(): Observable<any> {
    return this.http.get(`detail/admin/article/create`);
  }
  public createArtical(data: any): Observable<any> {
    return this.http.post(`detail/admin/article/create`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public EditArtical(id, data: any): Observable<any> {
    return this.http.post(`detail/admin/article/${id}/edit`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public getArticalDetails(id: number): Observable<any> {
    return this.http.get(`detail/admin/article/${id}/edit`);
  }
  public editArtical(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/article/${id}/edit`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public articalDataUpdate(data: any): Observable<any> {
    return this.http.post(`detail/admin/article`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public articalMassDelete(data: any): Observable<any> {
    return this.http.post(`detail/admin/massarticle/delete`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public articalDelete(data: any, id: number): Observable<any> {
    return this.http.post(`detail/admin/article/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public featureimageremove(data: any): Observable<any> {
    return this.http.post(`detail/admin/article/featureimage/${data.id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public imageRemove(data: any): Observable<any> {
    return this.http.post(`detail/admin/image/delete/${data.id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public articalprivatestatus(data: any, id: number): Observable<any> {
    return this.http
      .post(`detail/admin/article/privatestatus/${id}`, data)
      .pipe(
        tap(() => {
          this.RefreshRquestAdmin$.next();
        })
      );
  }
  public articalstatusChange(data: any, id: number): Observable<any> {
    return this.http.post(`detail/admin/article/status/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public refundRequest(id): Observable<any> {
    return this.http.get(`detail/admin/refundRequests/${id}`);
  }
  public invoice(id): Observable<any> {
    return this.http.get(`detail/admin/invoice/${id}`);
  }
  public invoicePaymentStripeSuccess(): Observable<any> {
    return this.http.get(`detail/admin/invoicePayment/StripeSuccess`);
  }
  public invoicePaymentPaypalSuccess(): Observable<any> {
    return this.http.get(`detail/admin/invoicePayment/PaypalSuccess`);
  }
  public invoicePaymentStripeError(id): Observable<any> {
    return this.http.get(`detail/admin/invoicePayment/StripeError/${id}`);
  }
  public invoicePaymentPaypalError(id): Observable<any> {
    return this.http.get(`detail/admin/invoicePayment/PaypalError/${id}`);
  }
  public createInvoice(): Observable<any> {
    return this.http.get(`detail/admin/customInvoices/create`);
  }
  public cancelInvoice(id): Observable<any> {
    return this.http.get(`detail/admin/invoice/cancel/${id}`).pipe(tap(() => {this.RefreshRquestAdmin$.next();}));
  }
  public refundView(id): Observable<any> {
    return this.http.get(`detail/admin/refundView/${id}`);
  }
  public customInvoicePay(id): Observable<any> {
    return this.http.get(`detail/admin/customInvoice/pay/${id}`);
  }
  public customInvoice(id): Observable<any> {
    return this.http.get(`detail/admin/customInvoices/${id}`);
  }
  public invoiceDelete(id): Observable<any> {
    return this.http.delete(`detail/admin/invoice/delete/${id}`).pipe(tap(() => {this.RefreshRquestAdmin$.next();}));
  }
  
  public customInvoicesStore(data: any): Observable<any> {
    return this.http.post(`detail/admin/customInvoices/store`, data).pipe(tap(() => {this.RefreshRquestAdmin$.next();}));
  }
  public requestRefund(data: any): Observable<any> {
    return this.http.post(`detail/admin/requestRefund`, data).pipe(tap(() => {this.RefreshRquestAdmin$.next();}));
  }
  public requestRefundPostComment(data: any): Observable<any> {
    return this.http.post(`detail/admin/requestRefund/postComment`, data).pipe(tap(() => {this.RefreshRquestAdmin$.next();}));
  }
  public invoiceCheckout(data: any): Observable<any> {
    return this.http.post(`detail/admin/invoiceCheckout`, data).pipe(tap(() => {this.RefreshRquestAdmin$.next();}));
  }
  public refundRequestsreject(data: any): Observable<any> {
    return this.http.post(`detail/admin/refundRequests/reject`, data).pipe(tap(() => {this.RefreshRquestAdmin$.next();}));
  }
  public refundRequestsapprove(data: any): Observable<any> {
    return this.http.post(`detail/admin/refundRequests/approve`, data).pipe(tap(() => {this.RefreshRquestAdmin$.next();}));
  }
  public refundRequestspostComment(data: any): Observable<any> {
    return this.http.post(`detail/admin/refundRequests/postComment`, data).pipe(tap(() => {this.RefreshRquestAdmin$.next();}));
  }
  public stripePaymentsStore(data: any): Observable<any> {
    return this.http.post(`detail/admin/stripe/store`, data).pipe(tap(() => {this.RefreshRquestAdmin$.next();}));
  }
  public paypalPaymentsStore(data: any): Observable<any> {
    return this.http.post(`detail/admin/paypal/store`, data).pipe(tap(() => {this.RefreshRquestAdmin$.next();}));
  }

  public refundRequests(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/refundRequests`, { params: params });
  }
  public customInvoices(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/customInvoices`, { params: params });
  }
  public refunds(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/refunds`, { params: params });
  }

  //projects
  public projects(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/projects`, { params: params });
  }
  public allprojects(): Observable<any> {
    return this.http.get(`detail/admin/allprojects`);
  }
  public createProjects(data: any): Observable<any> {
    return this.http.post(`detail/admin/projects/create`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deleteProjects(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/projects/delete/{id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public massDeleteProjects(data: any): Observable<any> {
    return this.http.post(`detail/admin/massproject/delete`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public getProjectsassigned(): Observable<any> {
    return this.http.get(`detail/admin/projectsassigned`);
  }
  public projectsassigned(data: any): Observable<any> {
    return this.http.post(`detail/admin/projectsassigned`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public getProjectimport(): Observable<any> {
    return this.http.get(`detail/admin/projectimport`);
  }
  public projectimport(data: any): Observable<any> {
    return this.http.post(`detail/admin/projectimport`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  // departments
  public alldepartments(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/department`, { params: params });
  }
  public createDepartment(data: any): Observable<any> {
    return this.http.post(`detail/admin/department/create`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deleteDepartment(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/department/delete/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deleteAllDepartment(data: any): Observable<any> {
    return this.http.post(`detail/admin/department/deleteall`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public statuschangeDepartment(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/department/status/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  //canned response
  public cannedmessages(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/cannedmessages`, { params: params });
  }
  public getCannedMessage(): Observable<any> {
    return this.http.get(`detail/admin/getCannedMessage`, { headers: this.headers });
  }
  public createCannedmessages(data: any): Observable<any> {
    return this.http.post(`detail/admin/cannedmessages/create`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public editCannedmessages(id: number, data: any): Observable<any> {
    return this.http
      .post(`detail/admin/cannedmessages/update/${id}`, data)
      .pipe(
        tap(() => {
          this.RefreshRquestAdmin$.next();
        })
      );
  }
  public showeditCannedmessages(id: number): Observable<any> {
    return this.http.get(`detail/admin/cannedmessages/edit/${id}`);
  }
  public statusCannedmessages(id: number, data: any): Observable<any> {
    return this.http
      .post(`detail/admin/cannedmessages/status/${id}`, data)
      .pipe(
        tap(() => {
          this.RefreshRquestAdmin$.next();
        })
      );
  }
  public deleteCannedmessages(id: number, data: any): Observable<any> {
    return this.http
      .post(`detail/admin/cannedmessages/delete/${id}`, data)
      .pipe(
        tap(() => {
          this.RefreshRquestAdmin$.next();
        })
      );
  }
  public massDeleteCannedmessages(data: any): Observable<any> {
    return this.http.post(`detail/admin/cannedmessages/delete`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  // Groups

  public groups(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/groups`, { params: params });
  }
  public createGroup(data: any): Observable<any> {
    return this.http.post(`detail/admin/groups/store`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public editGroup(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/groups/update/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deleteGroup(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/groups/delete/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deleteAllGroup(data: any): Observable<any> {
    return this.http.post(`detail/admin/groups/deleteall`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public statuschangeGroup(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/groups/statuschange/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  //employeeActivity
  public employeeActivity(pageCount: number = 1, status: any, notifysearch: string, date: string): Observable<any> {
    return this.http.get(`detail/admin/reports/employee-activity`, {
      params: {
        'page': pageCount,
        'filter': notifysearch,
        'status': status,
        'date': date
      }
    });
  }
  //Notification
  public allNotifications(pageCount: number = 1, status: any, notifysearch: string): Observable<any> {
    return this.http.get(`detail/admin/notifications`, {
      params: {
        'page': pageCount,
        'notifysearch': notifysearch,
        'status': status
      }
    });
  }
  public notification(id: any): Observable<any> {
    return this.http.get(`detail/admin/notification/${id}`);
  }
  public markReq(data: any): Observable<any> {
    return this.http.post(`detail/admin/mark-as-read`, data);
  }
  //Notification
  public notifystatus(data: any): Observable<any> {
    return this.http.post(`detail/admin/notifystatus`, data);
  }
  public notifysearch(data: any): Observable<any> {
    return this.http.post(`detail/admin/notifysearch`, data);
  }
  public deletenotify(data: any): Observable<any> {
    return this.http.post(`detail/admin/notify/delete`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  // Custom Notification
  public customnotification(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/customnotification`, { params: params });
  }
  public customnotificationList(): Observable<any> {
    return this.http.get(`detail/admin/customnotification/customnotificationlist`);
  }
  public customercompose(data: any): Observable<any> {
    return this.http
      .post(`detail/admin/customnotification/customercompose`, data)
      .pipe(
        tap(() => {
          this.RefreshRquestAdmin$.next();
        })
      );
  }
  public employeecompose(data: any): Observable<any> {
    return this.http
      .post(`detail/admin/customnotification/employeecompose`, data)
      .pipe(
        tap(() => {
          this.RefreshRquestAdmin$.next();
        })
      );
  }
  public sentmail(data: any): Observable<any> {
    return this.http
      .post(`detail/admin/customnotification/sentmail`, data)
      .pipe(
        tap(() => {
          this.RefreshRquestAdmin$.next();
        })
      );
  }
  public deleteCustomnotification(id: number, data: any): Observable<any> {
    return this.http
      .post(`detail/admin/customnotification/delete/${id}`, data)
      .pipe(
        tap(() => {
          this.RefreshRquestAdmin$.next();
        })
      );
  }
  public massdeleteCustomnotification(data: any): Observable<any> {
    return this.http
      .post(`detail/admin/customnotification/massdelete`, data)
      .pipe(
        tap(() => {
          this.RefreshRquestAdmin$.next();
        })
      );
  }

  // business hours
  public businesshour(): Observable<any> {
    return this.http.get(`detail/admin/businesshour`);
  }
  public createBusinesshour(data: any): Observable<any> {
    return this.http.post(`detail/admin/businesshour`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public bussinesshourOfflinemsg(data: any): Observable<any> {
    return this.http.post(`detail/admin/bussinesshour/offlinemsg`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public fullhours(data: any): Observable<any> {
    return this.http.post(`detail/admin/businesshour/fullhours`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public createBusinesshourTitle(data: any): Observable<any> {
    return this.http.post(`detail/admin/businesshour/store`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  // custom field
  public customfield(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/customfield`, { params: params });
  }
  public createCustomfield(data: any): Observable<any> {
    return this.http.post(`detail/admin/customfield`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deleteCustomfield(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/customfield/delete/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public massDeleteCustomfield(data: any): Observable<any> {
    return this.http.post(`detail/admin/customfield/deleteall`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public statusCustomfield(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/customfield/status/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  //
  public groupassigned(id: number): Observable<any> {
    return this.http.get(`detail/admin/groupassigned/${id}`);
  }
  public groupcategoryGroup(data: any): Observable<any> {
    return this.http.post(`detail/admin/groupcategory/group`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public assignedcategoryCreateagent(data: any): Observable<any> {
    return this.http
      .post(`detail/admin/assignedcategory/createagent`, data)
      .pipe(
        tap(() => {
          this.RefreshRquestAdmin$.next();
        })
      );
  }

  //GoogleAnalytics

  public googleanalytics(): Observable<any> {
    return this.http.get(`detail/admin/googleanalytics`);
  }

  public GoogleAnalytics(data: any): Observable<any> {
    return this.http.post(`detail/admin/googleanalytics`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  // paymentGateways start
  public paymentGateways(): Observable<any> {
    return this.http.get(`detail/admin/paymentGateways`);
  }
  public stripeStore(data: any): Observable<any> {
    return this.http.post(`detail/admin/stripe/store`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public paypalStore(data: any): Observable<any> {
    return this.http.post(`detail/admin/paypal/store`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public refundSettings(data: any): Observable<any> {
    return this.http.post(`detail/admin/refund/setting`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public updateSettings(data: any): Observable<any> {
    return this.http.post(`detail/admin/update-settings`, data);
  }
  public autoInvoicedeleteSetting(data: any): Observable<any> {
    return this.http.post(`detail/admin/invoice/delete/setting`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public autoInvoiceCancelSetting(data: any): Observable<any> {
    return this.http.post(`detail/admin/invoice/cancel/setting`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  
  // paymentGateways end
  // aisetup start
  public aisetup(): Observable<any> {
    return this.http.get(`detail/admin/aisetup`);
  }


  public geminiApiStore(data: any): Observable<any> {
    return this.http.post(`detail/admin/geminiApi/store`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  // aisetup end

  //Custom CSS&JS

  public customcssjssetting(): Observable<any> {
    return this.http.get(`detail/admin/customcssjssetting`);
  }

  public customcssjs(data: any): Observable<any> {
    return this.http.post(`detail/admin/customcssjssetting`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  //sendtestmail
  public sendTestMail(data: any): Observable<any> {
    return this.http.post(`detail/admin/sendtestmail`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public emailstore(data: any): Observable<any> {
    return this.http.post(`detail/admin/emailsetting`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public checkSmtp(): Observable<any> {
    let data = {};
    return this.http.post(`detail/admin/smtp/check`, data);
  }

  public imapstore(data: any): Observable<any> {
    return this.http.post(`detail/admin/imapstore`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public imapMassDelete(data: any): Observable<any> {
    return this.http.post(`detail/admin/imaps/alldelete`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public imapStatusChange(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/imaps/statuschange/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public imapSingleDelete(id: number, data: any): Observable<any> {
    return this.http.get(`detail/admin/imaps/delete/${id}`).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  // envato api
  public getEnvatoSettings(): Observable<any> {
    return this.http.get(`detail/admin/envatosetting`);
  }
  public expiredsupport(data: any): Observable<any> {
    return this.http.post(`detail/admin/expiredsupport`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public getenvatoapitoken(): Observable<any> {
    return this.http.get(`detail/admin/envatoapitoken`);
  }
  public envatoapitoken(data: any): Observable<any> {
    return this.http.post(`detail/admin/envatoapitoken`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public envatolicensesearch(data: any): Observable<any> {
    return this.http.post(`detail/admin/envatolicensesearch`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public ticketlicenseverify(data: any): Observable<any> {
    return this.http.post(`detail/admin/ticketlicenseverify`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public ticketuserlicenseverify(data: any): Observable<any> {
    return this.http.post(`detail/admin/ticketuserlicenseverify`, data);
  }

  // app info
  public licenseinfo(): Observable<any> {
    return this.http.get(`detail/admin/licenseinfo`);
  }
  public licenseinfoenter(data: any): Observable<any> {
    return this.http.post(`detail/admin/licenseinfoenter`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  //Geting-Setting-meil-Data
  public gettingSendMailData(): Observable<any> {
    return this.http.get(`detail/admin/gettingsendnaildata`);
  }

  public emailticket(): Observable<any> {
    return this.http.get(`detail/admin/emailticket`);
  }
  public emailticketstore(data: any): Observable<any> {
    return this.http.post(`detail/admin/emailticket`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  //Announcement
  public announcement(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/announcement`, { params: params });
  }
  public announcementId(id: number): Observable<any> {
    return this.http.get(`detail/admin/announcement/${id}`);
  }

  public createAnnouncement(data: any): Observable<any> {
    return this.http.post(`detail/admin/announcement/create`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public updateAnnouncement(data: any): Observable<any> {
    return this.http.post(`detail/admin/announcement/update`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public announcementsetting(data: any): Observable<any> {
    return this.http.post(`detail/admin/announcementsetting`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deleteAnnouncement(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/announcement/delete/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public massdeleteAnnouncement(data: any): Observable<any> {
    return this.http
      .post(`detail/admin/announcement/massannouncedelete`, data)
      .pipe(
        tap(() => {
          this.RefreshRquestAdmin$.next();
        })
      );
  }
  public statusAnnouncement(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/announcement/status${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  // Reports

  public reports(): Observable<any> {
    return this.http.get(`detail/admin/reports`);
  }
  public ticketreports(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/reports/ticketreports`, { params: params });
  }
  public employeedetailsReport(id: number): Observable<any> {
    return this.http.get(`detail/admin/reports/employeedetails/${id}`);
  }
  public deleteRatingticket(id: number, data: any): Observable<any> {
    return this.http
      .post(`detail/admin/reports/ratingticket/delete/${id}`, data)
      .pipe(
        tap(() => {
          this.RefreshRquestAdmin$.next();
        })
      );
  }

  // email template

  public emailtemplates(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/emailtemplates`, { params: params });
  }
  public getemailtemplatesEdit(id: number): Observable<any> {
    return this.http.get(`detail/admin/emailtemplates/${id}`);
  }
  public templateSettings(data: any): Observable<any> {
    return this.http.post(`detail/admin/emailtemplates/save`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public emailtemplatesEdit(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/emailtemplates/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  // custom pages
  public pages(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/pages`, { params: params });
  }
  public createPages(data: any): Observable<any> {
    return this.http.post(`detail/admin/pages/create`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deletePage(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/pagesdelete/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public massDeletePages(data: any): Observable<any> {
    return this.http.post(`detail/admin/pagesdeleteall`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public error404(): Observable<any> {
    return this.http.get(`detail/admin/error404`);
  }
  public error404Edit(data: any): Observable<any> {
    return this.http.post(`detail/admin/error404`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public maintenancepage(): Observable<any> {
    return this.http.get(`detail/admin/maintenancepage`);
  }
  public maintenancepageEdit(data: any): Observable<any> {
    return this.http.post(`detail/admin/maintenancepage`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  // landing page
  // banner
  public bannersetting(): Observable<any> {
    return this.http.get(`detail/admin/bannersetting`);
  }
  public bannerstore(data: any): Observable<any> {
    return this.http.post(`detail/admin/bannerstore`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  // feature
  public featureBox(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/feature-box`, { params: params });
  }
  public featureBoxFeature(data: any): Observable<any> {
    return this.http.post(`detail/admin/feature-box/feature`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public CreatefeatureBox(data: any, http: any): Observable<any> {
    return this.http.post(`detail/admin/feature-box/create`, data, http).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public DeletefeatureBox(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/feature-box/delete/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public MassDeletefeatureBox(data: any): Observable<any> {
    return this.http.post(`detail/admin/feature-box/deleteall`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  // call-to-action

  public callToAction(): Observable<any> {
    return this.http.get(`detail/admin/call-to-action`);
  }
  public callToActionUpdate(data: any, http: any): Observable<any> {
    return this.http.post(`detail/admin/call-to-action`, data, http).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  // testimonial

  public testimonialSection(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/testimonial`, { params: params });
  }
  public testimonialSectionUpdate(data: any): Observable<any> {
    return this.http.post(`detail/admin/testimonial`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public createTestimonial(data: any, http: any): Observable<any> {
    return this.http.post(`detail/admin/testimonial/create`, data, http).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public testimonialDelete(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/testimonial/delete/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public MassDeletetestimonial(data: any): Observable<any> {
    return this.http.post(`detail/admin/testimonial/deleteall`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  // faq

  public faqSection(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/faq`, { params: params });
  }
  public faqSectionUpdate(data: any): Observable<any> {
    return this.http.post(`detail/admin/faq`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public createFaqs(data: any): Observable<any> {
    return this.http.post(`detail/admin/faq/create`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deleteFaq(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/faq/delete/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public MassDeleteFaq(data: any): Observable<any> {
    return this.http.post(`detail/admin/faq/deleteall`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public statusFaq(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/faq/status${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public privatestatusFaq(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/faq/privatestatus/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  // faq category
  public faqcategory(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/faqcategory`, { params: params });
  }
  public createfaqcategory(data: any): Observable<any> {
    return this.http.post(`detail/admin/faqcategory/store`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public deletefaqcategory(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/faqcategory/delete/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public massDeletefaqcategory(data: any): Observable<any> {
    return this.http.post(`detail/admin/faqcategory/deleteall`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public statusfaqcategory(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/faqcategory/status/${id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public securitysettingstore(data: any): Observable<any> {
    return this.http.post(`detail/admin/securitysetting`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  //securitysetting
  public securitysetting(): Observable<any> {
    return this.http.get(`detail/admin/securitysetting`);
  }

  public adminsecuritysetting(data: any): Observable<any> {
    return this.http.post(`detail/admin/adminsecuritysetting`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public securitysettingIP(data: any): Observable<any> {
    return this.http.post(`detail/admin/securitysetting/ip`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public emaildomain(data: any): Observable<any> {
    return this.http.post(`detail/admin/emaildomain`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  //External Chat Setting
  public customchats(data: any): Observable<any> {
    return this.http.post(`detail/admin/customchatsetting`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  //captcha setting
  public captchastore(data: any): Observable<any> {
    return this.http.post(`detail/admin/captcha`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  //Setting Data
  public ticketsettingget(): Observable<any> {
    return this.http.get(`detail/admin/ticketsetting`);
  }
  public ticketsetting(data: any): Observable<any> {
    return this.http.post(`detail/admin/ticketsetting`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  //Ticket setting
  public filesettingstore(data: any): Observable<any> {
    return this.http.post(`detail/admin/filesetting`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public businesslogodelete(data: any): Observable<any> {
    return this.http.post(`detail/admin/businesslogodelete`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public logodelete(data: any): Observable<any> {
    return this.http.post(`detail/admin/logodelete`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public customercsv(data: any, http: any): Observable<any> {
    return this.http.post(`detail/admin/customerimport`, data, http).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public uploadProjects(data: any, http: any): Observable<any> {
    return this.http.post(`detail/admin/projectimport`, data, http).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public imageremove(data: any): Observable<any> {
    return this.http.post(`detail/admin/image/remove/${data.id}`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public guestmedia(data: any, http: any): Observable<any> {
    return this.http.post(`detail/admin/imageupload`, data, http);
  }

  public replyTicketstoreMedia(id, data: any): Observable<any> {
    return this.http.post(`detail/admin/ticket/imageupload/${id}`, data);
  }

  public captcha(): Observable<any> {
    return this.http.get(`detail/admin/captcha`);
  }

  public captchatypestore(data: any): Observable<any> {
    return this.http.post(`detail/admin/captchatype`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public CaptchaContactForm(data: any): Observable<any> {
    return this.http.post(`detail/admin/captchacontact`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public captcharegister(data: any): Observable<any> {
    return this.http.post(`detail/admin/captcharegister`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public captchalogin(data: any): Observable<any> {
    return this.http.post(`detail/admin/captchalogin`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public captchaguest(data: any): Observable<any> {
    return this.http.post(`detail/admin/captchaguest`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public captchaadminlogin(data: any): Observable<any> {
    return this.http.post(`detail/admin/captchaadminlogin`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public sociallogin(): Observable<any> {
    return this.http.get(`detail/admin/sociallogin`);
  }

  public socialloginupdate(data: any): Observable<any> {
    return this.http.post(`detail/admin/sociallogin`, data).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }

  public customchatsetting(): Observable<any> {
    return this.http.get(`detail/admin/customchatsetting`);
  }

  public featureimageupload(data: any, http: any): Observable<any> {
    return this.http
      .post(`detail/admin/article/featureimageupload`, data, http);
  }

  public articleimageupload(data: any, http: any): Observable<any> {
    return this.http.post(`detail/admin/article/imageupload`, data, http);
  }

  public notificationsreading(): Observable<any> {
    return this.http.get(`detail/admin/notificationsreading`);
  }

  public markallnotify(data: any): Observable<any> {
    return this.http.post(`detail/admin/markallnotify`, data);
  }

  public markNotification(data: any): Observable<any> {
    return this.http.post(`detail/admin/mark-as-read`, data);
  }
  // reply response 
  public employeesreplyingremove(data: any): Observable<any> {
    return this.http.post(`detail/admin/employeesreplyingremove`, data);
  }
  public employeesreplyingstore(data: any): Observable<any> {
    return this.http.post(`detail/admin/employeesreplyingstore`, data);
  }
  public getemployeesreplying(ticketid: any): Observable<any> {
    return this.http.get(`detail/admin/getemployeesreplying/${ticketid}`);
  }
  public botimagedelete(): Observable<any> {
    return this.http.get(`detail/admin/botimagedelete`).pipe(
      tap(() => {
        this.RefreshRquestAdmin$.next();
      })
    );
  }
  public botsettingstore(data: any): Observable<any> {
    return this.http.post(`detail/admin/botsettingstore`, data);
  }
  public botresponsettingcreate(): Observable<any> {
    return this.http.get(`detail/admin/botresponsettingcreate`);
  }
  public twiliosetting(): Observable<any> {
    return this.http.get(`detail/admin/twiliosetting`);
  }
  public twiliosettingstore(data: any): Observable<any> {
    return this.http.post(`detail/admin/twiliosettingstore`, data);
  }
  public smstemplateedit(id: number): Observable<any> {
    return this.http.get(`detail/admin/smstemplateedit/${id}`);
  }
  public smstemplateUpdate(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/smstemplateUpdate/${id}`, data);
  }

  getUTCFromTimezone(timezone: string): any {

    const offsetInMinutes = moment.tz(timezone).utcOffset();

    // Convert the offset to hours and format it as UTC+/-X
    const sign = offsetInMinutes >= 0 ? '+' : '-';
    const offsetInHours = Math.abs(offsetInMinutes) / 60;
    const formattedOffset = `UTC${sign}${offsetInHours < 10 ? '0' : ''}${offsetInHours}`;

    return formattedOffset;
  }
}
