import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable, tap } from 'rxjs';
import { AdminService } from './admin.service';

@Injectable({
  providedIn: 'root'
})
export class SeoService {
  constructor(private http: HttpClient,private adminService: AdminService) { }

  public index(): Observable<any> {
    return this.http.get(`detail/admin/seo`);
  }

  public seoStore(data:any): Observable<any>{
    return this.http.post(`detail/admin/seo/create`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
}
