import { Injectable } from '@angular/core';
import { Router } from '@angular/router';
import { BehaviorSubject, fromEvent } from 'rxjs';
import { takeUntil, debounceTime } from 'rxjs/operators';
import { Unsub } from '../class/unsub.class';
import { customerSidemenuIcons, sidemenuIcons } from '../data/sidemenu-icons-list';
import { LoaderService } from './loader.service';

//Menu interface
export interface Menu {
  headTitle?: string;
  title?: string;
  path?: string;
  icon?: string;
  type?: string;
  badgeClass?: string;
  badgeValue?: string;
  dashboardType?: string[];
  active?: boolean;
  userPermission: string | boolean;
  children?: Menu[];
  ENVATO_ON?: string;
  Domain?: string;
}

@Injectable({
  providedIn: 'root',
})
export class NavService extends Unsub {
  public screenWidth: BehaviorSubject<number> = new BehaviorSubject(
    window.innerWidth
  );

  public collapseSidebar: boolean = window.innerWidth < 991 ? true : false;
  constructor(private router: Router, loaderService: LoaderService) {
    /**
    * This code calls the constructor of the parent class in a subclass.
    * The super() function is used to initialize the parent class and allows access to its properties and methods.
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.setScreenWidth(window.innerWidth);
    fromEvent(window, 'resize')
      .pipe(debounceTime(1000), takeUntil(this.unSubscribe$))
      .subscribe({
        next: (evt: any) => {
          this.setScreenWidth(evt.target.innerWidth);
          if (evt.target.innerwidth < 991) {
            this.collapseSidebar = false;
          }
        },
      });
    if (window.innerWidth < 991) {
      this.router.events.pipe(takeUntil(this.unSubscribe$)).subscribe({
        next: () => {
          this.collapseSidebar = false;
        },
      });
    }

  }
  /**
   * @param width
   * This is a private method in a TypeScript class that takes in a number parameter called width.
   * It calls the next method on an instance variable called screenWidth with the widthparameter as its argument.
   * The purpose of this method is to update the value of screenWidthwith the new width.
   **/
  private setScreenWidth(width: number): void {
    this.screenWidth.next(width);
  }

  // (Admin / Employee) Dashboard menu list
  AdminMenuList: Menu[] = [
    {
      path: '/admin/dashboard',
      title: 'Dashboard',
      type: 'link',
      icon: sidemenuIcons.dashboard,
      active: false,
      userPermission: true,
      dashboardType: ['admin', 'employee'],
    },
    {
      path: '/admin/profile',
      title: 'Profile',
      type: 'link',
      icon: sidemenuIcons.profile,
      active: false,
      userPermission: true,
      dashboardType: ['admin', 'employee'],
    },
    {
      title: 'Global Tickets',
      icon: sidemenuIcons.tickets,
      type: 'sub',
      active: false,
      userPermission: true,
      dashboardType: ['admin'],
      children: [
        {
          path: '/admin/global-tickets/recent-tickets',
          title: 'Recent Tickets',
          type: 'link',
          active: false,
          userPermission: true,
          dashboardType: ['admin'],
        },
        {
          path: '/admin/global-tickets/total-tickets',
          title: 'Total Tickets',
          type: 'link',
          active: false,
          userPermission: true,
          dashboardType: ['admin'],
        },
        {
          path: '/admin/global-tickets/active-tickets',
          userPermission: true,
          dashboardType: ['admin'],
          title: 'Active Tickets',
          type: 'link',
          active: false,
        },
        {
          path: '/admin/global-tickets/closed-tickets',
          title: 'Closed Tickets',
          type: 'link',
          active: false,
          userPermission: true,
          dashboardType: ['admin'],
        },
        {
          path: '/admin/global-tickets/on-hold-tickets',
          title: 'OnHold Tickets',
          type: 'link',
          active: false,
          userPermission: true,
          dashboardType: ['admin'],
        },
        {
          path: '/admin/global-tickets/over-due-tickets',
          title: 'Overdue Tickets',
          type: 'link',
          active: false,
          userPermission: true,
          dashboardType: ['admin'],
        },
        {
          path: '/admin/global-tickets/assigned-tickets',
          title: 'Assigned Tickets',
          type: 'link',
          active: false,
          userPermission: true,
          dashboardType: ['admin'],
        }
      ],
    },
    {
      title: 'Self Tickets',
      icon: sidemenuIcons.tickets,
      type: 'sub',
      active: false,
      userPermission: true,
      dashboardType: ['admin'],
      children: [
        {
          path: '/admin/self-tickets/self-assigned-tickets',
          title: 'Self Assigned Tickets',
          type: 'link',
          active: false,
          userPermission: true,
          dashboardType: ['admin'],
        },
        {
          path: '/admin/self-tickets/my-assigned-tickets',
          title: 'My Assigned Tickets',
          type: 'link',
          active: false,
          userPermission: true,
          dashboardType: ['admin'],
        },
        {
          path: '/admin/self-tickets/closed-tickets',
          title: 'Closed Tickets',
          type: 'link',
          active: false,
          userPermission: true,
          dashboardType: ['admin'],
        }
      ],
    },
    {
      title: 'Live Chat',
      icon: sidemenuIcons.livechat,
      type: 'sub',
      active: false,
      userPermission: "Livechat Access",
      children: [
        {
          path: '/admin/live-chat/new-chats',
          title: 'New Chats',
          type: 'link',
          active: false,
          userPermission: "Customer Chat Process",
        },
        {
          path: '/admin/live-chat/my-open-chats',
          title: 'My Open Chats',
          type: 'link',
          active: false,
          userPermission: "Customer Chat Process",
        },
        {
          path: '/admin/live-chat/solved-chats',
          title: 'Solved Chats',
          type: 'link',
          active: false,
          userPermission: "Customer Chat Process",
        },
        {
          path: '/admin/live-chat/operators',
          title: 'Operators',
          type: 'link',
          active: false,
          userPermission: "Operators",
        },
        {
          path: '/admin/live-chat/chat-flow',
          title: 'Chat Flow',
          type: 'link',
          active: false,
          userPermission: "Chat Flows"
        },
        {
          path: '/admin/live-chat/live-chat-settings',
          title: 'Live Chat Settings',
          type: 'link',
          active: false,
          userPermission: "Livechat Settings",
        },
        {
          path: '/admin/live-chat/live-chat-ratings',
          title: 'Live Chat Ratings',
          type: 'link',
          active: false,
          userPermission: "Livechat Ratings",
        },
      ],
    },
    {
      title: 'Tickets',
      icon: sidemenuIcons.tickets,
      type: 'sub',
      active: false,
      userPermission: true,
      dashboardType: ['employee'],
      children: [
        {
          path: '/admin/tickets/recent-tickets',
          title: 'Recent Tickets',
          type: 'link',
          active: false,
          userPermission: true,
          dashboardType: ['employee'],
        },
        {
          path: '/admin/tickets/active-tickets',
          userPermission: true,
          dashboardType: ['employee'],
          title: 'Active Tickets',
          type: 'link',
          active: false,
        },
        {
          path: '/admin/tickets/self-assigned-tickets',
          title: 'Self Assigned Tickets',
          type: 'link',
          active: false,
          userPermission: true,
          dashboardType: ['employee'],
        },
        {
          path: '/admin/tickets/my-assigned-tickets',
          title: 'My Assigned Tickets',
          type: 'link',
          active: false,
          userPermission: true,
          dashboardType: ['employee'],
        },
        {
          path: '/admin/tickets/closed-tickets',
          title: 'Closed Tickets',
          type: 'link',
          active: false,
          userPermission: true,
          dashboardType: ['employee'],
        }
      ],
    },
    {
      path: '/admin/trashed-tickets',
      title: 'Trashed Tickets',
      type: 'link',
      icon: sidemenuIcons.trashed,
      active: false,
      userPermission: true,
      dashboardType: ['admin'],
    },
    {
      title: 'Categories',
      icon: sidemenuIcons.category,
      type: 'sub',
      active: false,
      userPermission: 'Categories Access',
      children: [
        {
          path: '/admin/categories/main-categories',
          title: 'Main Categories',
          type: 'link',
          active: false,
          userPermission: 'Category Access',
        },
        {
          path: '/admin/categories/sub-categories',
          title: 'Sub Categories',
          type: 'link',
          active: false,
          userPermission: 'Subcategory Access',
        },
      ],
    },
    {
      title: 'Knowledge',
      icon: sidemenuIcons.knowledge,
      type: 'sub',
      active: false,
      userPermission: 'Knowledge Access',
      children: [
        {
          path: '/admin/knowledge/articles',
          title: 'Articles',
          type: 'link',
          active: false,
          userPermission: 'Article Access',
        },
      ],
    },
    {
      path: '/admin/projects',
      title: 'Projects',
      type: 'link',
      icon: sidemenuIcons.projects,
      active: false,
      userPermission: 'Project Access',
    },
    {
      path: '/admin/department',
      title: 'Department',
      type: 'link',
      icon: sidemenuIcons.department,
      active: false,
      userPermission: 'Department Access',
    },
    {
      title: 'Manage Roles',
      icon: sidemenuIcons.roles,
      type: 'sub',
      active: false,
      userPermission: 'Managerole Access',
      children: [
        {
          path: '/admin/manage-roles/roles-permissions',
          title: 'Roles and Permission',
          type: 'link',
          active: false,
          userPermission: 'Roles & Permission Access'
        },
        {
          path: '/admin/manage-roles/employees-list',
          title: 'Employees List',
          type: 'link',
          active: false,
          userPermission: 'Employee Access',
        },
        {
          path: '/admin/manage-roles/create-employee',
          title: 'Create Employees',
          type: 'link',
          active: false,
          userPermission: 'Employee Create'
        },
      ],
    },
    {
      title: 'Landing Page Settings',
      icon: sidemenuIcons.landingpages,
      type: 'sub',
      active: false,
      userPermission: 'Landing Page Access',
      children: [
        {
          path: '/admin/landingpage-settings/banner',
          title: 'Banner',
          type: 'link',
          active: false,
          userPermission: 'Banner Access',
        },
        {
          path: '/admin/landingpage-settings/feature-box',
          title: 'Feature Box',
          type: 'link',
          active: false,
          userPermission: 'Feature Box Access',
        },
        {
          path: '/admin/landingpage-settings/calltoaction',
          title: 'Call To Action',
          type: 'link',
          active: false,
          userPermission: 'Call To Action Access',
        },
        {
          path: '/admin/landingpage-settings/testimonial',
          title: 'Testimonial',
          type: 'link',
          active: false,
          userPermission: 'Testimonial Access',
        },
        {
          title: "FAQ's",
          type: 'sub',
          active: false,
          userPermission: 'FAQs Access',
          children: [
            {
              path: '/admin/landingpage-settings/mainfaqs/faqs',
              title: "Main FAQ's",
              type: 'link',
              active: false,
              userPermission: 'Main FAQ Access',
            },
            {
              path: '/admin/landingpage-settings/mainfaqs/faq-category',
              title: 'Faq Category',
              type: 'link',
              active: false,
              userPermission: 'FAQ Category Access',
            },
          ],
        },
      ],
    },
    {
      path: '/admin/customer',
      title: 'Customers',
      type: 'link',
      icon: sidemenuIcons.customers,
      active: false,
      userPermission: 'Customers Access',
    },
    {
      path: '/admin/canned-response',
      title: 'Canned Response',
      type: 'link',
      icon: sidemenuIcons.canned,
      active: false,
      userPermission: 'Canned Response Access',
    },
    {
      path: '/admin/domain-transfer',
      title: 'Domain Transfer',
      type: 'link',
      icon: sidemenuIcons.domain,
      active: false,
      userPermission: 'Domain Transfer Access',
      Domain: 'on',
    },
    {
      title: 'Envato',
      icon: sidemenuIcons.envato,
      type: 'sub',
      active: false,
      userPermission: 'Envato Access',
      ENVATO_ON: 'on',
      children: [
        {
          path: '/admin/envato/envato-settings',
          title: 'Envato Settings',
          type: 'link',
          active: false,
          userPermission: true, ENVATO_ON: 'on',
        },
        {
          path: '/admin/envato/envato-api-token',
          title: 'Envato API Token',
          type: 'link',
          active: false,
          userPermission: 'Envato API Token Access', ENVATO_ON: 'on',
        },
        {
          path: '/admin/envato/envato-license-verfication',
          title: 'Envato License Verification',
          type: 'link',
          active: false,
          userPermission: 'Envato License Details Access', ENVATO_ON: 'on',
        },
      ],
    },
    {
      title: 'App Info',
      icon: sidemenuIcons.appinfo,
      type: 'sub',
      active: false,
      userPermission: 'App Info Access',
      children: [
        {
          path: '/admin/app-info/app-purchase-code',
          title: 'App Purchase Code',
          type: 'link',
          active: false,
          userPermission: 'App Purchase Code Access',
        },
      ],
    },
    {
      title: 'Groups',
      icon: sidemenuIcons.groups,
      type: 'sub',
      active: false,
      userPermission: 'Groups Access',
      children: [
        {
          path: '/admin/groups/groups-list',
          title: 'Groups List',
          type: 'link',
          active: false,
          userPermission: 'Groups List Access',
        },
      ],
    },
    {
      title: 'Notifications',
      icon: sidemenuIcons.notification,
      type: 'sub',
      active: false,
      userPermission: true,
      children: [
        {
          path: '/admin/notifications/all-notifications',
          title: 'All Notifications',
          type: 'link',
          active: false,
          userPermission: true,
        },
        {
          path: '/admin/notifications/custom-notifications',
          title: 'Custom Notifications',
          type: 'link',
          active: false,
          userPermission: 'Custom Notifications Access'
        },
      ],
    },
    {
      title: 'Custom Pages',
      icon: sidemenuIcons.custompages,
      type: 'sub',
      active: false,
      userPermission: 'Custom Pages Access',
      children: [
        {
          path: '/admin/custom-pages/pages',
          title: 'Pages',
          type: 'link',
          active: false,
          userPermission: 'Pages Access',
        },
        {
          path: '/admin/custom-pages/error404-page',
          title: 'Error 404 Page',
          type: 'link',
          active: false,
          userPermission: '404 Error Page Access',
        },
        {
          path: '/admin/custom-pages/under-maintenance-page',
          title: 'Under Maintenance Page',
          type: 'link',
          active: false,
          userPermission: 'Under Maintenance Page Access'
        },
      ],
    },
    {
      path: '/admin/holidays',
      title: 'Holidays',
      type: 'link',
      icon: sidemenuIcons.holidays,
      active: false,
      userPermission: 'Holidays Access',
    },
    {
      path: '/admin/business-hours',
      title: 'Business Hours',
      type: 'link',
      icon: sidemenuIcons.businesshours,
      active: false,
      userPermission: 'Business Hours Access',
    },
    {
      path: '/admin/custom-field',
      title: 'Custom Field',
      type: 'link',
      icon: sidemenuIcons.customfields,
      active: false,
      userPermission: 'CustomField Access',
    },
    {
      path: '/admin/languages',
      title: 'Languages',
      type: 'link',
      icon: sidemenuIcons.languages,
      active: false,
      userPermission: 'Languages Access',
    },
    {
      title: 'App Setting',
      icon: sidemenuIcons.appsetting,
      type: 'sub',
      active: false,
      userPermission: 'App Setting Access',
      children: [
        {
          path: '/admin/app-setting/general-setting',
          title: 'General Setting',
          type: 'link',
          active: false,
          userPermission: 'General Setting Access',
        },
        {
          path: '/admin/app-setting/ticket-setting',
          title: 'Ticket Setting',
          type: 'link',
          active: false,
          userPermission: 'Ticket Setting Access',
        },
        {
          path: '/admin/app-setting/seo',
          title: 'SEO',
          type: 'link',
          active: false,
          userPermission: 'SEO Access',
        },
        {
          path: '/admin/app-setting/google-analytics',
          title: 'Google Analytics',
          type: 'link',
          active: false,
          userPermission: 'Google Analytics Access',
        },
        {
          path: '/admin/app-setting/custom-css-js',
          title: 'Custom CSS & JS',
          type: 'link',
          active: false,
          userPermission: 'Custom JS & CSS Access',
        },
        {
          path: '/admin/app-setting/captcha-setting',
          title: 'Captcha Setting',
          type: 'link',
          active: false,
          userPermission: 'Captcha Setting Access',
        },
        {
          path: '/admin/app-setting/social-logins',
          title: 'Social Logins',
          type: 'link',
          active: false,
          userPermission: 'Social Logins Access',
        },
        {
          path: '/admin/app-setting/email-setting',
          title: 'Email Setting',
          type: 'link',
          active: false,
          userPermission: 'Email Setting Access',
        },
        {
          path: '/admin/app-setting/external-chat',
          title: 'External Chat',
          type: 'link',
          active: false,
          userPermission: 'Custom Chat Access',
        },
        {
          path: '/admin/app-setting/security-setting',
          title: 'Security Setting',
          type: 'link',
          active: false,
          userPermission: 'Security Setting Access',
        },
        {
          path: '/admin/app-setting/ip-list',
          title: 'IP List',
          type: 'link',
          active: false,
          userPermission: 'IpBlock Access',
        },
        {
          path: '/admin/app-setting/botresponsetting',
          title: 'Bot Respone Setting',
          type: 'link',
          active: false,
          userPermission: "Bot Response Setting Access",
        },
        {
          path: '/admin/app-setting/twiliosetting',
          title: 'Twilio Setting',
          type: 'link',
          active: false,
          userPermission: "Twilio Setting Access",
        },
        {
          path: '/admin/app-setting/payment-gateways',
          title: 'Payment Gateways',
          type: 'link',
          active: false,
          userPermission: "Payment Gateways Access",
        },
        {
          path: '/admin/app-setting/ai-setup',
          title: 'AI Setup',
          type: 'link',
          active: false,
          userPermission: "AI Setup Access",
        }
      ],
    },
    {
      path: '/admin/currency',
      title: 'Currencies',
      type: 'link',
      icon: sidemenuIcons.currency,
      active: false,
      userPermission: 'Currencies Access',
    },
    {
      title: 'Payments',
      icon: sidemenuIcons.payments,
      type: 'sub',
      active: false,
      userPermission: 'Payments Access',
      children: [
        {
          path: '/admin/payments/refund-requests',
          title: 'Refund Requests',
          type: 'link',
          active: false,
          userPermission: 'Refund Access',
        },
        {
          path: '/admin/payments/custom-invoices',
          title: 'Custom Invoices',
          type: 'link',
          active: false,
          userPermission: 'Custom Invoices Access',
        },
      ],
    },
    {
      path: '/admin/announcements',
      title: 'Announcements',
      type: 'link',
      icon: sidemenuIcons.announcements,
      active: false,
      userPermission: 'Announcements Access',
    },
    {
      path: '/admin/email-template',
      title: 'Email Templates',
      type: 'link',
      icon: sidemenuIcons.emailtemplate,
      active: false,
      userPermission: 'Email Template Access',
    },
    {
      path: '/admin/addons',
      title: 'Addons',
      type: 'link',
      icon: sidemenuIcons.addons,
      active: false,
      userPermission: 'Addon Access',
    },
    {
      path: '/admin/addspace',
      title: 'Add Space',
      type: 'link',
      icon: sidemenuIcons.addspace,
      active: false,
      userPermission: 'Addspace Access',
    },
    {
      path: '/admin/reports',
      title: 'Reports',
      type: 'link',
      icon: sidemenuIcons.reports,
      active: false,
      userPermission: 'Reports Access',
    },
    {
      path: '',
      title: 'Clear Cache',
      type: 'clearCache',
      icon: sidemenuIcons.cache,
      active: false,
      userPermission: true,
      dashboardType: ['admin', 'employee'],
    },
    {
      path: 'https://support.spruko.com/',
      title: 'Contact Support',
      type: 'external',
      icon: sidemenuIcons.contactsupport,
      active: false,
      userPermission: true,
      dashboardType: ['admin', 'employee'],
    },
  ];

  adminItems = new BehaviorSubject<Menu[]>(this.AdminMenuList);

  // Customer Menu
  // CustomerMenuList: Menu[] = [
  //   {
  //     path: '/dashboard',
  //     title: 'Dashboard',
  //     type: 'link',
  //     icon: customerSidemenuIcons.dashboard,
  //     active: false,
  //     userPermission : true
  //   },
  //   {
  //     path: '/edit-profile',
  //     title: 'Edit Profile',
  //     type: 'link',
  //     icon: customerSidemenuIcons.profile,
  //     active: false,
  //     userPermission : true
  //   },
  //   {
  //     path: '/create-ticket',
  //     title: 'Create Ticket',
  //     type: 'link',
  //     icon: customerSidemenuIcons.createTicket,
  //     active: false,
  //     userPermission : true
  //   },
  //   {
  //     path: '/active-tickets',
  //     title: 'Active Tickets',
  //     type: 'link',
  //     icon: customerSidemenuIcons.activeTicket,
  //     active: false,
  //     userPermission : true
  //   },
  //   {
  //     path: '/closed-tickets',
  //     title: 'Closed Tickets',
  //     type: 'link',
  //     icon: customerSidemenuIcons.closedTicket,
  //     active: false,
  //     userPermission : true
  //   },
  //   {
  //     path: '/onhold-tickets',
  //     title: 'Onhold Tickets',
  //     type: 'link',
  //     icon: customerSidemenuIcons.onHoldTicket,
  //     active: false,
  //     userPermission : true
  //   },
  // ];

  CustomerMenuList:Menu[] = [
    {
      path: '/customer/dashboard',
      title: 'Dashboard',
      type: 'link',
      icon: customerSidemenuIcons.dashboard,
      active: false,
      userPermission: true
    },

    {
      title: 'All Tickets',
      icon: customerSidemenuIcons.ticket,
      type: 'sub',
      active: false,
      userPermission: true,
      children: [
        {
          path: '/customer/active-tickets',
          title: 'Active Tickets',
          type: 'link',
          active: false,
          userPermission: true,
        },
        {
          path: '/customer/closed-tickets',
          title: 'Closed Tickets',
          type: 'link',
          active: false,
          userPermission: true,
        },
        {
          path: '/customer/onhold-tickets',
          userPermission: true,
          title: 'On-Hold Tickets',
          type: 'link',
          active: false,
        }
      ],
    },
    {
      path: '/customer/quotations',
      icon: customerSidemenuIcons.quotations,
      title: 'Quotations',
      type: 'link',
      active: false,
      userPermission: true,
    },
    {
      path: '/customer/invoices',
      icon: customerSidemenuIcons.invoices,
      title: 'Invoices',
      type: 'link',
      active: false,
      userPermission: true,
    },
  ]

  CustomerItems = new BehaviorSubject<Menu[]>(this.CustomerMenuList);
}
