const { exec } = require('child_process');

// Start Angular build in watch mode
const buildProcess = exec('ng build --watch');

buildProcess.stdout.on('data', (data) => {
  console.log(`Angular build: ${data}`);
  startNodemonWithDelay();
});

buildProcess.stderr.on('data', (data) => {
  console.error(`Angular build error: ${data}`);
});

buildProcess.on('close', (code) => {
  console.log(`Angular build process exited with code ${code}`);
});

// Function to start nodemon after a delay
function startNodemonWithDelay() {
  console.log('Waiting before starting nodemon...');
  setTimeout(() => {
    const nodemonProcess = exec('nodemon modify-index.js');

    nodemonProcess.stdout.on('data', (data) => {
      console.log(`Nodemon: ${data}`);
    });

    nodemonProcess.stderr.on('data', (data) => {
      console.error(`Nodemon error: ${data}`);
    });

    nodemonProcess.on('close', (code) => {
      console.log(`Nodemon process exited with code ${code}`);
    });
  }, 5000); // Delay of 5000 milliseconds (5 seconds)
}
