<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;

class ConversationEvent implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $applicationname,$message,$status,$userdetails,$image,$comment,$replyUserType,$ticketId,$ticketType,$encrypted_id;

    /**
     * Create a new event instance.
     */
    public function __construct($applicationname=null,$message=null,$status=null,$userdetails=null,$image=null,$comment=null,$replyUserType=null,$ticketId=null,$ticketType=null,$encrypted_id=null)
    {
        $this->applicationname=$applicationname;
        $this->message = $message;
        $this->status = $status;
        $this->userdetails = $userdetails;
        $this->image = $image;
        $this->comment = $comment;
        $this->replyUserType = $replyUserType;
        $this->ticketId = $ticketId;
        $this->ticketType = $ticketType;
        $this->encrypted_id = $encrypted_id;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new Channel('conversation');
        // return [
        //     new PrivateChannel('channel-name'),
        // ];
    }
}
