<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\Ticket\Ticket;
use App\Models\Ticket\Comment;
use Auth;
use DB;
use App\Models\tickethistory;
use App\Models\User;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Role;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;

class AdminTicketViewController extends Controller
{

    public function customerprevioustickets(Request $request, $cust_id)
    {
        $cust_id = decrypt($cust_id);
        $users = Customer::find($cust_id);
        $data['users'] = $users;

        $total = Ticket::where('cust_id', $cust_id)->latest('updated_at')->get();
        $data['total'] = $total->count();


        $query = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category', 'users')->where('cust_id', $cust_id)->latest('updated_at');

        $category      = $request['categories'] ?? null;
        $user  = $request['user'] ?? null;
        $status  = $request['status'] ?? null;
        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;
        // filter by category
        if ($category && $category != 'null') {
            $query->where('category_id', $category);
        }

        // get only tickets that specified user has created
        if ($user && $user != 'null') {
            $query->WhereHas('cust', function ($query) use ($user) {
                $query->where('userType', $user);
            });
        }
        // get only tickets that specified user has created
        if ($status && $status != 'null') {
            $query->where('status', $status);
        }


        if ($searchTerm) {
            $query->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('tickets');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
                $query->orWhereHas('category', function ($query) use ($searchTerm) {
                    $query->where('name', 'LIKE', $searchTerm . '%');
                })->orWhereHas('cust', function ($query) use ($searchTerm) {
                    $query->where('username', 'LIKE', $searchTerm . '%');
                })
                    ->orWhereHas('selfassign', function ($query) use ($searchTerm) {
                        $query->where(function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                            // Check for 'self' in the search term
                            if (strpos('self', strtolower($searchTerm)) !== false) {
                                // Also check if the selfassignuser_id is not null
                                $query->orWhere('selfassignuser_id', '!=', null);
                            }
                        });
                    })
                    ->orWhereHas('ticketassignmutliples', function ($query) use ($searchTerm) {
                        // Assuming you defined the 'assignedUser()' relationship in ticketassignchild model
                        $query->whereHas('toassignuser', function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                        });
                        if (stripos('multi Assign', strtolower($searchTerm)) !== false) {
                            $query->orWhere('ticket_id', '!=', null);
                        }
                    });
                });
        }
        $items = $query->paginate($perPage);


        $data['queryList'] = $items;

        $active = Ticket::where('cust_id', $cust_id)->whereIn('status', ['New', 'Re-Open', 'Inprogress'])->get();
        $data['active'] = $active->count();

        $closed = Ticket::where('cust_id', $cust_id)->where('status', 'Closed')->get();
        $data['closed'] = $closed->count();

        $onhold = Ticket::where('cust_id', $cust_id)->where('status', 'On-Hold')->get();
        $data['onhold'] = $onhold->count();

        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $data['user'] = $user;
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }

        $data['setting'] = response()->json(['date_format' => setting('date_format')]);
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        return $data;
    }

    public function selfassignticketview(Request $request)
    {
        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }

        $query =  Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category', 'users')->where('selfassignuser_id', auth()->id())->whereNotIn('status', ['Closed', 'Suspend'])->latest('updated_at');

        $category      = $request['categories'] ?? null;
        $user  = $request['user'] ?? null;
        $status  = $request['status'] ?? null;
        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;
        // filter by category
        if ($category && $category != 'null') {
            $query->where('category_id', $category);
        }

        // get only tickets that specified user has created
        if ($user && $user != 'null') {
            $query->WhereHas('cust', function ($query) use ($user) {
                $query->where('userType', $user);
            });
        }
        // get only tickets that specified user has created
        if ($status && $status != 'null') {
            $query->where('status', $status);
        }


        if ($searchTerm) {
            $query->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('tickets');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
                $query->orWhereHas('category', function ($query) use ($searchTerm) {
                    $query->where('name', 'LIKE', $searchTerm . '%');
                })->orWhereHas('cust', function ($query) use ($searchTerm) {
                    $query->where('username', 'LIKE', $searchTerm . '%');
                })
                    ->orWhereHas('selfassign', function ($query) use ($searchTerm) {
                        $query->where(function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                            // Check for 'self' in the search term
                            if (strpos('self', strtolower($searchTerm)) !== false) {
                                // Also check if the selfassignuser_id is not null
                                $query->orWhere('selfassignuser_id', '!=', null);
                            }
                        });
                    })
                    ->orWhereHas('ticketassignmutliples', function ($query) use ($searchTerm) {
                        // Assuming you defined the 'assignedUser()' relationship in ticketassignchild model
                        $query->whereHas('toassignuser', function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                        });
                        if (stripos('multi Assign', strtolower($searchTerm)) !== false) {
                            $query->orWhere('ticket_id', '!=', null);
                        }
                    });
                });
        }
        $items = $query->paginate($perPage);


        $data['queryList'] = $items;

        // ticket note
        $ticketnote = DB::table('ticketnotes')->pluck('ticketnotes.ticket_id')->toArray();
        $data['ticketnote'] = $ticketnote;


        $selfassignedticketsnew = Ticket::where('selfassignuser_id', auth()->id())->where('status', 'New')->count();
        $data['selfassignedticketsnew'] = $selfassignedticketsnew;

        $selfassignedticketsinprogress = Ticket::where('selfassignuser_id', auth()->id())->where('status', 'Inprogress')->count();
        $data['selfassignedticketsinprogress'] = $selfassignedticketsinprogress;

        $selfassignedticketsonhold = Ticket::where('selfassignuser_id', auth()->id())->where('status', 'On-Hold')->count();
        $data['selfassignedticketsonhold'] = $selfassignedticketsonhold;

        $selfassignedticketsreopen = Ticket::where('selfassignuser_id', auth()->id())->where('status', 'Re-Open')->count();
        $data['selfassignedticketsreopen'] = $selfassignedticketsreopen;

        $selfassignedticketsoverdue = Ticket::where('selfassignuser_id', auth()->id())->where('overduestatus', 'Overdue')->count();
        $data['selfassignedticketsoverdue'] = $selfassignedticketsoverdue;

        $selfassignedticketsclosed = Ticket::where('selfassignuser_id', auth()->id())->where('status', 'Closed')->count();
        $data['selfassignedticketsclosed'] = $selfassignedticketsclosed;

        $data['setting'] = response()->json(['date_format' => setting('date_format')]);


        return $data;
    }

    public function myclosedtickets(Request $request)
    {
        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }

        $query = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category', 'users')->where('closedby_user', auth()->id())->latest('updated_at');

        $category      = $request['categories'] ?? null;
        $user  = $request['user'] ?? null;
        $status  = $request['status'] ?? null;
        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;
        // filter by category
        if ($category && $category != 'null') {
            $query->where('category_id', $category);
        }

        // get only tickets that specified user has created
        if ($user && $user != 'null') {
            $query->WhereHas('cust', function ($query) use ($user) {
                $query->where('userType', $user);
            });
        }
        // get only tickets that specified user has created
        if ($status && $status != 'null') {
            $query->where('status', $status);
        }


        if ($searchTerm) {
            $query->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('tickets');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
                $query->orWhereHas('category', function ($query) use ($searchTerm) {
                    $query->where('name', 'LIKE', $searchTerm . '%');
                })->orWhereHas('cust', function ($query) use ($searchTerm) {
                    $query->where('username', 'LIKE', $searchTerm . '%');
                })
                    ->orWhereHas('selfassign', function ($query) use ($searchTerm) {
                        $query->where(function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                            // Check for 'self' in the search term
                            if (strpos('self', strtolower($searchTerm)) !== false) {
                                // Also check if the selfassignuser_id is not null
                                $query->orWhere('selfassignuser_id', '!=', null);
                            }
                        });
                    })
                    ->orWhereHas('ticketassignmutliples', function ($query) use ($searchTerm) {
                        // Assuming you defined the 'assignedUser()' relationship in ticketassignchild model
                        $query->whereHas('toassignuser', function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                        });
                        if (stripos('multi Assign', strtolower($searchTerm)) !== false) {
                            $query->orWhere('ticket_id', '!=', null);
                        }
                    });
                });
        }
        $items = $query->paginate($perPage);


        $data['queryList'] = $items;

        $data['setting'] = response()->json(['date_format' => setting('date_format')]);

        return $data;
    }

    public function tickettrashed(Request $request)
    {

        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }

        $query =  Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category', 'users')->onlyTrashed()->latest('updated_at');

        $category      = $request['categories'] ?? null;
        $user  = $request['user'] ?? null;
        $status  = $request['status'] ?? null;
        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;
        // filter by category
        if ($category && $category != 'null') {
            $query->where('category_id', $category);
        }

        // get only tickets that specified user has created
        if ($user && $user != 'null') {
            $query->WhereHas('cust', function ($query) use ($user) {
                $query->where('userType', $user);
            });
        }
        // get only tickets that specified user has created
        if ($status && $status != 'null') {
            $query->where('status', $status);
        }


        if ($searchTerm) {
            $query->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('tickets');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
                $query->orWhereHas('category', function ($query) use ($searchTerm) {
                    $query->where('name', 'LIKE', $searchTerm . '%');
                })->orWhereHas('cust', function ($query) use ($searchTerm) {
                    $query->where('username', 'LIKE', $searchTerm . '%');
                })
                    ->orWhereHas('selfassign', function ($query) use ($searchTerm) {
                        $query->where(function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                            // Check for 'self' in the search term
                            if (strpos('self', strtolower($searchTerm)) !== false) {
                                // Also check if the selfassignuser_id is not null
                                $query->orWhere('selfassignuser_id', '!=', null);
                            }
                        });
                    })
                    ->orWhereHas('ticketassignmutliples', function ($query) use ($searchTerm) {
                        // Assuming you defined the 'assignedUser()' relationship in ticketassignchild model
                        $query->whereHas('toassignuser', function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                        });
                        if (stripos('multi Assign', strtolower($searchTerm)) !== false) {
                            $query->orWhere('ticket_id', '!=', null);
                        }
                    });
                });
        }
        $items = $query->paginate($perPage);


        $data['queryList'] = $items;

        $data['setting'] = response()->json(['date_format' => setting('date_format')]);


        return $data;
    }

    public function tickettrashedrestore(Request $request, $id)
    {
        // $id = decrypt($id);
        $tickettrashedrestore = Ticket::onlyTrashed()->findOrFail($id);
        $commenttrashedrestore = $tickettrashedrestore->comments()->onlyTrashed()->get();

        if (count($commenttrashedrestore) > 0) {

            $commenttrashedrestore->each->restore();

            // $media = Media::onlyTrashed()->where('model_id', $tickettrashedrestore->id)->where('model_type', get_class($tickettrashedrestore))->where('collection_name', 'ticket')->get();
            // foreach ($media as $media) {
            //     $media->restore();
            // }
            foreach ($commenttrashedrestore as $comment) {
                foreach(Media::onlyTrashed()->where('model_id', $comment->id)->where('model_type', get_class($comment))
                ->where('collection_name', 'comments')->get() as $media){
                    $media->restore();
                }
            }

            $tickethistory = new tickethistory();
            $tickethistory->ticket_id = $tickettrashedrestore->id;

            $tickethistory->ticketnote = $tickettrashedrestore->ticketnote->isNotEmpty();
            $tickethistory->ticketviolation = $tickettrashedrestore->ticketviolation;
            $tickethistory->overduestatus = $tickettrashedrestore->overduestatus;
            $tickethistory->status = $tickettrashedrestore->status;
            $tickethistory->replystatus = $tickettrashedrestore->replystatus;
            $tickethistory->currentAction = 'Ticket Restore';
            $tickethistory->username = Auth::user()->name;
            $tickethistory->type = Auth::user()->getRoleNames()[0];
            $tickethistory->assignUser = null;

            $tickethistory->save();





            foreach ($tickettrashedrestore->ticket_history()->onlyTrashed()->get() as $deletetickethistory) {
                $deletetickethistory->restore();
            }


            $tickettrashedrestore->restore();
            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Re-stored the trashed tickets';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
            return response()->json(['success' => 'The ticket was successfully restore.']);
        } else {


            $tickettrashedrestore->restore();
            // $media = Media::onlyTrashed()->where('model_id', $tickettrashedrestore->id)->where('model_type', get_class($tickettrashedrestore))->where('collection_name', 'ticket')->get();
            // foreach ($media as $media) {
            //     $media->restore();
            // }


            $tickethistory = new tickethistory();
            $tickethistory->ticket_id = $tickettrashedrestore->id;

            $tickethistory->ticketnote = $tickettrashedrestore->ticketnote->isNotEmpty();
            $tickethistory->ticketviolation = $tickettrashedrestore->ticketviolation;
            $tickethistory->overduestatus = $tickettrashedrestore->overduestatus;
            $tickethistory->status = $tickettrashedrestore->status;
            $tickethistory->replystatus = $tickettrashedrestore->replystatus;
            $tickethistory->currentAction = 'Ticket Restore';
            $tickethistory->username = Auth::user()->name;
            $tickethistory->type = Auth::user()->getRoleNames()[0];
            $tickethistory->assignUser = null;
            $tickethistory->save();

            foreach ($tickettrashedrestore->ticket_history()->onlyTrashed()->get() as $deletetickethistory) {
                $deletetickethistory->restore();
            }

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Re-stored the trashed ticket';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
            return response()->json(['success' => 'The ticket was successfully restore.']);
        }
    }

    public function tickettrasheddestroy($id)
    {
        // $id = decrypt($id);
        $tickettrasheddelete = Ticket::onlyTrashed()->findOrFail($id);
        $commenttrasheddelete = $tickettrasheddelete->comments()->onlyTrashed()->get();


        if (count($commenttrasheddelete) > 0) {
            $media = $tickettrasheddelete->getMedia('ticket');

            foreach ($media as $medias) {

                $medias->forceDelete();
            }
            $medias = $tickettrasheddelete->comments()->onlyTrashed()->get();

            foreach ($medias as $mediass) {
                foreach ($mediass->getMedia('comments') as $mediasss) {

                    $mediasss->forceDelete();
                }
            }
            $commenttrasheddelete->each->forceDelete();

            foreach ($tickettrasheddelete->ticket_history()->onlyTrashed()->get() as $deletetickethistory) {
                $deletetickethistory->forceDelete();
            }
            $tickettrasheddelete->forceDelete();
            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Deleted the trashed tickets';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
            return response()->json(['success' => 'The ticket was successfully deleted.']);
        } else {

            $media = $tickettrasheddelete->getMedia('ticket');

            foreach ($media as $medias) {

                $medias->forceDelete();
            }

            foreach ($tickettrasheddelete->ticket_history()->onlyTrashed()->get() as $deletetickethistory) {
                $deletetickethistory->forceDelete();
            }
            $tickettrasheddelete->forceDelete();

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Deleted the trashed tickets';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
            return response()->json(['success' => 'The ticket was successfully deleted.']);
        }
    }


    public function tickettrashedview($id)
    {        
        // $id = decrypt($id);
        $tickettrashedview = Ticket::with('users', 'cust', 'category')->onlyTrashed()->findOrFail($id);
        if (!$tickettrashedview) {
            return response(['noticket' => 'There was no ticket with ' . $id]);
        }
        $data['tickettrashedview'] = $tickettrashedview;
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');

        $comments = Comment::with('cust', 'user')->where('ticket_id', $tickettrashedview->id)->onlyTrashed()->latest()->get();
        $data['comments'] = $comments;
        $ticketnote = $tickettrashedview->ticketnote()->latest()->get();
        $data['ticketnote'] = $ticketnote;
        $setting = response()->json(['purchasecode_on' => setting('purchasecode_on'), 'date_format' => setting('date_format'), 'default_timezone' => setting('default_timezone')]);
        $data['setting'] = $setting;



        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $data['usertimezone'] = $user->timezone;
        $data['userroles'] = $user->roles[0]->name;
        return $data;
    }


    public function alltrashedticketrestore(Request $request)
    {

        $id_arrays = $request->input('id');

        // $id_array = array_map(function ($encryptedValue) {
        //     return decrypt($encryptedValue);
        // }, $id_arrays);

        $sendmails = Ticket::onlyTrashed()->whereIn('id', $id_arrays)->get();

        foreach($sendmails as $tickettrashedrestoreall){
            $commenttrashedrestorealls = $tickettrashedrestoreall->comments()->onlyTrashed()->get();
            foreach($commenttrashedrestorealls as $commenttrashedrestoreall){
                    $commenttrashedrestoreall->restore();
                    // foreach(Media::onlyTrashed()->where('model_id', $commenttrashedrestoreall->id)->where('model_type', get_class($commenttrashedrestoreall))
                    // ->where('collection_name', 'comments')->get() as $media){
                    //     $media->restore();
                    // }
            }
            // $media = Media::onlyTrashed()->where('model_id', $tickettrashedrestoreall->id)->where('model_type', get_class($tickettrashedrestoreall))->where('collection_name', 'ticket')->get();

            // foreach ($media as $media) {
            //     $media->restore();
            // }
            $tickettrashedrestoreall->restore();

            $tickethistory = new tickethistory();
            $tickethistory->ticket_id = $tickettrashedrestoreall->id;

            $tickethistory->ticketnote = $tickettrashedrestoreall->ticketnote->isNotEmpty();
            $tickethistory->overduestatus = $tickettrashedrestoreall->overduestatus;
            $tickethistory->status = $tickettrashedrestoreall->status;
            $tickethistory->replystatus = $tickettrashedrestoreall->replystatus;
            $tickethistory->currentAction = 'Ticket Restore';
            $tickethistory->username = Auth::user()->name;
            $tickethistory->assignUser = null;
            $tickethistory->type = Auth::user()->getRoleNames()[0];

            $tickethistory->save();

            foreach($tickettrashedrestoreall->ticket_history()->onlyTrashed()->get() as $deletetickethistory)
            {
                $deletetickethistory->restore();
            }

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Restored multiple trashed tickets';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
        }
        return response()->json(['success' => 'The ticket was successfully restore.']);
    }

    public function alltrashedticketdelete(Request $request)
    {
        $id_arrays = $request->input('id');

        // $id_array = array_map(function ($encryptedValue) {
        //     return decrypt($encryptedValue);
        // }, $id_arrays);

        $sendmails = Ticket::onlyTrashed()->whereIn('id', $id_arrays)->get();

        foreach ($sendmails as $tickettrasheddeleteeall) {

            $commenttrasheddeleteall = $tickettrasheddeleteeall->comments()->onlyTrashed()->get();


            if (count($commenttrasheddeleteall) > 0) {
                $media = $tickettrasheddeleteeall->getMedia('ticket');

                foreach ($media as $medias) {

                    $medias->forceDelete();
                }

                foreach ($commenttrasheddeleteall as $mediass) {
                    foreach ($mediass->getMedia('comments') as $mediasss) {

                        $mediasss->forceDelete();
                    }

                    $mediass->forceDelete();
                }

                foreach ($tickettrasheddeleteeall->ticket_history()->onlyTrashed()->get() as $deletetickethistory) {
                    $deletetickethistory->forceDelete();
                }


                $sendmails->each->forceDelete();

                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Deleted multiple trashed tickets';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();
                return response()->json(['success' => 'The ticket was successfully deleted.']);
            } else {

                $media = $tickettrasheddeleteeall->getMedia('ticket');

                foreach ($media as $medias) {

                    $medias->forceDelete();
                }

                foreach ($tickettrasheddeleteeall->ticket_history()->onlyTrashed()->get() as $deletetickethistory) {
                    $deletetickethistory->forceDelete();
                }


                $sendmails->each->forceDelete();

                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Deleted multiple trashed tickets';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();

                return response()->json(['success' => 'The ticket was successfully deleted.']);
            }
        }
    }


    public function suspend(Request $request)
    {
        if ($request->unsuspend == 'Inprogress') {
            $ticketsuspend = Ticket::find($request->ticket_id);
            $ticketsuspend->status = 'Inprogress';
            $ticketsuspend->lastreply_mail = Auth::id();
            $ticketsuspend->update();

            $tickethistory = new tickethistory();
            $tickethistory->ticket_id = $ticketsuspend->id;

            $tickethistory->ticketnote = $ticketsuspend->ticketnote->isNotEmpty();
            $tickethistory->ticketviolation = $ticketsuspend->ticketviolation;
            $tickethistory->overduestatus = $ticketsuspend->overduestatus;
            $tickethistory->status = $ticketsuspend->status;
            $tickethistory->replystatus = $ticketsuspend->replystatus;
            $tickethistory->currentAction = 'Unsuspended Ticket';
            $tickethistory->username = Auth::user()->name;
            $tickethistory->type = Auth::user()->getRoleNames()[0];
            $tickethistory->assignUser = null;

            $tickethistory->save();
        } else {
            $ticketsuspend = Ticket::find($request->ticket_id);
            $ticketsuspend->status = 'Suspend';
            $ticketsuspend->lastreply_mail = Auth::id();
            $ticketsuspend->update();


            $tickethistory = new tickethistory();
            $tickethistory->ticket_id = $ticketsuspend->id;

            $tickethistory->ticketnote = $ticketsuspend->ticketnote->isNotEmpty();
            $tickethistory->ticketviolation = $ticketsuspend->ticketviolation;
            $tickethistory->overduestatus = $ticketsuspend->overduestatus;
            $tickethistory->status = $ticketsuspend->status;
            $tickethistory->replystatus = $ticketsuspend->replystatus;
            $tickethistory->currentAction = 'suspended Ticket';
            $tickethistory->username = Auth::user()->name;
            $tickethistory->type = Auth::user()->getRoleNames()[0];
            $tickethistory->assignUser = null;
            
            $tickethistory->save();
        }


        return response()->json(['success' => 'Update Successfully']);
    }


    public function mysuspendtickets(Request $request)
    {
        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }
        $query = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category', 'users')->where('status', 'Suspend')->where('lastreply_mail', auth()->id())->latest('updated_at');

        $category      = $request['categories'] ?? null;
        $user  = $request['user'] ?? null;
        $status  = $request['status'] ?? null;
        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;
        // filter by category
        if ($category && $category != 'null') {
            $query->where('category_id', $category);
        }

        // get only tickets that specified user has created
        if ($user && $user != 'null') {
            $query->WhereHas('cust', function ($query) use ($user) {
                $query->where('userType', $user);
            });
        }
        // get only tickets that specified user has created
        if ($status && $status != 'null') {
            $query->where('status', $status);
        }


        if ($searchTerm) {
            $query->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('tickets');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
                $query->orWhereHas('category', function ($query) use ($searchTerm) {
                    $query->where('name', 'LIKE', $searchTerm . '%');
                })->orWhereHas('cust', function ($query) use ($searchTerm) {
                    $query->where('username', 'LIKE', $searchTerm . '%');
                })
                    ->orWhereHas('selfassign', function ($query) use ($searchTerm) {
                        $query->where(function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                            // Check for 'self' in the search term
                            if (strpos('self', strtolower($searchTerm)) !== false) {
                                // Also check if the selfassignuser_id is not null
                                $query->orWhere('selfassignuser_id', '!=', null);
                            }
                        });
                    })
                    ->orWhereHas('ticketassignmutliples', function ($query) use ($searchTerm) {
                        // Assuming you defined the 'assignedUser()' relationship in ticketassignchild model
                        $query->whereHas('toassignuser', function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                        });
                        if (stripos('multi Assign', strtolower($searchTerm)) !== false) {
                            $query->orWhere('ticket_id', '!=', null);
                        }
                    });
                });
        }
        $items = $query->paginate($perPage);


        $data['queryList'] = $items;

        $data['setting'] = response()->json(['date_format' => setting('date_format')]);

        return $data;
    }

    public function allactiveinprogresstickets(Request $request)
    {

        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }
        $query = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category', 'users')->where('status', 'Inprogress')
            ->latest('updated_at');
        $category      = $request['categories'] ?? null;
        $user  = $request['user'] ?? null;
        $status  = $request['status'] ?? null;
        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;
        // filter by category
        if ($category && $category != 'null') {
            $query->where('category_id', $category);
        }

        // get only tickets that specified user has created
        if ($user && $user != 'null') {
            $query->WhereHas('cust', function ($query) use ($user) {
                $query->where('userType', $user);
            });
        }
        // get only tickets that specified user has created
        if ($status && $status != 'null') {
            $query->where('status', $status);
        }


        if ($searchTerm) {
            $query->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('tickets');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
                $query->orWhereHas('category', function ($query) use ($searchTerm) {
                    $query->where('name', 'LIKE', $searchTerm . '%');
                })->orWhereHas('cust', function ($query) use ($searchTerm) {
                    $query->where('username', 'LIKE', $searchTerm . '%');
                })
                    ->orWhereHas('selfassign', function ($query) use ($searchTerm) {
                        $query->where(function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                            // Check for 'self' in the search term
                            if (strpos('self', strtolower($searchTerm)) !== false) {
                                // Also check if the selfassignuser_id is not null
                                $query->orWhere('selfassignuser_id', '!=', null);
                            }
                        });
                    })
                    ->orWhereHas('ticketassignmutliples', function ($query) use ($searchTerm) {
                        // Assuming you defined the 'assignedUser()' relationship in ticketassignchild model
                        $query->whereHas('toassignuser', function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                        });
                        if (stripos('multi Assign', strtolower($searchTerm)) !== false) {
                            $query->orWhere('ticket_id', '!=', null);
                        }
                    });
                });
        }
        $items = $query->paginate($perPage);


        $data['queryList'] = $items;
        $data['setting'] = response()->json(['date_format' => setting('date_format')]);

        return $data;
    }

    public function allactivereopentickets(Request $request)
    {

        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }

        $query = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category', 'users')->whereIn('status', ['Re-Open'])->latest('updated_at');

        $category      = $request['categories'] ?? null;
        $user  = $request['user'] ?? null;
        $status  = $request['status'] ?? null;
        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;
        // filter by category
        if ($category && $category != 'null') {
            $query->where('category_id', $category);
        }

        // get only tickets that specified user has created
        if ($user && $user != 'null') {
            $query->WhereHas('cust', function ($query) use ($user) {
                $query->where('userType', $user);
            });
        }
        // get only tickets that specified user has created
        if ($status && $status != 'null') {
            $query->where('status', $status);
        }


        if ($searchTerm) {
            $query->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('tickets');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
                $query->orWhereHas('category', function ($query) use ($searchTerm) {
                    $query->where('name', 'LIKE', $searchTerm . '%');
                })->orWhereHas('cust', function ($query) use ($searchTerm) {
                    $query->where('username', 'LIKE', $searchTerm . '%');
                })
                    ->orWhereHas('selfassign', function ($query) use ($searchTerm) {
                        $query->where(function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                            // Check for 'self' in the search term
                            if (strpos('self', strtolower($searchTerm)) !== false) {
                                // Also check if the selfassignuser_id is not null
                                $query->orWhere('selfassignuser_id', '!=', null);
                            }
                        });
                    })
                    ->orWhereHas('ticketassignmutliples', function ($query) use ($searchTerm) {
                        // Assuming you defined the 'assignedUser()' relationship in ticketassignchild model
                        $query->whereHas('toassignuser', function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                        });
                        if (stripos('multi Assign', strtolower($searchTerm)) !== false) {
                            $query->orWhere('ticket_id', '!=', null);
                        }
                    });
                });
        }
        $items = $query->paginate($perPage);


        $data['queryList'] = $items;

        $data['setting'] = response()->json(['date_format' => setting('date_format')]);

        return $data;
    }

    public function allactiveonholdtickets(Request $request)
    {
        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }

        $query = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category', 'users')->whereIn('status', ['On-Hold'])->latest('updated_at');

        $category      = $request['categories'] ?? null;
        $user  = $request['user'] ?? null;
        $status  = $request['status'] ?? null;
        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;
        // filter by category
        if ($category && $category != 'null') {
            $query->where('category_id', $category);
        }

        // get only tickets that specified user has created
        if ($user && $user != 'null') {
            $query->WhereHas('cust', function ($query) use ($user) {
                $query->where('userType', $user);
            });
        }
        // get only tickets that specified user has created
        if ($status && $status != 'null') {
            $query->where('status', $status);
        }


        if ($searchTerm) {
            $query->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('tickets');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
                $query->orWhereHas('category', function ($query) use ($searchTerm) {
                    $query->where('name', 'LIKE', $searchTerm . '%');
                })->orWhereHas('cust', function ($query) use ($searchTerm) {
                    $query->where('username', 'LIKE', $searchTerm . '%');
                })
                    ->orWhereHas('selfassign', function ($query) use ($searchTerm) {
                        $query->where(function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                            // Check for 'self' in the search term
                            if (strpos('self', strtolower($searchTerm)) !== false) {
                                // Also check if the selfassignuser_id is not null
                                $query->orWhere('selfassignuser_id', '!=', null);
                            }
                        });
                    })
                    ->orWhereHas('ticketassignmutliples', function ($query) use ($searchTerm) {
                        // Assuming you defined the 'assignedUser()' relationship in ticketassignchild model
                        $query->whereHas('toassignuser', function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                        });
                        if (stripos('multi Assign', strtolower($searchTerm)) !== false) {
                            $query->orWhere('ticket_id', '!=', null);
                        }
                    });
                });
        }
        $items = $query->paginate($perPage);


        $data['queryList'] = $items;

        $data['setting'] = response()->json(['date_format' => setting('date_format')]);
        return $data;
    }

    public function allactiveassignedtickets(Request $request)
    {

        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }
        $query = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category', 'users')->whereIn('status', ['Re-Open', 'Inprogress', 'On-Hold'])
        ->where(function ($query){
            $query
            ->orWhereNotNull('myassignuser_id')
            ->orWhereNotNull('selfassignuser_id');
            })
            ->latest('updated_at');

        $category      = $request['categories'] ?? null;
        $user  = $request['user'] ?? null;
        $status  = $request['status'] ?? null;
        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;
        // filter by category
        if ($category && $category != 'null') {
            $query->where('category_id', $category);
        }

        // get only tickets that specified user has created
        if ($user && $user != 'null') {
            $query->WhereHas('cust', function ($query) use ($user) {
                $query->where('userType', $user);
            });
        }
        // get only tickets that specified user has created
        if ($status && $status != 'null') {
            $query->where('status', $status);
        }


        if ($searchTerm) {
            $query->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('tickets');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
                $query->orWhereHas('category', function ($query) use ($searchTerm) {
                    $query->where('name', 'LIKE', $searchTerm . '%');
                })->orWhereHas('cust', function ($query) use ($searchTerm) {
                    $query->where('username', 'LIKE', $searchTerm . '%');
                })
                    ->orWhereHas('selfassign', function ($query) use ($searchTerm) {
                        $query->where(function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                            // Check for 'self' in the search term
                            if (strpos('self', strtolower($searchTerm)) !== false) {
                                // Also check if the selfassignuser_id is not null
                                $query->orWhere('selfassignuser_id', '!=', null);
                            }
                        });
                    })
                    ->orWhereHas('ticketassignmutliples', function ($query) use ($searchTerm) {
                        // Assuming you defined the 'assignedUser()' relationship in ticketassignchild model
                        $query->whereHas('toassignuser', function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                        });
                        if (stripos('multi Assign', strtolower($searchTerm)) !== false) {
                            $query->orWhere('ticket_id', '!=', null);
                        }
                    });
                });
        }
        $items = $query->paginate($perPage);


        $data['queryList'] = $items;

        $data['setting'] = response()->json(['date_format' => setting('date_format')]);
        return $data;
    }

    public function tickethistory($id)
    {
        $id = decrypt($id);
        $ticket = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category', 'users', 'ticket_history')->where('ticket_id', $id)->first();
        $data['ticket'] = $ticket;
        $data['ticket_history'] = $ticket->ticket_history;

        $setting = response()->json(['date_format' => setting('date_format'), 'default_timezone' => setting('default_timezone'), 'time_format' => setting('time_format')]);
        $data['setting'] = $setting;

        return $data;
    }
}
