<?php

namespace App\Http\Controllers\Admin\Auth;

use Illuminate\Http\Request;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use App\Models\Seosetting;
use App\Models\Apptitle;
use App\Models\passwordreset;
use Mail;
use App\Models\Announcement;
use App\Models\Holiday;
use Carbon\Carbon;
use laravelLara\infoinst\Jobs\MailSend;

class ForgotPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails;

    public function showLinkRequestForm(){

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $title = Apptitle::first();
        $data['title'] = $title;
        $now = now();
        $announcement = Announcement::whereDate('enddate', '>=', $now->toDateString())->whereDate('startdate', '<=', $now->toDateString())->get();
        $data['announcement'] = $announcement;

        $announcements = Announcement::whereNotNull('announcementday')->get();
        $data['announcements'] = $announcements;
        
        // $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', '1')->get();
        // $data['holidays'] =  $holidays;

        $now = now();
        $currentYear = $now->year;
        $activeHolidays = Holiday::where('status', 1)->get();


        $data['holidays'] = $activeHolidays->filter(function ($holiday) use ($now, $currentYear) {
            $holidayStart = Carbon::parse($holiday->startdate);
            $holidayEnd = Carbon::parse($holiday->enddate);
            if ($holiday->is_fixed) {
                return $holidayStart->month === $now->month && $holidayStart->day === $now->day;
            }
            return $holidayStart->isSameDay($now);
        });
        
        $setting = response()->json(['CAPTCHATYPE' => setting('CAPTCHATYPE'), 'RECAPTCH_ENABLE_ADMIN_LOGIN' => setting('RECAPTCH_ENABLE_ADMIN_LOGIN'), 'GOOGLE_RECAPTCHA_KEY' => setting('GOOGLE_RECAPTCHA_KEY'), 'ANNOUNCEMENT_USER' => setting('ANNOUNCEMENT_USER')]);
        $data['setting'] = $setting;
        return $data;
    }


    /**
     * Send a reset link to the given user.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\JsonResponse
     */
    public function sendResetLinkEmail(Request $request)
    {

        $request->validate([
            'email' => 'required|email|exists:users',
        ]);
        $token = str_random(64);

        $reset = passwordreset::create([
            'email' => $request->email, 
            'token' => $token,
        ]);
        
        $verifyData = [

            'reset_password_url' => url( 'admin/' . $reset->token . '/reset-password'),

          ];

          try{
            dispatch((new MailSend($reset->email, 'forget_password', $verifyData)));
        
        }catch(\Exception $e){
           
            return response()->json(['success' => 'Email Verfication link as successfully sent.Please Check the mail']);        
        }
  
        return response()->json(['success' =>  'We have e-mailed your password reset link!']);
    }

    

}
