<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Apptitle;
use App\Models\Businesshours;
use App\Models\Setting;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class BusinesshourController extends Controller
{
    public function index()
    {
        $this->authorize('Business Hours Access');
        $basic = Apptitle::first();
        $data['basic'] = $basic;

        $data['setting'] = [
            'offlineTextTitle' => setting('offlineTextTitle'),
            'offlineTextMessage' => setting('offlineTextMessage'),
            'businesshourofflinemsg' => setting('businesshourofflinemsg'),
        ];

        $data['start_week'] = setting('start_week');
        $data['businesshoursswitch'] = setting('businesshoursswitch');
        $data['businesshourstitle'] = setting('businesshourstitle');
        $data['businesshourssubtitle'] = setting('businesshourssubtitle');
        $data['24hoursbusinessswitch'] = setting('24hoursbusinessswitch');
        if (setting('supporticonimage')) {
            $data['supporticonimageprev'] = asset('/uploads/support/' . setting('supporticonimage'));
        } else {
            $data['supporticonimageprev'] = asset('/uploads/support/support/support.png');
        }
        $data['supporticonimage'] = setting('supporticonimage');

        $business1 = Businesshours::where('no_id', '1')->first();

        $business2 = Businesshours::where('no_id', '2')->first();

        $business3 = Businesshours::where('no_id', '3')->first();

        $business4 = Businesshours::where('no_id', '4')->first();

        $business5 = Businesshours::where('no_id', '5')->first();

        $business6 = Businesshours::where('no_id', '6')->first();

        $business7 = Businesshours::where('no_id', '7')->first();

        $data['businesshour'] = [
            $business1,
            $business2,
            $business3,
            $business4,
            $business5,
            $business6,
            $business7
        ];
        return $data;
    }

    public function store(Request $request)
    {

        if ($request->starttime1 != null || $request->endtime1 != null || $request->starttime2 != null || $request->endtime2 != null || $request->starttime3 != null || $request->endtime3 != null || $request->starttime4 != null || $request->endtime4 != null || $request->starttime5 != null || $request->endtime5 != null || $request->starttime6 != null || $request->endtime6 != null || $request->starttime7 != null || $request->endtime7 != null) {
            if ($request->starttime1 != $request->endtime1 || $request->starttime2 != $request->endtime2 || $request->starttime3 != $request->endtime3 || $request->starttime4 != $request->endtime4 || $request->starttime5 != $request->endtime5 || $request->starttime6 != $request->endtime6 || $request->starttime7 != $request->endtime7) {

                $this->businessstore($request);
                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Updated Business Hours.';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();
                return response()->json(['success' => 'Updated Successfull']);
            } else {

                return response()->json(['error' => 'Cannot Update the data']);
            }
        }
        $this->businessstore($request);
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated Business Hours.';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Updated Successfull']);
    }

    private function businessstore($request)
    {
        $businessid1 = $request->businessid1;
        $business1 = $request->business1;
        $starttime1 = $request->starttime1;
        $endtime1 = $request->endtime1;
        $status1 = $request->status1;

        $ticket1 = [

            'no_id' => $businessid1,
            'weeks' => $business1,
            'starttime' => $starttime1,
            'endtime' => $endtime1,
            'status' => $status1,

        ];
        $buss1 = Businesshours::updateOrCreate(['no_id' => $businessid1], $ticket1);

        $businessid2 = $request->businessid2;
        $business2 = $request->business2;
        $starttime2 = $request->starttime2;
        $endtime2 = $request->endtime2;
        $status2 = $request->status2;

        $ticket2 = [

            'no_id' => $businessid2,
            'weeks' => $business2,
            'starttime' => $starttime2,
            'endtime' => $endtime2,
            'status' => $status2,

        ];
        $buss2 = Businesshours::updateOrCreate(['no_id' => $businessid2], $ticket2);

        $businessid3 = $request->businessid3;
        $business3 = $request->business3;
        $starttime3 = $request->starttime3;
        $endtime3 = $request->endtime3;
        $status3 = $request->status3;

        $ticket3 = [

            'no_id' => $businessid3,
            'weeks' => $business3,
            'starttime' => $starttime3,
            'endtime' => $endtime3,
            'status' => $status3,

        ];
        $buss3 = Businesshours::updateOrCreate(['no_id' => $businessid3], $ticket3);

        $businessid4 = $request->businessid4;
        $business4 = $request->business4;
        $starttime4 = $request->starttime4;
        $endtime4 = $request->endtime4;
        $status4 = $request->status4;

        $ticket4 = [

            'no_id' => $businessid4,
            'weeks' => $business4,
            'starttime' => $starttime4,
            'endtime' => $endtime4,
            'status' => $status4,

        ];
        $buss4 = Businesshours::updateOrCreate(['no_id' => $businessid4], $ticket4);

        $businessid5 = $request->businessid5;
        $business5 = $request->business5;
        $starttime5 = $request->starttime5;
        $endtime5 = $request->endtime5;
        $status5 = $request->status5;

        $ticket5 = [

            'no_id' => $businessid5,
            'weeks' => $business5,
            'starttime' => $starttime5,
            'endtime' => $endtime5,
            'status' => $status5,

        ];
        $buss5 = Businesshours::updateOrCreate(['no_id' => $businessid5], $ticket5);

        $businessid6 = $request->businessid6;
        $business6 = $request->business6;
        $starttime6 = $request->starttime6;
        $endtime6 = $request->endtime6;
        $status6 = $request->status6;

        $ticket6 = [

            'no_id' => $businessid6,
            'weeks' => $business6,
            'starttime' => $starttime6,
            'endtime' => $endtime6,
            'status' => $status6,

        ];
        $buss6 = Businesshours::updateOrCreate(['no_id' => $businessid6], $ticket6);

        $businessid7 = $request->businessid7;
        $business7 = $request->business7;
        $starttime7 = $request->starttime7;
        $endtime7 = $request->endtime7;
        $status7 = $request->status7;

        $ticket7 = [

            'no_id' => $businessid7,
            'weeks' => $business7,
            'starttime' => $starttime7,
            'endtime' => $endtime7,
            'status' => $status7,

        ];
        $buss7 = Businesshours::updateOrCreate(['no_id' => $businessid7], $ticket7);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated Business Hours.';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
    }

    public function fullhours(Request $request)
    {
        $businesshours = Businesshours::get();
        $barray = ['Mon', 'Tue', 'wed', 'Thu', 'Fri', 'Sat', 'Sun'];
        $dayIndex = 0;
        if ($request->fullhours == 'off') {
            foreach ($businesshours as $businesshour) {
                $businesshour->weeks = $barray[$dayIndex];
                $dayIndex = ($dayIndex + 1) % count($barray);
                $businesshour->status = null;
                $businesshour->starttime = null;
                $businesshour->endtime = null;
                $businesshour->save();
            }
        } else {
            // $businesshours = Businesshours::get();
            // $barray = ['Mon','Tue','wed','Thu','Fri','Sat','Sun'];
            // $dayIndex = 0;
            if ($businesshours->isEmpty()) {
                $no_id_Index = 0;
                foreach ($barray as $barrays) {
                    $business = Businesshours::create([
                        'no_id' => $no_id_Index + 1,
                        'weeks' => $barrays,
                        'status' => 'Opened',
                        'starttime' => '24H',
                        'endtime' => null,
                    ]);

                    $no_id_Index = $no_id_Index + 1;
                }
            } else {
                foreach ($businesshours as $businesshour) {
                    $businesshour->weeks = $barray[$dayIndex];
                    $dayIndex = ($dayIndex + 1) % count($barray);
                    $businesshour->status = 'Opened';
                    $businesshour->starttime = '24H';
                    $businesshour->endtime = null;
                    $businesshour->save();
                }
            }
        }

        $fullpermission = Setting::where('key', '24hoursbusinessswitch')->first();
        $fullpermission->value = $request->fullhours;
        $fullpermission->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated Business Hours.';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('Updated successfully')], 200);
    }
}
