<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\FeatureBox;
use App\Models\Apptitle;
use App\Models\User;
use Auth;
use Illuminate\Support\Facades\Validator;
use Response;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Role;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;

class FeatureBoxController extends Controller
{
  public function index(Request $request)
  {

    $this->authorize('Feature Box Access');
    $feature = FeatureBox::get();
    $data['feature'] = $feature;
    $basic = Apptitle::first();
    $data['basic'] = $basic;
    $setting = response()->json(['FILE_UPLOAD_TYPES' => setting('FILE_UPLOAD_TYPES'), 'FILE_UPLOAD_MAX' => setting('FILE_UPLOAD_MAX'), 'MAX_FILE_UPLOAD' => setting('MAX_FILE_UPLOAD'),]);
    $data['setting'] = $setting;

    $featureboxes = FeatureBox::latest();

    $searchTerm = $request['filter'] ?? null;
    $perPage    = $request['per_page'] ?? 15;
    $page       = $request['page'] ?? 1;

    if ($searchTerm) {
      $featureboxes->where(function ($query) use ($searchTerm) {
        $columns = Schema::getColumnListing('feature_boxes');
        foreach ($columns as $column) {
          $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
        }
      });
    }
    $items = $featureboxes->paginate($perPage);
    foreach ($items as $comment) {
      if ($comment->image) {
        $conversionsDisk = $comment->storage_disk ?? 'public';
        $provider = existprovider($conversionsDisk)->provider;
        $imageUrl = $provider::getImageUrl('uploads/featurebox/' . $comment->image);
        // Only set the "profileimage" attribute if it's not already set
        if (!isset($comment['profileimage'])) {
          $comment['profileimage'] = $imageUrl;
        }
      }
    }
    $data['queryList'] = $items;

    $user = User::with('usetting')->findOrFail(Auth::user()->id);
    $role = Role::where('name', $user->getRoleNames()[0])->get();
    foreach ($role as $roles) {
      $data['permissions'] = $roles->getPermissionNames();
    }
    return $data;
  }

  public function show($id)
  {
    $this->authorize('Feature Box Edit');
    $post = FeatureBox::find($id);
    if ($post->image != null) {
      $provider = storage()->provider;
      $post['imageurl'] = route('getImage.url', ['imagePath' => 'uploads*featurebox*' . $post->image, 'storage_disk' => $post->storage_disk ?? 'public']);
    } else {
      $post['imageurl'] = null;
    }
    return response()->json($post);
  }

  public function store(Request $request)
  {

    $validator = Validator::make($request->all(), [
      'title' => 'required|string|max:255',
      'subtitle' => 'required|string|max:255',
    ]);


    if ($files = $request->file('image')) {
      $validator = Validator::make($request->all(), [
        'image' => 'required|mimes:jpg,jpeg,png,svg|max:10240',
      ]);
    }
    if($request->featureboxurl){
      $validator = Validator::make($request->all(), [
        'featureboxurl' => 'required|string|url',
      ]);
      if ($validator->fails()) {
          return response()->json([
              'error' => $validator->errors()->first('featureboxurl')
          ], status: 200);
      }
    }


    if ($validator->passes()) {
      $subtitle = $request->input('subtitle');

      // Trim unwanted tags from the start and end
      $subtitle = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $subtitle);

      $boxID = ['id' => $request->featurebox_id];
      $boxdetails = [
        'title' => $request->title,
        'subtitle' => $subtitle,
        'featureboxurl' => $request->featureboxurl,
        'url_checkbox' => $request->url_checkbox,
      ];

      if ($request->featureBoximgRemoved) {
        $data = FeatureBox::find($request->featureBoximgRemoved);
        $imagepath =   public_path() . "" . '/uploads/featurebox/' . $data->image;
        if (\File::exists($imagepath)) {
          \File::delete($imagepath);
        }
        $data->image = null;
        $data->save();
      }

      if ($files = $request->file('image')) {
        $files = $request->file('image');

        if ($request->featurebox_id) {
          $testiimage = FeatureBox::find($request->featurebox_id);
          $imagepath =   public_path() . "" . '/uploads/featurebox/' . $testiimage->image;
          if (\File::exists($imagepath)) {
            \File::delete($imagepath);
          }
        }

        $profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
        $provider = storage()->provider;
        $upload =  $provider::uploadImage($files, '/uploads/featurebox/', $profileImage);
        if ($upload) {
          $boxdetails['image'] = $profileImage;
          $boxdetails['storage_disk'] = storage()->storage_disk;
        }
      }

      $feature = FeatureBox::updateOrCreate(['id' => $boxID], $boxdetails);

      $geolocation = GeoIP::getLocation(request()->getClientIp());
      $agent = new Agent();
      $activity = new EmployeeActivity();
      $activity->user_id = Auth::user()->id;
      $activity->activity_type = $boxID ? 'Updated Featurebox' : 'created featurebox';
      $activity->ip_address = $geolocation->ip;
      $activity->browser = $agent->browser();
      $activity->device = $agent->device();
      $activity->save();

      return response()->json(['code' => 200, 'success' => 'Featurebox Updated successfully', 'data' => $feature], 200);
    } else {
      return Response::json(['errors' => $validator->errors()]);
    }
  }


  public function destroyImage($id)
  {
    $this->authorize('Feature Box Edit');
    $data = FeatureBox::find($id);
    // $imagepath =   public_path() . "" . '/uploads/featurebox/' . $data->image;
    // if (\File::exists($imagepath)) {
    //   \File::delete($imagepath);
    // }

    $provider  = existprovider($data->storage_disk ?? 'public')->provider;
    $provider::delete('/uploads/featurebox/' . $data->image);
    $data->image = null;
    $data->save();

    $geolocation = GeoIP::getLocation(request()->getClientIp());
    $agent = new Agent();
    $activity = new EmployeeActivity();
    $activity->user_id = Auth::user()->id;
    $activity->activity_type = 'Deleted featurebox image';
    $activity->ip_address = $geolocation->ip;
    $activity->browser = $agent->browser();
    $activity->device = $agent->device();
    $activity->save();

    return response()->json(['success' => lang('The featurebox image was successfully deleted.', 'alerts')]);
  }
  public function destroy($id)
  {
    $this->authorize('Feature Box Delete');
    $data = FeatureBox::where('id', $id)->first(['image', 'storage_disk']);
    \File::delete(public_path() . "" . '/uploads/feature-box/' . $data->image);
    $featueBox = FeatureBox::find($id);
    $featueBox->delete();

    $geolocation = GeoIP::getLocation(request()->getClientIp());
    $agent = new Agent();
    $activity = new EmployeeActivity();
    $activity->user_id = Auth::user()->id;
    $activity->activity_type = 'Deleted featurebox';
    $activity->ip_address = $geolocation->ip;
    $activity->browser = $agent->browser();
    $activity->device = $agent->device();
    $activity->save();

    return response()->json(['success' => 'The featurebox was successfully deleted.']);
  }
  public function allfeaturedelete(Request $request)
  {
    $id_array = $request->input('id');

    $sendmails = FeatureBox::whereIn('id', $id_array)->get();

    foreach ($sendmails as $sendmail) {
      \File::delete(public_path() . "" . '/uploads/feature/' . $sendmail->image);
      $sendmail->delete();
    }
    $geolocation = GeoIP::getLocation(request()->getClientIp());
    $agent = new Agent();
    $activity = new EmployeeActivity();
    $activity->user_id = Auth::user()->id;
    $activity->activity_type = 'Deleted multiple featurebox';
    $activity->ip_address = $geolocation->ip;
    $activity->browser = $agent->browser();
    $activity->device = $agent->device();
    $activity->save();

    return response()->json(['success' => 'The featurebox was successfully deleted.']);
  }

  public function feature(Request $request)
  {
    $request->validate([
      'featuretitle' => 'required|string|max:255',
    ]);

    if ($request->featuresub) {
      $request->validate([
        'featuresub' => 'string|max:255',
      ]);
    }

    $calID = ['id' => $request->id];
    $calldetails = [
      'featuretitle' => $request->featuretitle,
      'featuresub' => $request->featuresub,
      'featurecheck'  => $request->featurecheck ? 'on' : 'off',
    ];
    $callaction = Apptitle::updateOrCreate(
      ['id' => $calID],
      $calldetails
    );

    $geolocation = GeoIP::getLocation(request()->getClientIp());
    $agent = new Agent();
    $activity = new EmployeeActivity();
    $activity->user_id = Auth::user()->id;
    $activity->activity_type = $calID ? 'Updated Featurebox' : 'created featurebox';
    $activity->ip_address = $geolocation->ip;
    $activity->browser = $agent->browser();
    $activity->device = $agent->device();
    $activity->save();

    return response()->json(['success' => 'Updated Successfully']);
  }
}
