<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Pages;
use App\Models\User;
use Auth;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Role;
use Str;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;

class GeneralPageController extends Controller
{
	public function index(Request $request)
	{
		$this->authorize('Pages Access');

		$user = User::with('usetting')->findOrFail(Auth::user()->id);
		$role = Role::where('name', $user->getRoleNames()[0])->get();
		foreach ($role as $roles) {
			$data['permissions'] = $roles->getPermissionNames();
		}

		$post = Pages::latest();

		$searchTerm = $request['filter'] ?? null;
		$perPage    = $request['per_page'] ?? 15;
		$page       = $request['page'] ?? 1;

		if ($searchTerm) {
			$post->where(function ($query) use ($searchTerm) {
				$columns = Schema::getColumnListing('pages');
				foreach ($columns as $column) {
					$query->orWhere($column, 'LIKE', "%{$searchTerm}%");
				}
			});
		}
		$items = $post->paginate($perPage);
		$data['queryList'] = $items;

		return $data;
	}


	public function store(Request $request)
	{

		$testiId = $request->pages_id;
		$pagesfind = Pages::find($testiId);

        $this->validate($request, [
            'pagedescription' => ['required',  function ($attribute, $value, $fail) {
                // Remove all HTML tags and decode entities like &nbsp;
                $decodedValue = html_entity_decode(strip_tags($value));

                // Replace non-breaking spaces (\u{A0}) with regular spaces
                $normalizedValue = str_replace("\u{A0}", ' ', $decodedValue);

                // Trim unwanted tags from the start and end
                $normalizedValue = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $normalizedValue);

                // Trim spaces and check if the result is empty
                if (trim($normalizedValue) === '') {
                    $fail('The pagedescription must contain valid text, not just spaces or HTML.');
                }
            }]
        ]);

		if (!$pagesfind) {
			$request->validate([
				'pagename' => 'required|max:30|unique:pages',
				'pagedescription' => 'required',

			]);
		}
		if ($pagesfind) {
			if ($pagesfind->pagename == $request->pagename) {
				$request->validate([
					'pagename' => 'required|max:30',
					'pagedescription' => 'required',

				]);
			} else {
				$request->validate([
					'pagename' => 'required|max:30|unique:pages',
					'pagedescription' => 'required',

				]);
			}
		}


        $pagedescription = $request->input('pagedescription');

        // Trim unwanted tags from the start and end
        $pagedescription = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $pagedescription);
		if (!$pagesfind) {
			$testi =  [
				'pagename' => $request->pagename,
				'pagedescription' => $pagedescription,
				'pageslug' => Str::slug($request->pagename, '-'),
				'viewonpages' => $request->display,
				'status' => $request->status ? 1 : 0,
			];
		}
		if ($pagesfind) {

			if ($pagesfind->pageslug != null) {
				$testi =  [
					'pagename' => $request->pagename,
                    'pagedescription' => $pagedescription,
					'viewonpages' => $request->display,
					'status' => $request->status ? 1 : 0,
				];
			}
			if ($pagesfind->pageslug == null) {
				$testi =  [
					'pagename' => $request->pagename,
					'pagedescription' => $pagedescription,
					'pageslug' => Str::slug($request->pagename, '-'),
					'viewonpages' => $request->display,
					'status' => $request->status ? 1 : 0,
				];
			}
		}
		$pages = Pages::updateOrCreate(['id' => $testiId], $testi);

		$geolocation = GeoIP::getLocation(request()->getClientIp());
		$agent = new Agent();
		$activity = new EmployeeActivity();
		$activity->user_id = Auth::user()->id;
		$activity->activity_type = $testiId ? 'Updated Page' : 'created Page';
		$activity->ip_address = $geolocation->ip;
		$activity->browser = $agent->browser();
		$activity->device = $agent->device();
		$activity->save();

		$message = $testiId ? 'Page updated successfully.' : 'Page created successfully.';
		return response()->json(['code'=>200, 'success'=> $message,'data' => $pages], 200);
	}

	public function show($id)
	{
		$this->authorize('Pages Edit');
		$post = Pages::find($id);

		return response()->json($post);
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id)
	{
		$this->authorize('Category Delete');
		$pages = Pages::findOrFail($id);
		$pages->delete();

		$geolocation = GeoIP::getLocation(request()->getClientIp());
		$agent = new Agent();
		$activity = new EmployeeActivity();
		$activity->user_id = Auth::user()->id;
		$activity->activity_type = 'Deleted a general page';
		$activity->ip_address = $geolocation->ip;
		$activity->browser = $agent->browser();
		$activity->device = $agent->device();
		$activity->save();

		return response()->json(['success' => 'Deleted Successfully']);
	}
	public function destroyall(Request $request)
	{
		$this->authorize('pages Delete');

		$id_array = $request->input('id');

		$pages = pages::whereIn('id', $id_array)->get();

		foreach ($pages as $page) {
			$page->delete();
		}
		$geolocation = GeoIP::getLocation(request()->getClientIp());
		$agent = new Agent();
		$activity = new EmployeeActivity();
		$activity->user_id = Auth::user()->id;
		$activity->activity_type = 'Deleted multiple general pages';
		$activity->ip_address = $geolocation->ip;
		$activity->browser = $agent->browser();
		$activity->device = $agent->device();
		$activity->save();
		return response()->json(['success' => 'Deleted successfully',]);
	}
}
