<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Auth;
use DB;
use App\Models\User;
use App\Models\Groups;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Role;
use Torann\GeoIP\Facades\GeoIP;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;


class GroupCreateController extends Controller
{
    public function index(Request $request)
    {
        $this->authorize('Groups List Access');

        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }


        $groupquery = Groups::with('groupsuser');
        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;
        if ($searchTerm) {
            $groupquery->where(function ($query) use ($searchTerm) {
                $query->where('groupname', 'LIKE', $searchTerm . '%');
                $query->where('groupstatus', 'LIKE', $searchTerm . '%');
                $query->where('id', 'LIKE', $searchTerm . '%');
            });
        }
        $items = $groupquery->paginate($perPage);


        $data['queryList'] = $items;

        $users = User::with('roles')->where('status', 1)->get();
        $data['users'] = $users;

        return $data;
    }



    public function store(Request $request)
    {
        $this->authorize('Groups Create');
        $request->validate([
            'groupname' => 'required|string|max:255|unique:groups',
            'user_id' => 'required',
        ]);
        $grop = new Groups;

        $grop->groupname = $request->input('groupname');
        $grop->groupstatus = 1;
        $grop->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Created a group';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        if ($request->input('user_id')) {
            foreach ($request->input('user_id') as $value) {
                $user_id[] = $value;
            }
        }

        $grop->groupsusers()->sync($request->get('user_id'));

        return response()->json(['success' => 'A group was successfully created.']);
    }

    public function update(Request $request, $id)
    {
        $this->authorize('Groups Edit');
        $request->validate([
            'groupname' => 'required|string|max:255',
            'user_id' => 'required',

        ]);
        $grop = Groups::find($id);
        if ($grop->groupname == $request->groupname) {
            $grop->groupstatus = 1;
            $grop->update();
            if ($request->input('user_id')) {
                foreach ($request->input('user_id') as $value) {
                    $user_id[] = $value;
                }
            }

            $grop->groupsusers()->sync($request->get('user_id'));
        } else {
            $request->validate([
                'groupname' => 'required|string|max:255|unique:groups',
            ]);

            $grop->groupname = $request->input('groupname');
            $grop->groupstatus = 1;
            $grop->update();

            if ($request->input('user_id')) {
                foreach ($request->input('user_id') as $value) {
                    $user_id[] = $value;
                }
            }
            $grop->groupsusers()->sync($request->get('user_id'));
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated the group';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => 'The group updated successfully.']);
        // return redirect('admin/groups')->with('success', 'The group updated successfully.');
    }

    public function destroy($id)
    {
        $groupdelete = Groups::find($id);
        $groupdelete->delete();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted a group';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => 'The group deleted successfully.']);
    }


    public function destroyall(Request $request)
    {
        $id_array = $request->input('id');

        $groups = Groups::whereIn('id', $id_array)->get();

        foreach ($groups as $group) {
            $group->delete();
        }
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted multiple groups';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'The group deleted successfully.']);
    }

    public function statuschange(Request $request, $id)
    {
        $id = $request->id;
        $groupstatuschange = Groups::find($id);
        $groupstatuschange->groupstatus = $request->status;
        $groupstatuschange->update();

        return response()->json(['success' => 'The group status updated successfully.']);
    }
}
