<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Addon;
use Illuminate\Http\Request;


class StorageController extends Controller
{

    public function index()
    {
        $addondata = Addon::all();

        $user = User::with('usetting')->findOrFail(Auth::user()->id);

        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }

        // Transform the array into a collection
        $addonsCollection = collect($addondata);

        // Categorize addons based on type
        $addonData = $addonsCollection->groupBy('type');

        // Extract specific categories
        $storageAddons = $addonData->get('Storage', collect());
        $paymentAddons = $addonData->get('Payment', collect());
        $generalAddons = $addonData->get('General', collect());

        // Pass the data to the view
        // $data = compact('storageAddons', 'paymentAddons', 'generalAddons');
        $ch = curl_init('https://panel.spruko.com/api/api/availableAddons');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);

        // Parse the response as JSON
        $addons = json_decode($response, true);

        $data['addons'] = $this->prepareAddonData($storageAddons, $paymentAddons, $generalAddons, $addons);

        // Close cURL handle
        curl_close($ch);

        return $data;
    }
}
