<?php

namespace App\Http\Controllers;

use App\Models\Apptitle;
use Illuminate\Support\Facades\File;

class AngularController extends Controller
{
    /**
     * @var string
     */
    public $BaseHref;

    public function langJson($all)
    {
        // Check if it's a request for a JSON file in the i18n directory
        $jsonFilePath = public_path("client\\assets\\i18n\\$all");

        if (File::exists($jsonFilePath) && File::extension($jsonFilePath) === 'json') {
            // Return the JSON content
            $jsonContent = File::get($jsonFilePath);
            return response()->json(json_decode($jsonContent, true));
        }
        // If it's not a JSON file, continue with your Angular logic
        return response()->json('');
    }
    public function index()
    {

        $BaseVal = '/';
        $mainUrl = config('app.url') . '/';

        //get uri for html "base" tag
        if (substr_count(config('app.url'), '/') > 2) {
            $BaseVal = parse_url(config('app.url'))['path'] . '/';
        }

        $apptitle = Apptitle::first();
        if ($apptitle) {
            $favicon = $apptitle->image4;
            $title = $apptitle->title;
        } else {
            $title = '';
            $favicon = '';
        }
        $data['mainUrl'] = $mainUrl;
        $data['BaseVal'] = $BaseVal;
        $data['title'] = $title;
        $data['favicon'] = $favicon;
        return view('app')->with($data);
    }
}
