<?php

namespace App\Http\Controllers;

use helpers;
use App\Models\Currency;
use App\Models\Customer;
use Jenssegers\Agent\Agent;
use Illuminate\Http\Request;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Role;
use App\Models\User;
use Auth;

class CurrencyController extends Controller
{
    public function index(Request $request)
    {
        $this->authorize(ability: 'Currencies Access');

        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }

        $currencies = Currency::query();
        
        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;
        if ($searchTerm) {
            $currencies->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('currencies');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
            });
        }
        $items = $currencies->paginate($perPage);
        $data['queryList'] = $items;

        $data['currencies'] = config(('currencies'));
        
        $data['setting'] = response()->json(['date_format' => setting('date_format')]);

        return $data;
    }
   
    public function edit($id)
    {
        try {
            $this->authorize('Currencies Edit');
        $support = Currency::find($id);
        return response()->json(['data' => $support]);
        } catch (\Throwable $th) {

            return response()->json(['exception' => $th->getMessage()]);
        }
    }

    public function delete($id)
    {
        try {
            $this->authorize('Currencies Delete');

        $support = Currency::findOrFail($id);
        $support->delete();
        $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Deleted a currency';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();

        return response()->json(['success' => 'The currency was successfully deleted.']);
        } catch (\Throwable $th) {
            return response()->json(['exception' => $th->getMessage()]);
        }
    }

    public function status(Request $request, $id)
    {
        
        try {
            $this->authorize('Currencies Edit');
        $supID = Currency::find($id);
        $supID->status = $request->status;
        $supID->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Changed currencies status';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();
        return response()->json(['code' => 200, 'success' => 'Updated successfully'], 200);
        } catch (\Throwable $th) {
            return response()->json(['exception' => $th->getMessage()]);
        }
    }

    public function currencyMassdestroy(Request $request)
    {
        try {
            $this->authorize('Currencies Delete');
        $currency_id_array = $request->input('id');

        $currencies = Currency::whereIn('id', $currency_id_array)->get();

        foreach ($currencies as $currency) {

            $currency->delete();
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Deleted multiple currencies';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();
        return response()->json(['success' => 'The currency was successfully deleted.']);
        } catch (\Throwable $th) {
            return response()->json(['exception' => $th->getMessage()]);
        }
    }

    public function changeCurrency(Request $request)
    {
        $currency = Currency::find($request->currencyId);
        if (Auth::guard('customer')->user()) {
            $customer = Customer::find(Auth::guard('customer')->user()->id);
            $customer->currency = $currency->code;
            $customer->save();
        } else {
            session()->put('currency', $currency->code);
        }

        return response()->json(['success' => 'The currency was changed .']);
    }

}
