<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;

use App\Models\Ticket\Category;
use App\Models\Articles\Article;

use App\Models\User;
use App\Models\ArticleComment;
use App\Models\Articles\article_likes;
use App\Models\Testimonial;
use App\Models\callaction;
use App\Models\FeatureBox;
use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\Seosetting;
use App\Models\Pages;
use App\Models\Announcement;
use App\Models\Customer;
use App\Models\SocialAuthSetting;
use Illuminate\Support\Facades\Session;
use App\Models\FaqCategory;
use App\Models\Setting;
use App\Models\Customfield;
use App\Models\Holiday;
use App\Models\Languages;
use App\Models\Translate;
use Illuminate\Support\Str;
use Carbon\Carbon;
use App\Models\Currency;

class HomeController extends Controller
{
    public function authcheckdetails()
    {
        if(Auth::check()){
            return response()->json(1);
        }else{
            return response()->json(0);
        }

    }

    public function guestLayout()
    {

        $data['CUSTOMCHAT'] = customcssjs('CUSTOMCHAT');
        $data['CUSTOMCHATUSER'] = customcssjs('CUSTOMCHATUSER');
        $data['CUSTOMCHATENABLE'] = customcssjs('CUSTOMCHATENABLE');

        $data['setting'] = response(['theme_color' => setting('theme_color'), 'theme_color_dark' => setting('theme_color_dark')]);

        return $data;
    }
    public function index()
    {
        if (setting('defaultlogin_on') == 'on') {
            return response()->json(['redirect' => 'login']);
        }
        $articlecomments = ArticleComment::latest('created_at')->get();
        $data['articlecomments'] = $articlecomments;

        $categorys = Category::where('status', '1')->with('articles')->whereIn('display', ['knowledge', 'all'])->latest()->get();
        $data['categorys'] = $categorys;

        $faqcategory = FaqCategory::where('status', '1')->latest()->get();
        $data['faqcategorys'] = $faqcategory;

        $article = Article::where('status', 'published')->with('subcategorys')->latest('created_at')->take(5)->get();
        $data['article'] = $article;

        $populararticle = Article::where('status', 'published')->with('subcategorys')->latest('created_at')->take(5)->get();
        $data['populararticle'] = $populararticle;

        $testimonial = Testimonial::get();
        $data['testimonial'] = $testimonial;

        $call = callaction::first();
        $data['call'] = $call;

        $title = Apptitle::first();
        $data['title'] = $title;
        $feature = FeatureBox::get();
        $data['feature'] = $feature;
        $now = now();
        $announcement = announcement::whereDate('enddate', '>=', $now->toDateString())->whereDate('startdate', '<=', $now->toDateString())->get();
        $data['announcement'] = $announcement;

        $announcements = Announcement::whereNotNull('announcementday')->get();
        $data['announcements'] = $announcements;

        $currentYear = $now->year;
        $activeHolidays = Holiday::where('status', 1)->get();

        // Filter holidays
        $data['holidays'] = $activeHolidays->filter(function ($holiday) use ($now, $currentYear) {
            $holidayStart = Carbon::parse($holiday->startdate);
            $holidayEnd = Carbon::parse($holiday->enddate);

            // Check for fixed holidays (compare only day and month)
            if ($holiday->is_fixed) {
                return $holidayStart->month === $now->month && $holidayStart->day === $now->day;
            }

            // For non-fixed holidays, check the full date
            return $holidayStart->isSameDay($now);
        });

        $data['setting'] = [
            'ANNOUNCEMENT_USER' => setting('ANNOUNCEMENT_USER'),
        ];
        
        if (auth()->guard('customer')->user()) {
            $unreadNotifications = auth()->guard('customer')->user()->unreadNotifications()->get();
            $unreadNotifications->transform(function ($groups) {
                if (isset($groups->data['ticket_id'])) {
                    $groups->enc_ticket_id = encrypt($groups->data['ticket_id']);
                }
                return $groups;
            });
            $data['unreadNotifications'] = $unreadNotifications;

            $data['user'] = auth()->guard('customer')->user();
        }

        $socialAuthSettings = SocialAuthSetting::first();
        $data['socialAuthSettings'] = $socialAuthSettings;
        return $data;
    }

    public function header()
    {
        if (auth()->guard('customer')->user()) {
            $unreadNotifications = auth()->guard('customer')->user()->unreadNotifications()->get();
            $unreadNotifications->transform(function ($groups) {
                if (isset($groups->data['ticket_id'])) {
                    $groups->enc_ticket_id = encrypt($groups->data['ticket_id']);
                }
                return $groups;
            });
            $data['unreadNotifications'] = $unreadNotifications;
        }
        $page = Pages::all();
        $data['page'] = $page;

        $socialAuthSettings = SocialAuthSetting::first();
        $data['socialAuthSettings'] = $socialAuthSettings;
        $customfields = Customfield::whereIn('displaytypes', ['both', 'registerform'])->whereIn('status', [1])->get();
        $data['customfields'] = $customfields;
        $setting =  response()->json([
            'defaultlogin_on' => setting('defaultlogin_on'),
            'KNOWLEDGE_ENABLE' => setting('KNOWLEDGE_ENABLE'),
            'FAQ_ENABLE' => setting('FAQ_ENABLE'),
            'CONTACT_ENABLE' => setting('CONTACT_ENABLE'),
            'REGISTER_POPUP' => setting('REGISTER_POPUP'),
            'REGISTER_DISABLE' => setting('REGISTER_DISABLE'),
            'GUEST_TICKET' => setting('GUEST_TICKET'),
            'login_disable' => setting('login_disable'),
            'login_disable_statement' => setting('login_disable_statement'),
            'terms_url' => setting('terms_url'),
            'CAPTCHATYPE' => setting('CAPTCHATYPE'),
            'RECAPTCH_ENABLE_REGISTER' => setting('RECAPTCH_ENABLE_REGISTER'),
            'RECAPTCH_ENABLE_LOGIN' => setting('RECAPTCH_ENABLE_LOGIN'),
            'GOOGLE_RECAPTCHA_KEY' => setting('GOOGLE_RECAPTCHA_KEY'),
        ]);
        $data['setting'] = $setting;

        return $data;
    }

    public function knowledge($id)
    {
        if (setting('KNOWLEDGE_ENABLE') != "yes") abort(403);
        if ((Auth::guard('customer')->user())) {
            $data['username'] = Auth::guard('customer')->user()->username;
        }
        $data['languages'] = languages();
        $articleslug = Article::where('articleslug', $id)->with('subcategorys')->first();
        if ($articleslug != null) {

            $article = Article::with('subcategorys', 'category')->where('articleslug', $id)->first();
            $data['articles'] = $article;
            if ($article) {
                $imageArray = [];
                foreach ($article->getMedia('article') as $articleImage) {
                    $dataImage = [
                        'imageName' => $articleImage->file_name,
                        'imageUrl' => $articleImage->getFullUrl()
                    ];
                    array_push($imageArray, $dataImage);
                }
                $data['imageArray'] = $imageArray;

                $like_post = Article::where('articleslug', $id)->firstOrFail();
                $like = article_likes::where('rating', '1')->where(['article_id' => $like_post->id])->paginate();
                $data['like'] = $like;

                $dislike = article_likes::where('rating', '-1')->where(['article_id' => $like_post->id])->paginate();
                $data['dislike'] = $dislike;
            }

            if (Auth::guard('customer')->check()) {
                $viewrating = article_likes::where('user_id', Auth::guard('customer')->user()->id)->where(['article_id' => $like_post->id])->first();
                $data['viewrating'] = $viewrating;
            }
        }
        $article = Article::with('subcategorys', 'category')->where('id', $id)->first();
        if ($articleslug == null && $article) {
            $data['articles'] = $article;

            $like_post = Article::find($id);
            $like = article_likes::where('rating', '1')->where(['article_id' => $like_post->id])->paginate();
            $data['like'] = $like;

            $dislike = article_likes::where('rating', '-1')->where(['article_id' => $like_post->id])->paginate();
            $data['dislike'] = $dislike;

            if (Auth::guard('customer')->check()) {
                $viewrating = article_likes::where('user_id', Auth::guard('customer')->user()->id)->where(['article_id' => $like_post->id])->first();
                $data['viewrating'] = $viewrating;
            }
        }
        $recentarticles = Article::with('subcategorys')->latest()->take(6)->get();
        $data['recentarticles'] = $recentarticles;

        $populararticle = Article::with('subcategorys')->orderBy('views', 'desc')->latest()->take(6)->get();
        $data['populararticles'] = $populararticle;
        if($articleslug == null && $article == null){
            $privatemode['privatemode'] = false;
            $privatemode['setting'] = response()->json(['article_count' => setting('article_count'), 'cust_google_translate' => setting('cust_google_translate')]);
            $privatemode['articletitle'] = 'No Data';
            $privatemode['recentarticles'] = $recentarticles;
            $privatemode['populararticles'] = $populararticle;
            return response(['error' => 'No article Found', 'data' => $privatemode]);
        }

        if ($data && $data['articles']->featureimage == 'frontend.jpg') {
            $data['articles']->frontend = asset('uploads/featureimage/demo/frontend.jpg');
        }

        $data['setting'] = response()->json(['article_count' => setting('article_count'), 'cust_google_translate' => setting('cust_google_translate')]);
        if ($article && $article->privatemode == '1' && !Auth::guard('customer')->user()) {
            $privatemode['privatemode'] = true;
            $privatemode['setting'] = response()->json(['article_count' => setting('article_count'), 'cust_google_translate' => setting('cust_google_translate')]);
            $privatemode['articletitle'] = $article->title;
            $privatemode['recentarticles'] = $recentarticles;
            $privatemode['populararticles'] = $populararticle;
            return response(['error' => 'Login to access the article', 'data' => $privatemode]);
        } else if($article) {
            $articleKey = 'articles_' . $article->id;
            if (!Session::has($articleKey)) {
                $article->increment('views');
                Session::put($articleKey, 1);
            }
            return $data;
        }
        if ($articleslug && $articleslug->privatemode == '1' && !Auth::guard('customer')->user()) {
            $privatemode['privatemode'] = true;
            $privatemode['setting'] = response()->json(['article_count' => setting('article_count'), 'cust_google_translate' => setting('cust_google_translate')]);
            $privatemode['articletitle'] = $articleslug->title;
            $privatemode['recentarticles'] = $recentarticles;
            $privatemode['populararticles'] = $populararticle;
            return response(['error' => 'Login to access the articleslug', 'data' => $privatemode]);
        } else if($articleslug) {
            $articleKey = 'articles_' . $articleslug->id;
            if (!Session::has($articleKey)) {
                $articleslug->increment('views');
                Session::put($articleKey, 1);
            }
            return $data;
        }
    }

    public function searchlist(Request $request)
    {

        $article = Article::latest('created_at')->paginate(5);
        $data['articles'] = $article;


        if ($request->get('data')) {
            $keyword = $request->get('data');
            $data = Article::select("title", "message", "tags", 'id', 'category_id', 'articleslug', 'status',)->with('category')
                ->where('status', 'Published')
                ->where(function ($queries) {
                    $keyword = request()->get('data');
                    $queries->where('title', 'LIKE', "%{$keyword}%")
                        ->orWhere('tags', 'LIKE', '%' . $keyword . '%')
                        ->orWhere('message', 'LIKE', '%' . $keyword . '%')->orderby('title', 'asc');
                })
                ->get();
            $output = [];
            if ($data->isNotEmpty()) {

                foreach ($data as $row) {
                    array_push($output, $row);
                }
            }
            return response()->json($output);
        }
    }

    public function likedislike(Request $request)
    {
        $userArticleList = article_likes::where(['user_id' => Auth::guard('customer')->user()->id, 'article_id' => $request->dataname])->latest()->get();
        if ($userArticleList->count() > 1) {
            foreach ($userArticleList as $key => $d) {
                if ($key != 0) {
                    $d->delete();
                }
            }
        }
        switch ($request->datavalue) {
            case 'like':
                $user_id = Auth::guard('customer')->user()->id;

                $likedislike = article_likes::where(['user_id' => $user_id, 'article_id' => $request->dataname])->first();
                if ($likedislike) {

                    $likedislike->delete();
                    $likes = new article_likes();
                    $likes->user_id = $user_id;
                    $likes->article_id = $request->dataname;
                    $likes->rating = '1';
                    $likes->save();

                    return response()->json(['data' => 'success']);
                }
                if (!$likedislike) {
                    $likes = new article_likes();
                    $likes->user_id = $user_id;
                    $likes->article_id = $request->dataname;
                    $likes->rating = '1';
                    $likes->save();
                    return response()->json(['data' => 'success']);
                };
                break;
            case 'dislike':
                $user_id = Auth::guard('customer')->user()->id;
                $likedislike = article_likes::where(['user_id' => $user_id, 'article_id' => $request->dataname])->first();
                if ($likedislike) {
                    $likedislike->delete();
                    $likes = new article_likes();
                    $likes->user_id = $user_id;
                    $likes->article_id = $request->dataname;
                    $likes->rating = '-1';
                    $likes->save();
                    return response()->json(['data' => 'success']);
                }
                if (!$likedislike) {
                    $likes = new article_likes();
                    $likes->user_id = $user_id;
                    $likes->article_id = $request->dataname;
                    $likes->rating = '-1';
                    $likes->save();
                    return response()->json(['data' => 'success']);
                }
                break;
            default:
                # code...
                break;
        }
    }

    public function like($id)
    {
        $user_id = Auth::user()->id;
        $like_user = article_likes::where(
            [
                'user_id' => $user_id,
                'article_id' => $id
            ]
        )->first();

        if (empty($like_user->user_id)) {
            $user_id = Auth::user()->id;
            $article_id = $id;
            $rating = 1;

            $likes = new article_likes();
            $likes->user_id = $user_id;
            $likes->article_id = $article_id;
            $likes->rating = $rating;
            $likes->save();
            return response()->json(['success' => 'liked']);
        } else {
            return response()->json(['success' => 'liked']);
        }
    }

    public function dislike($id)
    {

        $user_id = Auth::user()->id;
        $like_user = article_likes::where(
            [
                'user_id' => $user_id,
                'article_id' => $id
            ]
        )->first();

        if (empty($like_user->user_id)) {
            $user_id = Auth::user()->id;
            $article_id = $id;
            $rating = -1;

            $likes = new article_likes();
            $likes->user_id = $user_id;
            $likes->article_id = $article_id;
            $likes->rating = $rating;
            $likes->save();

            return response()->json(['success' => 'dis-liked']);
        } else {
            return response()->json(['success' => 'dis-liked']);
        }
    }

    public function faqpage()
    {
        if (setting('FAQ_ENABLE') != 'yes') abort(403);
        if ((Auth::guard('customer')->user())) {
            $faqcats = FaqCategory::where('status', '1')->with('faqdetails', function ($q) {
                $q->where('status', '1');
            })->get();
        } else {
            $faqcats = FaqCategory::where('status', '1')->with('faqdetails', function ($q) {
                $q->where('status', '1');
            })->get();
            $faqcats->each(function ($faqcat) {
                $faqcat->faqdetails->map(function ($faqdetail) {
                    if ($faqdetail->privatemode == 1) {
                        $faqdetail->answer = 'You must be logged in and have valid account to access this content.';
                    }
                    return $faqdetail;
                });
            });
        }
        
        $data['languages'] = languages();
        $data['setting'] = [
            "cust_google_translate" => setting("cust_google_translate")
        ];
        $data['customer'] = Auth::guard('customer')->user() ? true : false;
        $data['faqcats'] = $faqcats;
        return $data;
    }


    public function frontshow($pageslug)
    {

        $page = Pages::where('pageslug', $pageslug)->where('status', 1)->first();
        return $page;
    }

    public function captchareload()
    {
        return response()->json(['captcha' => captcha_img()]);
    }

    public function faqcategorypage($id)
    {
        if ((Auth::guard('customer')->user())) {
            $faqcategory = FaqCategory::where('status', '1')->with('faqdetails', function ($q) {
                $q->where('status', '1');
            })->findOrFail($id);
        } else {
            $faqcategory = FaqCategory::where('status', '1')->with('faqdetails', function ($q) { 
                $q->where('status', '1')
                ->where(function ($query) {
                    $query->where('privatemode', '!=', '1')
                          ->orWhereNull('privatemode'); // Include null or undefined
                });
            })->findOrFail($id);
        }
        $data['faqcategory'] = $faqcategory;
        $data['languages'] = languages();
        $data['setting'] = [
            "cust_google_translate" => setting("cust_google_translate")
        ];
        return $data;
    }

    public function setLanguage($locale)
    {

        \App::setlocale($locale);
        session()->put('locale', $locale);
        return response()->json(['success' => 'The language has been successfully updated']);
    }

    public function suggestarticle(Request $request)
    {

        $article = Article::latest('created_at')->paginate(5);
        $data['articles'] = $article;


        if ($request->get('data')) {
            // $keyword = $request->title;
            $keyword = $request->get('data');
            $data = Article::where('title', 'LIKE', "%{$keyword}%")
                ->orWhere('tags', 'LIKE', '%' . $keyword . '%')
                ->orWhere('message', 'LIKE', '%' . $keyword . '%')->orderby('title', 'asc')->paginate(10);

            // $data = preg_replace("/($keyword )/i", "<b></b>", $data);
            $output = '<div class="card sprukocard wow shake" data-wow-duration="1500ms">
                        <div class="card-header border-0">
                            <h4 class="card-title">Suggested Articles</h4>
                        </div>
                        <div class= "card-body">
                            <div class="list-catergory">
                            <ul class="item-list item-list-scroll mb-0 custom-ul">
                    ';
            if ($data->isNotEmpty()) {

                foreach ($data as $row) {
                    $output .= '<li class="item mb-4 position-relative">';

                    if ($row->articleslug != null) {
                        $output .= '<a href="' . url('/article/' . $row->articleslug) . '" class=" admintickets"></a>';
                    }
                    if ($row->articleslug == null) {
                        $output .= ' <a href="' . url('/article/' . $row->id) . '" class=" admintickets"></a>';
                    }

                    $output .= '
                            <div class="d-flex">
                                <div class="me-7">
                                    <i class="typcn typcn-document-text item-list-icon"></i>
                                </div>
                                <div class="">
                                    <span class="">' . Str::limit($row->title, '40') . '</span>
                                </div>
                                <div class="ms-auto">
                                        <span class="badge badge-light badge-md fs-10">
                                            <i class="fa fa-eye me-1"></i>' . $row->views . '</span>
                                </div>
                            </div>
                        </li>';
                }
            } else {
                $output .= '<li class="item mb-4 position-relative">
                        <div class="d-flex">
                            <div class="me-7">
                                <i class="typcn typcn-document-text item-list-icon"></i>
                            </div>
                            <div class="">
                                <span class="">No Suggested Articles</span>
                            </div>
                        </div>
                    </li>';
            }
        }
        $output .= '</ul>
                    </div>
                </div>
            </div>';

        return response()->json($output);
    }

    public function getannouncments()
    {

        $now = now();
        $announcement = announcement::whereDate('enddate', '>=', $now->toDateString())->whereDate('startdate', '<=', $now->toDateString())->get();
        $data['announcement'] = $announcement;

        $announcements = Announcement::whereNotNull('announcementday')->get();
        $data['announcements'] = $announcements;

        $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', '1')->get();
        $data['holidays'] =  $holidays;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $data['CUSTOMCHAT'] = customcssjs('CUSTOMCHAT');
        $data['CUSTOMCHATUSER'] = customcssjs('CUSTOMCHATUSER');
        $data['CUSTOMCHATENABLE'] = customcssjs('CUSTOMCHATENABLE');
        
        if (auth()->guard('customer')->user()) {
            $unreadNotifications = auth()->guard('customer')->user()->unreadNotifications()->get();
            // $unreadNotifications->transform(function ($groups) {
            //     if (isset($groups->data['ticket_id'])) {
            //         $groups->enc_ticket_id = encrypt($groups->data['ticket_id']);
            //     }
            //     return $groups;
            // });
            $data['unreadNotifications'] = $unreadNotifications;

            $data['user'] = auth()->guard('customer')->user();
        }

        $page = Pages::all();
        $data['page'] = $page;

        $socialAuthSettings = SocialAuthSetting::first();
        $data['socialAuthSettings'] = $socialAuthSettings;
        $customfields = Customfield::whereIn('displaytypes', ['both', 'registerform'])->whereIn('status', [1])->get();
        $data['customfields'] = $customfields;
        $setting =  response()->json([
            'ANNOUNCEMENT_USER' => setting('ANNOUNCEMENT_USER'),
            'defaultlogin_on' => setting('defaultlogin_on'),
            'KNOWLEDGE_ENABLE' => setting('KNOWLEDGE_ENABLE'),
            'FAQ_ENABLE' => setting('FAQ_ENABLE'),
            'CONTACT_ENABLE' => setting('CONTACT_ENABLE'),
            'REGISTER_POPUP' => setting('REGISTER_POPUP'),
            'REGISTER_DISABLE' => setting('REGISTER_DISABLE'),
            'GUEST_TICKET' => setting('GUEST_TICKET'),
            'login_disable' => setting('login_disable'),
            'only_social_logins' => setting('only_social_logins'),
            'login_disable_statement' => setting('login_disable_statement'),
            'terms_url' => setting('terms_url'),
            'CAPTCHATYPE' => setting('CAPTCHATYPE'),
            'RECAPTCH_ENABLE_REGISTER' => setting('RECAPTCH_ENABLE_REGISTER'),
            'RECAPTCH_ENABLE_LOGIN' => setting('RECAPTCH_ENABLE_LOGIN'),
            'GOOGLE_RECAPTCHA_KEY' => setting('GOOGLE_RECAPTCHA_KEY'),
            'theme_color' => setting('theme_color'), 'theme_color_dark' => setting('theme_color_dark')
        ]);
        $data['setting'] = $setting;

        $data['CUSTOMCHAT'] = customcssjs('CUSTOMCHAT');
        $data['CUSTOMCHATUSER'] = customcssjs('CUSTOMCHATUSER');
        $data['CUSTOMCHATENABLE'] = customcssjs('CUSTOMCHATENABLE');

        $data['currencies'] = Currency::where('status', 1)->get();
        if (Auth::guard('customer')->user()) {
            $data['selectedcurrencies'] = Currency::where('code', Auth::guard('customer')->user()->currency)
                ->where('status', 1)
                ->first();
        } else {
            $data['selectedcurrencies'] = Currency::where('code', session()->get('currency'))
                ->where('status', 1)
                ->first();
        }

        return $data;
    }
    public function allsettings()
    {
        return Setting::all();
    }
    public function error404()
    {
        $data['setting'] = response()->json(['404title' => settingpages('404title'), '404subtitle' => settingpages('404subtitle')]);
        return $data;
    }
    public function missingtranslates(Request $request)
    {
        $languages = Languages::all();
        $translationsToInsert = [];

        foreach ($request->data as $key) {
            foreach ($languages as $language) {
                $localTranslate = Translate::where('key', $key)
                    ->where('lang_code', $language['languagecode'])
                    ->first();

                if (!$localTranslate) {
                    $translation = [
                        'lang_code' => $language['languagecode'],
                        'group_langname' => 'general',
                        'key' => $key,
                        'value' => ($language['languagecode'] == 'en') ? $key : null,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ];

                    $translationsToInsert[] = $translation;
                }
            }
        }

        if (!empty($translationsToInsert)) {
            // Bulk insert all translations
            Translate::insert($translationsToInsert);
        }

        return response(['translations' => 'success']);
    }
    public function csrftoken()
    {
        $data['csrftoken'] = csrf_token();
        return $data;
    }
    public function getTranslation(Request $request, $lang)
    {
        // Logic to fetch and return the translation file
        $filename = $lang . '.json';
        $path = public_path('client/assets/i18n/' . $filename);

        if (file_exists($path)) {
            $contents = file_get_contents($path);
            return response($contents)->header('Content-Type', 'application/json');
        } else {
            // Handle case where the file does not exist
            return response()->json(['error' => 'Translation file not found'], 404);
        }
    }
    public function basic()
    {
        if (setting('defaultlogin_on') == 'on') {
            $data['redirect'] = 'login';
        }
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $post = Pages::all();
        $data['page'] = $post;

        $setting = response()->json([
            'DARK_MODE' => setting('DARK_MODE'), 'MAINTENANCE_MODE' => setting('MAINTENANCE_MODE'), 'date_format' => setting('date_format'), 'FAQ_ENABLE' => setting('FAQ_ENABLE'), 'CONTACT_ENABLE' => setting('CONTACT_ENABLE'), 'time_format' => setting('time_format'), 'start_week' => setting('start_week'), 'default_timezone' => setting('default_timezone'), 'theme_color' => setting('theme_color'), 'theme_color_dark' => setting('theme_color_dark'), 'default_lang' => setting('default_lang'),
            'GOOGLEFONT_DISABLE' => setting('GOOGLEFONT_DISABLE'), 'GOOGLE_ANALYTICS_ENABLE' => setting('GOOGLE_ANALYTICS_ENABLE'), 'GOOGLE_ANALYTICS' => setting('GOOGLE_ANALYTICS'),
            'selectDisabled' => setting('selectDisabled'), 'inspectDisable' => setting('inspectDisable'),
        ]);
        $data['setting'] = $setting;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $data['CUSTOMJS'] = customcssjs('CUSTOMJS');
        $data['CUSTOMCSS'] = customcssjs('CUSTOMCSS');

        $data['CUSTOMCHATENABLE'] = customcssjs('CUSTOMCHATENABLE');
        $data['CUSTOMCHATUSER'] = customcssjs('CUSTOMCHATUSER');
        $data['CUSTOMCHAT'] = customcssjs('CUSTOMCHAT');
        $data['SPRUKOADMIN_P'] = setting('SPRUKOADMIN_P');
        $data['SPRUKOADMIN_C'] = setting('SPRUKOADMIN_C');
        $data['defaultlogin_on'] = setting('defaultlogin_on');
        
        $data['domainname'] = url('/');
        $data['serverssldomainname'] = setting('serverssldomainname');
        
        if (Auth::check() && Auth::user()) {
            $user = User::findOrFail(Auth::user()->id);
            $data['users'] = $user;
        }

        if (Auth::guard('customer')->check() && Auth::guard('customer')->user()) {
            $customer = Customer::with('custsetting')->findOrFail(Auth::guard('customer')->user()->id);
            $data['customer'] = $customer;
        }
        
        $data['liveChatCustomers'] = liveChatCustomers();
        return $data;
    }
}
