<?php

namespace App\Http\Controllers;

use App\Models\Ticket\Comment;
use App\Models\Ticket\Ticket;
use Auth;
use File;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Http;

class ImageController extends Controller
{


    public function index($id, $image)
    {
        if (Auth::check() && Auth::user() || Auth::guard('customer')->check() && Auth::guard('customer')->user() || session()->has('guestimageaccess')) {
            $media = Media::where('id', $id)->first()->disk;
            $provider =  existprovider($media)->provider;
            $imagepath = $provider::getImage('media/' . $id . '/' . $image); 
            if($media == 'public'){
                return $imagepath;
            }else{
                return redirect($imagepath);
            }
        } else {
            return response()->json(['error404']);
        }
    }

    public function imagedownload($id, $image)
    {
        if (Auth::check() && Auth::user() || Auth::guard('customer')->check() && Auth::guard('customer')->user() || session()->has('guestimageaccess')) {
            $media = Media::where('id', $id)->first()->disk;
            $provider =  existprovider($media)->provider;
            $imagepath = $provider::getImage('media/' . $id . '/' . $image);
            $filename = pathinfo($imagepath, PATHINFO_FILENAME);

            if ($imagepath) {

                $headers = [
                    'Content-Type' => '*',
                    'Content-Disposition' => 'inline; filename="' . $filename . '.jpg"',
                ];
                // Return the image content as a response with appropriate headers

                return Response::make($imagepath, 200, [
                    'Content-Type' => 'image/*',
                ]);
            } else {
                return response()->json(['error404']);
            }
        } else {
            abort(404);
        }
    }
    public function emailtoticketshow($id, $image)
    {
        if (Auth::check() && Auth::user() || Auth::guard('customer')->check() && Auth::guard('customer')->user()) {
            $ticket = Ticket::find($id);
            $provider =  existprovider($ticket->storage_disk)->provider;
            $imagepath = $provider::getImage('uploads/emailtoticket/' . $image);
            if($ticket->storage_disk == 'public'){
                return $imagepath;
            }else{
                return redirect($imagepath);
            }
        } else {
            abort(404);
        }
    }
    
    public function emailtoticketdownload($id, $image)
    {
        if (Auth::check() && Auth::user() || Auth::guard('customer')->check() && Auth::guard('customer')->user()) {
            $ticket = Ticket::find($id);
            $provider =  existprovider($ticket->storage_disk)->provider;
            $imagepath = $provider::getImage('uploads/emailtoticket/' . $image);
            if($ticket->storage_disk == 'public'){
                return $imagepath;
            }else{
                return redirect($imagepath);
            }
        } else {
            return response()->json(['error404']);
        }
    }
    public function emtcimageurlshow($id, $image)
    {
        if (Auth::check() && Auth::user() || Auth::guard('customer')->check() && Auth::guard('customer')->user()) {
            $comment = Comment::find($id);
            $provider =  existprovider($comment->storage_disk)->provider;
            $imagepath = $provider::getImage('uploads/emailtoticketcomment/' . $image);

            // Fetch the image content using HTTP
            $imageContent = Http::get($imagepath)->body();

            // Check if the image content was successfully fetched
            if ($imageContent) {
                // Return the image content as a response with appropriate headers
                return Response::make($imageContent, 200, [
                    'Content-Type' => 'image/jpeg',
                ]);
            } else {
                return response()->json(['error404']);
            }
        } else {
            abort(404);
        }
    }
    // public function emtcimageurlshow($id, $image)
    // {
    //     if (Auth::check() && Auth::user() || Auth::guard('customer')->check() && Auth::guard('customer')->user()) {
    //         $comment = Comment::find($id);
    //         if(existprovider($comment->storage_disk) == null){
    //             $comment = Ticket::find($id);
    //             $provider =  existprovider($comment->storage_disk)->provider; 
    //             $imagepath = $provider::getImage('uploads/emailtoticket/' . $image);
    //         }else{
    //             $provider =  existprovider($comment->storage_disk)->provider; 
    //             $imagepath = $provider::getImage('uploads/emailtoticketcomment/' . $image);
    //         }

    //         // Fetch the image content using HTTP
    //         $imageContent = Http::get($imagepath)->body();

    //         // Check if the image content was successfully fetched
    //         if ($imageContent) {
    //             return $imagepath;
    //         } else {
    //             return response()->json(['error404']);
    //         }
    //     } else {
    //         abort(404);
    //     }
    // }

    public function emtcimagedownload($id, $image)
    {
        if (Auth::check() && Auth::user() || Auth::guard('customer')->check() && Auth::guard('customer')->user()) {

            $comment = Comment::find($id);
            $provider =  existprovider($comment->storage_disk)->provider;
            $imagepath = $provider::getImageDownload('uploads/emailtoticketcomment/' . $image);
            if($comment->storage_disk == 'public'){
                return $imagepath;
            }else{
                return redirect($imagepath);
            }
        } else {
            abort(404);
        }
    }


    public function guestimage($id, $image)
    {
        $profile_path = public_path('media/' . $id . '/' . $image);
        if (File::exists($profile_path)) {
            if (session()->has('guestimageaccess')) {

                return response()->file($profile_path);
            } else {
                abort(404);
            }
        } else {
            abort(404);
        }
    }

    public function getProfileUrl(Request $request, $storage_disk, $imagePath)
    {
        if (Auth::check() && Auth::user() || Auth::guard('customer')->check() && Auth::guard('customer')->user() || session()->get('guestdetailssession') == $request->ticket_id) {
            $provider  = existprovider($storage_disk)->provider;
            $image = $provider::getprofile($imagePath);
            if ($image)
                return $image;
            else
                abort(404);
        } else {
            abort(404);
        }
    }

    public function getImage($storage_disk, $imagePath)
    {
        $path = str_replace('*', '/', ($imagePath));

        $provider  = existprovider($storage_disk)->provider;
        $image = $provider::getImageUrl($path);
        if ($image)
            return $image;
        else
            abort(404);
    }
}
