<?php

namespace App\Http\Controllers\User\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Hash, Auth;

class ChangepasswordController extends Controller
{


    public function changepassword(Request $request)
    {

        if ($request->has('current_password')){
            $request->validate([

                'current_password' => 'required',
                'password' => 'required|string|min:8|confirmed',
                'password_confirmation' => 'required',

            ]);

            if ($request->current_password == $request->password) {

                return response()->json(['error' => 'Your new password can not be the same as your old password. Please choose a new password.']);
            } else if ($request->password_confirmation != $request->password) {
                return response()->json(['error' => 'Your new password and confirm password does not match.']);
            } else {
                $user = Auth::guard('customer')->user();
                if (Hash::check($request->current_password, $user->password)) {
                    $user->password = Hash::make($request->password);
                    $user->save();
                    if ($request->session()->get('customerticket')) {
                        $request->session()->flush('customerticket');
                    }
                    Auth::guard('customer')->logout();

                    if (setting('REGISTER_POPUP') == 'yes') {

                        return response()->json(['success' => 'Password successfully changed!', 'redirect' => '/home']);
                    } else {

                        return response()->json(['success' => 'Password successfully changed!']);
                    }
                } else {

                    return response()->json(['error' => 'Current password does not match!']);
                }
            }
        } else {
            $request->validate([
                'password' => 'required|string|min:8|confirmed',
                'password_confirmation' => 'required',
            ]);
            if ($request->password == $request->password_confirmation) {
                $user = Auth::guard('customer')->user();
                $user->password = Hash::make($request->password);
                $user->save();
                if ($request->session()->get('customerticket')) {
                    $request->session()->flush('customerticket');
                }
                Auth::guard('customer')->logout();

                if (setting('REGISTER_POPUP') == 'yes') {

                    return response()->json(['success' => 'Password successfully changed!', 'redirect' => '/home']);
                } else {

                    return response()->json(['success' => 'Password successfully changed!']);
                }
            } else {
                return response()->json(['error' => 'Current password does not match!']);
            }
        }
    }
}
