<?php

namespace App\Http\Controllers\User\Auth\Passwords;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use DB;
use App\Models\Customer;
use Hash;
use App\Models\Announcement;
use App\Models\Apptitle;
use App\Models\Holiday;
use Carbon\Carbon;

class ResetpasswordController extends Controller
{
    public function resetpassword($token)
    {

        $title = Apptitle::first();
        $data['title'] = $title;

        $user = DB::table('password_resets')->where('token', $token)->first();
        $data['user'] = $user;
        $now = now();
        $announcement = announcement::whereDate('enddate', '>=', $now->toDateString())->whereDate('startdate', '<=', $now->toDateString())->get();
        $data['announcement'] = $announcement;

        $announcements = Announcement::whereNotNull('announcementday')->get();
        $data['announcements'] = $announcements;
        $currentYear = $now->year;
        $activeHolidays = Holiday::where('status', 1)->get();

        $data['holidays'] = $activeHolidays->filter(function ($holiday) use ($now, $currentYear) {
            $holidayStart = Carbon::parse($holiday->startdate);
            $holidayEnd = Carbon::parse($holiday->enddate);
            if ($holiday->is_fixed) {
                return $holidayStart->month === $now->month && $holidayStart->day === $now->day;
            }
            return $holidayStart->isSameDay($now);
        });

        return $data;
    }

    public function updatePassword(Request $request)
    {

        $request->validate([
            'email' => 'required|email|exists:customers',
            'password' => 'required|string|min:6|confirmed',
            'password_confirmation' => 'required',

        ]);

        $updatePassword = DB::table('password_resets')->where(['email' => $request->email, 'token' => $request->token])->first();

        if (!$updatePassword) return response()->json(['error' => 'Invalid token!']);

        $user = Customer::where('email', $request->email)->first();

        if (Hash::check($request->password, $user->password)) {
            return response()->json(['error' => 'Your New password cannot be same as your old password!']);
        }
        if ($user->password == null) {

            $user->update(['password' => Hash::make($request->password)]);
        } else {

            $user->update(['password' => Hash::make($request->password)]);
        }

        DB::table('password_resets')->where(['email' => $request->email])->delete();

        return response()->json(['success' => 'Your password has been changed!']);
    }
}
