<?php

namespace App\Http\Controllers\User\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Hash;
use App\Models\Customer;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Models\VerifyUser;
use Illuminate\Support\Facades\Validator;
use Response;
use App\Models\CustomerSetting;
use GeoIP;
use App\Traits\SocialAuthSettings;
use App\Models\SocialAuthSetting;

use App\Models\Customfield;
use App\Models\TicketCustomfield;
use App\Models\Announcement;
use App\Models\Apptitle;
use App\Models\Holiday;
use Carbon\Carbon;
use laravelLara\infoinst\Jobs\MailSend;

class RegisterController extends Controller
{
    use RegistersUsers, SocialAuthSettings;

    public function showRegistrationForm()
    {
        if (setting('REGISTER_DISABLE') != 'on') {
            abort(403);
        }

        $socialAuthSettings = SocialAuthSetting::first();
        $data['socialAuthSettings'] = $socialAuthSettings;

        $customfields = Customfield::whereIn('displaytypes', ['both', 'registerform'])->whereIn('status', [1])->get();
        $data['customfields'] = $customfields;
        $data['setting'] = response()->json(['login_disable' => setting('login_disable'), 'login_disable_statement' => setting('login_disable_statement'), 'CAPTCHATYPE' => setting('CAPTCHATYPE'), 'RECAPTCH_ENABLE_LOGIN' => setting('RECAPTCH_ENABLE_LOGIN'), 'RECAPTCH_ENABLE_REGISTER' => setting('RECAPTCH_ENABLE_REGISTER'), 'REGISTER_DISABLE' => setting('REGISTER_DISABLE'), 'GOOGLE_RECAPTCHA_KEY' => setting('GOOGLE_RECAPTCHA_KEY'), 'ANNOUNCEMENT_USER' => setting('ANNOUNCEMENT_USER'), 'terms_url' => setting('terms_url')]);

        $now = now();
        $announcement = announcement::whereDate('enddate', '>=', $now->toDateString())->whereDate('startdate', '<=', $now->toDateString())->get();
        $data['announcement'] = $announcement;

        $announcements = Announcement::whereNotNull('announcementday')->get();
        $data['announcements'] = $announcements;

        // $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', '1')->get();
        // $data['holidays'] =  $holidays;

        $now = now();
        $currentYear = $now->year;
        $activeHolidays = Holiday::where('status', 1)->get();


        $data['holidays'] = $activeHolidays->filter(function ($holiday) use ($now, $currentYear) {
            $holidayStart = Carbon::parse($holiday->startdate);
            $holidayEnd = Carbon::parse($holiday->enddate);
            if ($holiday->is_fixed) {
                return $holidayStart->month === $now->month && $holidayStart->day === $now->day;
            }
            return $holidayStart->isSameDay($now);
        });


        $title = Apptitle::first();
        $data['title'] = $title;

        return $data;
    }

    public function register(Request $request)
    {

        // if(setting('REGISTER_DISABLE') == 'off' || setting('mail_host') == 'smtp.mailtrap.io'){
        //     return Response::json(['error' => 'Techincal Issue']);
        // }

        $guest = Customer::where('email', '=', $request->email)->first();
        if (Customer::where('email', '=', $request->email)->exists()) {
            if ($guest->password == null && $guest->provider_id == null && $guest->userType == 'Guest') {

                if (setting('CAPTCHATYPE') == 'off') {
                    $validator = Validator::make($request->all(), [
                        'firstname' => 'required|max:255',
                        'lastname' => 'required|max:255',
                        'email' => 'required|email|max:255|indisposable',
                        'password' => 'required|min:8|confirmed',
                    ]);
                } else {
                    if (setting('CAPTCHATYPE') == 'manual') {
                        if (setting('RECAPTCH_ENABLE_REGISTER') == 'yes') {
                            $validator = Validator::make($request->all(), [
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|email|max:255|indisposable',
                                'password' => 'required|min:8|confirmed',
                                'captcha' => ['required', 'captcha'],
                            ]);
                        } else {
                            $validator = Validator::make($request->all(), [
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|email|max:255|indisposable',
                                'password' => 'required|min:8|confirmed',
                            ]);
                        }
                    }
                    if (setting('CAPTCHATYPE') == 'google') {
                        if (setting('RECAPTCH_ENABLE_REGISTER') == 'yes') {
                            $validator = Validator::make($request->all(), [
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|email|max:255|indisposable',
                                'password' => 'required|min:8|confirmed',
                                'g-recaptcha-response'  =>  'required|recaptcha',
                            ]);
                        } else {
                            $validator = Validator::make($request->all(), [
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|email|max:255|indisposable',
                                'password' => 'required|min:8|confirmed',
                            ]);
                        }
                    }
                }


                if ($validator->passes()) {
                    $geolocation = GeoIP::getLocation(request()->getClientIp());

                    $guest->firstname = $request->firstname;
                    $guest->lastname = $request->lastname;
                    $guest->username = $request->firstname . ' ' . $request->lastname;
                    $guest->password = Hash::make($request->password);
                    $guest->userType = 'Customer';
                    $guest->country = $geolocation->country;
                    $guest->timezone = $geolocation->timezone;
                    $guest->update();

                    $verifyUser = VerifyUser::create([
                        'cust_id' => $guest->id,
                        'token' => sha1(time())
                    ]);

                    $customfields = Customfield::whereIn('displaytypes', ['both', 'registerform'])->whereIn('status', [1])->get();

                    if ($customfields != false) {
                        foreach ($customfields as $customfield) {
                            $ticketcustomfield = new TicketCustomfield();
                            $ticketcustomfield->cust_id = $guest->id;
                            $ticketcustomfield->fieldnames = $customfield->fieldnames;
                            $ticketcustomfield->fieldtypes = $customfield->fieldtypes;
                            $ticketcustomfield->fieldoptions = $customfield->fieldoptions;
                            if ($customfield->fieldtypes == 'checkbox') {
                                if ($request->input('custom_' . $customfield->id) != null) {

                                    $string = implode(',', $request->input('custom_' . $customfield->id));
                                    $ticketcustomfield->values = $string;
                                }
                            }
                            if ($customfield->fieldtypes != 'checkbox') {
                                if ($customfield->fieldprivacy == '1') {
                                    $ticketcustomfield->privacymode  = $customfield->fieldprivacy;
                                    $ticketcustomfield->values = encrypt($request->input('custom_' . $customfield->id));
                                } else {

                                    $ticketcustomfield->values = $request->input('custom_' . $customfield->id);
                                }
                            }
                            $ticketcustomfield->save();
                        }
                    }
                    $verifyData = [

                        'username' => $guest->username,
                        'email' => $guest->email,
                        'email_verify_url' => url('/customer/user/verify/' . $verifyUser->token),

                    ];

                    if (setting('cust_email_verification') == 'on') {

                        try {

                            dispatch((new MailSend($guest->email, 'customer_sendmail_verification', $verifyData)));
                        } catch (\Exception $e) {


                            return Response::json(['success' => 'The email verification link was successfully sent. Please check and verify your email.']);
                        }
                        return Response::json(['success' => 'The email verification link was successfully sent. Please check and verify your email.']);
                    } else {
                        $guest->verified = 1;
                        $guest->save();
                        return Response::json(['success' => lang('You have been succesfully registered, Please login to continue.', 'alerts')]);
                    }
                } else {
                    return Response::json(['error' => $validator->errors()], 500);
                }
            } else {
                if (setting('CAPTCHATYPE') == 'off') {
                    $request->validate([
                        'firstname' => 'required|max:255',
                        'lastname' => 'required|max:255',
                        'email' => 'required|string|email|max:255|indisposable|unique:customers',
                        'password' => 'required|string|min:8|confirmed',
                        'password_confirmation' => 'required',
                        'agree_terms' =>  'required|in:agreed',
                    ]);
                } else {
                    if (setting('CAPTCHATYPE') == 'manual') {
                        if (setting('RECAPTCH_ENABLE_REGISTER') == 'yes') {
                            $request->validate([
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|string|email|max:255|indisposable|unique:customers',
                                'password' => 'required|string|min:8|confirmed',
                                'password_confirmation' => 'required',
                                'agree_terms' =>  'required|in:agreed',
                                'captcha' => ['required', 'captcha'],
                            ]);
                        } else {
                            $request->validate([
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|string|email|max:255|indisposable|unique:customers',
                                'password' => 'required|string|min:8|confirmed',
                                'password_confirmation' => 'required',
                                'agree_terms' =>  'required|in:agreed',

                            ]);
                        }
                    }
                    if (setting('CAPTCHATYPE') == 'google') {
                        if (setting('RECAPTCH_ENABLE_REGISTER') == 'yes') {
                            $request->validate([
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|string|email|max:255|indisposable|unique:customers',
                                'password' => 'required|string|min:8|confirmed',
                                'password_confirmation' => 'required',
                                'agree_terms' =>  'required|in:agreed',
                                'g-recaptcha-response'  =>  'required|recaptcha',

                            ]);
                        } else {
                            $request->validate([
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|string|email|max:255|indisposable|unique:customers',
                                'password' => 'required|string|min:8|confirmed',
                                'password_confirmation' => 'required',
                                'agree_terms' =>  'required|in:agreed',

                            ]);
                        }
                    }
                }
                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $user =  Customer::create([
                    'firstname' => $request->input('firstname'),
                    'lastname' => $request->input('lastname'),
                    'username' => $request->input('firstname') . ' ' . $request->input('lastname'),
                    'email' => $request->email,
                    'password' => Hash::make($request->password),
                    'userType' => 'Customer',
                    'country' => $geolocation->country,
                    'timezone' => $geolocation->timezone,
                    'status' => '1',
                    'image' => null,
                ]);
                $customersetting = new CustomerSetting();
                $customersetting->custs_id = $user->id;
                $customersetting->darkmode = setting('DARK_MODE');
                $customersetting->save();

                $verifyUser = VerifyUser::create([
                    'cust_id' => $user->id,
                    'token' => sha1(time())
                ]);

                $customfields = Customfield::whereIn('displaytypes', ['both', 'registerform'])->where('status', 1)->get();

                if ($customfields != false) {
                    foreach ($customfields as $customfield) {
                        $ticketcustomfield = new TicketCustomfield();
                        $ticketcustomfield->cust_id = $user->id;
                        $ticketcustomfield->fieldnames = $customfield->fieldnames;
                        $ticketcustomfield->fieldtypes = $customfield->fieldtypes;
                        $ticketcustomfield->fieldoptions = $customfield->fieldoptions;
                        if ($customfield->fieldtypes == 'checkbox') {
                            if ($request->input('custom_' . $customfield->id) != null) {

                                $string = implode(',', $request->input('custom_' . $customfield->id));
                                $ticketcustomfield->values = $string;
                            }
                        }
                        if ($customfield->fieldtypes != 'checkbox') {
                            if ($customfield->fieldprivacy == '1') {
                                $ticketcustomfield->privacymode  = $customfield->fieldprivacy;
                                $ticketcustomfield->values = encrypt($request->input('custom_' . $customfield->id));
                            } else {

                                $ticketcustomfield->values = $request->input('custom_' . $customfield->id);
                            }
                        }
                        $ticketcustomfield->save();
                    }
                }

                $verifyData = [

                    'username' => $user->username,
                    'email' => $user->email,
                    'email_verify_url' => url('/customer/user/verify/' . $verifyUser->token),

                ];
                if (setting('cust_email_verification') == 'on') {

                    try {

                        dispatch((new MailSend($user->email, 'customer_sendmail_verification', $verifyData)));
                    } catch (\Exception $e) {

                        return Response::json(['success' => 'The email verification link was successfully sent. Please check and verify your email.']);
                    }
                    return Response::json(['success' => 'The email verification link was successfully sent. Please check and verify your email.']);
                } else {
                    $user->verified = 1;
                    $user->save();
                    return Response::json(['success' => 'You have been succesfully registered, Please login to continue.']);
                }
            }
        } else {

            if (setting('CAPTCHATYPE') == 'off') {
                $request->validate([
                    'firstname' => 'required|max:255',
                    'lastname' => 'required|max:255',
                    'email' => 'required|string|email|max:255|indisposable|unique:customers',
                    'password' => 'required|string|min:8|confirmed',
                    'password_confirmation' => 'required',
                    'agree_terms' =>  'required|in:agreed',
                ]);
            } else {
                if (setting('CAPTCHATYPE') == 'manual') {
                    if (setting('RECAPTCH_ENABLE_REGISTER') == 'yes') {
                        $request->validate([
                            'firstname' => 'required|max:255',
                            'lastname' => 'required|max:255',
                            'email' => 'required|string|email|max:255|indisposable|unique:customers',
                            'password' => 'required|string|min:8|confirmed',
                            'password_confirmation' => 'required',
                            'agree_terms' =>  'required|in:agreed',
                            'captcha' => ['required', 'captcha'],
                        ]);
                    } else {
                        $request->validate([
                            'firstname' => 'required|max:255',
                            'lastname' => 'required|max:255',
                            'email' => 'required|string|email|max:255|indisposable|unique:customers',
                            'password' => 'required|string|min:8|confirmed',
                            'password_confirmation' => 'required',
                            'agree_terms' =>  'required|in:agreed',

                        ]);
                    }
                }
                if (setting('CAPTCHATYPE') == 'google') {
                    if (setting('RECAPTCH_ENABLE_REGISTER') == 'yes') {
                        $request->validate([
                            'firstname' => 'required|max:255',
                            'lastname' => 'required|max:255',
                            'email' => 'required|string|email|max:255|indisposable|unique:customers',
                            'password' => 'required|string|min:8|confirmed',
                            'password_confirmation' => 'required',
                            'agree_terms' =>  'required|in:agreed',
                            'g-recaptcha-response'  =>  'required|recaptcha',

                        ]);
                    } else {
                        $request->validate([
                            'firstname' => 'required|max:255',
                            'lastname' => 'required|max:255',
                            'email' => 'required|string|email|max:255|indisposable|unique:customers',
                            'password' => 'required|string|min:8|confirmed',
                            'password_confirmation' => 'required',
                            'agree_terms' =>  'required|in:agreed',

                        ]);
                    }
                }
            }
            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $user =  Customer::create([
                'firstname' => $request->input('firstname'),
                'lastname' => $request->input('lastname'),
                'username' => $request->input('firstname') . ' ' . $request->input('lastname'),
                'email' => $request->email,
                'password' => Hash::make($request->password),
                'userType' => 'Customer',
                'country' => $geolocation->country,
                'timezone' => $geolocation->timezone,
                'status' => '1',
                'image' => null,

            ]);

            $customersetting = new CustomerSetting();
            $customersetting->custs_id = $user->id;
            $customersetting->save();

            $customfields = Customfield::whereIn('displaytypes', ['both', 'registerform'])->where('status', 1)->get();

            if ($customfields != false) {
                foreach ($customfields as $customfield) {
                    $ticketcustomfield = new TicketCustomfield();
                    $ticketcustomfield->cust_id = $user->id;
                    $ticketcustomfield->fieldnames = $customfield->fieldnames;
                    $ticketcustomfield->fieldtypes = $customfield->fieldtypes;
                    $ticketcustomfield->fieldoptions = $customfield->fieldoptions;
                    if ($customfield->fieldtypes == 'checkbox') {
                        if ($request->input('custom_' . $customfield->id) != null) {

                            $string = implode(',', $request->input('custom_' . $customfield->id));
                            $ticketcustomfield->values = $string;
                        }
                    }
                    if ($customfield->fieldtypes != 'checkbox') {
                        if ($customfield->fieldprivacy == '1') {
                            $ticketcustomfield->privacymode  = $customfield->fieldprivacy;
                            $ticketcustomfield->values = encrypt($request->input('custom_' . $customfield->id));
                        } else {

                            $ticketcustomfield->values = $request->input('custom_' . $customfield->id);
                        }
                    }
                    $ticketcustomfield->save();
                }
            }

            $verifyUser = VerifyUser::create([
                'cust_id' => $user->id,
                'token' => sha1(time())
            ]);
            $verifyData = [
                'username' => $user->username,
                'email' => $user->email,
                'email_verify_url' => url('/customer/user/verify/' . $verifyUser->token),

            ];
            if (setting('cust_email_verification') == 'on') {

                try {

                    dispatch((new MailSend($user->email, 'customer_sendmail_verification', $verifyData)));
                } catch (\Exception $e) {

                    return Response::json(['success' => 'The email verification link was successfully sent. Please check and verify your email.']);
                }
                return Response::json(['success' => 'The email verification link was successfully sent. Please check and verify your email.']);
            } else {
                $user->verified = 1;
                $user->save();
                return Response::json(['success' => lang('You have been succesfully registered, Please login to continue.', 'alerts')]);
            }
        }
    }

    public function registers(Request $request)
    {
        if (setting('REGISTER_DISABLE') == 'off') {
            return Response::json(['success' => 'Techincal Issue']);
        }

        $guest = Customer::where('email', '=', $request->email)->first();
        if (Customer::where('email', '=', $request->email)->exists()) {
            if ($guest->password == null && $guest->provider_id == null && $guest->userType == 'Guest') {


                if (setting('CAPTCHATYPE') == 'off') {
                    $validator = Validator::make($request->all(), [
                        'firstname' => 'required|max:255',
                        'lastname' => 'required|max:255',
                        'email' => 'required|email|max:255|indisposable|unique:customers',
                        'password' => 'required|min:8|confirmed',
                        'password_confirmation' => 'required|min:8',
                        'agree_terms' =>  'required|in:agreed',

                    ]);
                } else {
                    if (setting('CAPTCHATYPE') == 'manual') {
                        if (setting('RECAPTCH_ENABLE_REGISTER') == 'yes') {
                            $validator = Validator::make($request->all(), [
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|email|max:255|indisposable|unique:customers',
                                'password' => 'required|min:8|confirmed',
                                'password_confirmation' => 'required|min:8',
                                'agree_terms' =>  'required|in:agreed',
                                'captcha' => ['required', 'captcha'],
                            ]);
                        } else {
                            $validator = Validator::make($request->all(), [
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|email|max:255|indisposable|unique:customers',
                                'password' => 'required|min:8|confirmed',
                                'password_confirmation' => 'required|min:8',
                                'agree_terms' =>  'required|in:agreed',

                            ]);
                        }
                    }
                    if (setting('CAPTCHATYPE') == 'google') {
                        if (setting('RECAPTCH_ENABLE_REGISTER') == 'yes') {
                            $validator = Validator::make($request->all(), [
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|email|max:255|indisposable|unique:customers',
                                'password' => 'required|min:8|confirmed',
                                'password_confirmation' => 'required|min:8',
                                'agree_terms' =>  'required|in:agreed',
                                'g-recaptcha-response'  =>  'recaptcha',
                            ]);
                        } else {
                            $validator = Validator::make($request->all(), [
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|email|max:255|indisposable|unique:customers',
                                'password' => 'required|min:8|confirmed',
                                'password_confirmation' => 'required|min:8',
                                'agree_terms' =>  'required|in:agreed',

                            ]);
                        }
                    }
                }

                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $guest->firstname = $request->firstname;
                $guest->lastname = $request->lastname;
                $guest->username = $request->firstname . ' ' . $request->lastname;
                $guest->password = Hash::make($request->password);
                $guest->userType = 'Customer';
                $guest->country = $geolocation->country;
                $guest->timezone = $geolocation->timezone;
                $guest->update();

                $verifyUser = VerifyUser::create([
                    'cust_id' => $guest->id,
                    'token' => sha1(time())
                ]);

                $customfields = Customfield::whereIn('displaytypes', ['both', 'registerform'])->whereIn('status', [1])->get();

                if ($customfields != false) {
                    foreach ($customfields as $customfield) {
                        $ticketcustomfield = new TicketCustomfield();
                        $ticketcustomfield->cust_id = $guest->id;
                        $ticketcustomfield->fieldnames = $customfield->fieldnames;
                        $ticketcustomfield->fieldtypes = $customfield->fieldtypes;
                        $ticketcustomfield->fieldoptions = $customfield->fieldoptions;
                        if ($customfield->fieldtypes == 'checkbox') {
                            if ($request->input('custom_' . $customfield->id) != null) {

                                $string = implode(',', $request->input('custom_' . $customfield->id));
                                $ticketcustomfield->values = $string;
                            }
                        }
                        if ($customfield->fieldtypes != 'checkbox') {
                            if ($customfield->fieldprivacy == '1') {
                                $ticketcustomfield->privacymode  = $customfield->fieldprivacy;
                                $ticketcustomfield->values = encrypt($request->input('custom_' . $customfield->id));
                            } else {

                                $ticketcustomfield->values = $request->input('custom_' . $customfield->id);
                            }
                        }
                        $ticketcustomfield->save();
                    }
                }
                $verifyData = [

                    'username' => $guest->username,
                    'email' => $guest->email,
                    'email_verify_url' => url('/customer/user/verify/' . $verifyUser->token),

                ];
                if (setting('cust_email_verification') == 'on') {
                    try {
                        dispatch((new MailSend($guest->email, 'customer_sendmail_verification', $verifyData)));
                    } catch (\Exception $e) {

                        return Response::json(['success' => 'The email verification link was successfully sent. Please check and verify your email.']);
                    }
                    return Response::json(['success' => 'The email verification link was successfully sent. Please check and verify your email.']);
                } else {
                    $guest->verified = 1;
                    $guest->save();
                    return Response::json(['success' => 'You have been succesfully registered, Please login to continue.']);
                }
            } else {
                if (setting('CAPTCHATYPE') == 'off') {
                    $validator = Validator::make($request->all(), [
                        'firstname' => 'required|max:255',
                        'lastname' => 'required|max:255',
                        'email' => 'required|email|max:255|indisposable|unique:customers',
                        'password' => 'required|min:8|confirmed',
                        'password_confirmation' => 'required|min:8',
                        'agree_terms' =>  'required|in:agreed',

                    ]);
                } else {
                    if (setting('CAPTCHATYPE') == 'manual') {
                        if (setting('RECAPTCH_ENABLE_REGISTER') == 'yes') {
                            $validator = Validator::make($request->all(), [
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|email|max:255|indisposable|unique:customers',
                                'password' => 'required|min:8|confirmed',
                                'password_confirmation' => 'required|min:8',
                                'agree_terms' =>  'required|in:agreed',
                                'captcha' => ['required', 'captcha'],
                            ]);
                        } else {
                            $validator = Validator::make($request->all(), [
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|email|max:255|indisposable|unique:customers',
                                'password' => 'required|min:8|confirmed',
                                'password_confirmation' => 'required|min:8',
                                'agree_terms' =>  'required|in:agreed',

                            ]);
                        }
                    }
                    if (setting('CAPTCHATYPE') == 'google') {
                        if (setting('RECAPTCH_ENABLE_REGISTER') == 'yes') {
                            $validator = Validator::make($request->all(), [
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|email|max:255|indisposable|unique:customers',
                                'password' => 'required|min:8|confirmed',
                                'password_confirmation' => 'required|min:8',
                                'agree_terms' =>  'required|in:agreed',
                                'g-recaptcha-response'  =>  'recaptcha',
                            ]);
                        } else {
                            $validator = Validator::make($request->all(), [
                                'firstname' => 'required|max:255',
                                'lastname' => 'required|max:255',
                                'email' => 'required|email|max:255|indisposable|unique:customers',
                                'password' => 'required|min:8|confirmed',
                                'password_confirmation' => 'required|min:8',
                                'agree_terms' =>  'required|in:agreed',

                            ]);
                        }
                    }
                }


                if ($validator->passes()) {

                    // Store your user in database 
                    $geolocation = GeoIP::getLocation(request()->getClientIp());
                    $user =  Customer::create([
                        'firstname' => $request->input('firstname'),
                        'lastname' => $request->input('lastname'),
                        'username' => $request->input('firstname') . ' ' . $request->input('lastname'),
                        'email' => $request->email,
                        'password' => Hash::make($request->password),
                        'userType' => 'Customer',
                        'country' => $geolocation->country,
                        'timezone' => $geolocation->timezone,
                        'status' => '1',
                        'image' => null,

                    ]);

                    $customersetting = new CustomerSetting();
                    $customersetting->custs_id = $user->id;
                    $customersetting->darkmode = setting('DARK_MODE');
                    $customersetting->save();

                    $verifyUser = VerifyUser::create([
                        'cust_id' => $user->id,
                        'token' => sha1(time())
                    ]);

                    $customfields = Customfield::whereIn('displaytypes', ['both', 'registerform'])->whereIn('status', [1])->get();

                    if ($customfields != false) {
                        foreach ($customfields as $customfield) {
                            $ticketcustomfield = new TicketCustomfield();
                            $ticketcustomfield->cust_id = $user->id;
                            $ticketcustomfield->fieldnames = $customfield->fieldnames;
                            $ticketcustomfield->fieldtypes = $customfield->fieldtypes;
                            $ticketcustomfield->fieldoptions = $customfield->fieldoptions;
                            if ($customfield->fieldtypes == 'checkbox') {
                                if ($request->input('custom_' . $customfield->id) != null) {

                                    $string = implode(',', $request->input('custom_' . $customfield->id));
                                    $ticketcustomfield->values = $string;
                                }
                            }
                            if ($customfield->fieldtypes != 'checkbox') {
                                if ($customfield->fieldprivacy == '1') {
                                    $ticketcustomfield->privacymode  = $customfield->fieldprivacy;
                                    $ticketcustomfield->values = encrypt($request->input('custom_' . $customfield->id));
                                } else {

                                    $ticketcustomfield->values = $request->input('custom_' . $customfield->id);
                                }
                            }
                            $ticketcustomfield->save();
                        }
                    }
                    $verifyData = [

                        'username' => $user->username,
                        'email' => $user->email,
                        'email_verify_url' => url('/customer/user/verify/' . $verifyUser->token),

                    ];

                    if (setting('cust_email_verification') == 'on') {

                        try {

                            dispatch((new MailSend($user->email, 'customer_sendmail_verification', $verifyData)));
                        } catch (\Exception $e) {

                            return Response::json(['success' => 'The email verification link was successfully sent. Please check and verify your email.']);
                        }
                        return Response::json(['success' => 'The email verification link was successfully sent. Please check and verify your email.']);
                    } else {
                        $user->verified = 1;
                        $user->save();
                        return Response::json(['success' => 'You have been succesfully registered, Please login to continue.']);
                    }
                }

                return Response::json(['errors' => $validator->errors()]);
            }
        } else {

            if (setting('CAPTCHATYPE') == 'off') {
                $validator = Validator::make($request->all(), [
                    'firstname' => 'required|',
                    'lastname' => 'required|',
                    'email' => 'required|email|max:255|indisposable|unique:customers',
                    'password' => 'required|min:8|confirmed',
                    'password_confirmation' => 'required|min:8',
                    'agree_terms' =>  'required|in:agreed',

                ]);
            } else {
                if (setting('CAPTCHATYPE') == 'manual') {
                    if (setting('RECAPTCH_ENABLE_REGISTER') == 'yes') {
                        $validator = Validator::make($request->all(), [
                            'firstname' => 'required|max:255',
                            'lastname' => 'required|max:255',
                            'email' => 'required|email|max:255|indisposable|unique:customers',
                            'password' => 'required|min:8|confirmed',
                            'password_confirmation' => 'required|min:8',
                            'agree_terms' =>  'required|in:agreed',
                            'captcha' => ['required', 'captcha'],
                        ]);
                    } else {
                        $validator = Validator::make($request->all(), [
                            'firstname' => 'required|max:255',
                            'lastname' => 'required|max:255',
                            'email' => 'required|email|max:255|indisposable|unique:customers',
                            'password' => 'required|min:8|confirmed',
                            'password_confirmation' => 'required|min:8',
                            'agree_terms' =>  'required|in:agreed',

                        ]);
                    }
                }
                if (setting('CAPTCHATYPE') == 'google') {
                    if (setting('RECAPTCH_ENABLE_REGISTER') == 'yes') {
                        $validator = Validator::make($request->all(), [
                            'firstname' => 'required|max:255',
                            'lastname' => 'required|max:255',
                            'email' => 'required|email|max:255|indisposable|unique:customers',
                            'password' => 'required|min:8|confirmed',
                            'password_confirmation' => 'required|min:8',
                            'agree_terms' =>  'required|in:agreed',
                            'grecaptcharesponse'  =>  'recaptcha',
                        ]);
                    } else {
                        $validator = Validator::make($request->all(), [
                            'firstname' => 'required|max:255',
                            'lastname' => 'required|max:255',
                            'email' => 'required|email|max:255|indisposable|unique:customers',
                            'password' => 'required|min:8|confirmed',
                            'password_confirmation' => 'required|min:8',
                            'agree_terms' =>  'required|in:agreed',

                        ]);
                    }
                }
            }


            if ($validator->passes()) {

                // Store your user in database 
                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $user =  Customer::create([
                    'firstname' => $request->input('firstname'),
                    'lastname' => $request->input('lastname'),
                    'username' => $request->input('firstname') . ' ' . $request->input('lastname'),
                    'email' => $request->email,
                    'password' => Hash::make($request->password),
                    'userType' => 'Customer',
                    'country' => $geolocation->country,
                    'timezone' => $geolocation->timezone,
                    'status' => '1',
                    'image' => null,

                ]);

                $customersetting = new CustomerSetting();
                $customersetting->custs_id = $user->id;
                $customersetting->darkmode = setting('DARK_MODE');
                $customersetting->save();

                $verifyUser = VerifyUser::create([
                    'cust_id' => $user->id,
                    'token' => sha1(time())
                ]);

                $customfields = Customfield::whereIn('displaytypes', ['both', 'registerform'])->whereIn('status', [1])->get();

                if ($customfields != false) {
                    foreach ($customfields as $customfield) {
                        $ticketcustomfield = new TicketCustomfield();
                        $ticketcustomfield->cust_id = $user->id;
                        $ticketcustomfield->fieldnames = $customfield->fieldnames;
                        $ticketcustomfield->fieldtypes = $customfield->fieldtypes;
                        $ticketcustomfield->fieldoptions = $customfield->fieldoptions;
                        if ($customfield->fieldtypes == 'checkbox') {
                            if ($request->input('custom_' . $customfield->id) != null) {

                                $string = implode(',', $request->input('custom_' . $customfield->id));
                                $ticketcustomfield->values = $string;
                            }
                        }
                        if ($customfield->fieldtypes != 'checkbox') {
                            if ($customfield->fieldprivacy == '1') {
                                $ticketcustomfield->privacymode  = $customfield->fieldprivacy;
                                $ticketcustomfield->values = encrypt($request->input('custom_' . $customfield->id));
                            } else {

                                $ticketcustomfield->values = $request->input('custom_' . $customfield->id);
                            }
                        }
                        $ticketcustomfield->save();
                    }
                }
                $verifyData = [

                    'username' => $user->username,
                    'email' => $user->email,
                    'email_verify_url' => url('/customer/user/verify/' . $verifyUser->token),

                ];

                // try {
                //     dispatch((new MailSend($user->email, 'customer_sendmail_verification', $verifyData)));
                // } catch (\Exception $e) {

                //     return Response::json(['success' => '1']);
                // }

                // return Response::json(['success' => '1']);
                if (setting('cust_email_verification') == 'on') {

                    try {

                        dispatch((new MailSend($user->email, 'customer_sendmail_verification', $verifyData)));
                    } catch (\Exception $e) {

                        return Response::json(['success' => 'The email verification link was successfully sent. Please check and verify your email.']);
                    }
                    return Response::json(['success' => 'The email verification link was successfully sent. Please check and verify your email.']);
                } else {
                    $user->verified = 1;
                    $user->save();
                    return Response::json(['success' => 'You have been succesfully registered, Please login to continue.']);
                }
            }

            return Response::json(['errors' => $validator->errors()]);
        }
    }
    public function verifyUser($token)
    {
        $verifyUser = VerifyUser::where('token', $token)->first();
        if ($verifyUser != null && $verifyUser->user != null) {
            if (isset($verifyUser)) {
                $user = $verifyUser->user;
                if (!$user->verified) {
                    $verifyUser->user->verified = 1;
                    $verifyUser->user->save();
                    $status = 'Your e-mail has been verified. You can now login.';
                } else {
                    $status = 'Your e-mail has already been verified. You can now login.';
                }
            } else {
                return response()->json(['warning' => 'Sorry, your email could not be determined.']);
            }
            if (setting('REGISTER_POPUP') == 'yes') {
                return response()->json(['success' => $status, 'redirect' => true]);
            } else {
                return response()->json(['success' => $status]);
            }
        } else {
            return response()->json(['warning' => 'Sorry, your email could not be determined.']);
        }
    }
}
